/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.diffleverage;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private int fuzzyThreshold;
    private boolean codesensitive;
    private boolean diffOnly;
    private boolean copyToTarget;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.fuzzyThreshold = 100;
        this.codesensitive = true;
        this.diffOnly = false;
        this.copyToTarget = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.fuzzyThreshold = this.buffer.getInteger("fuzzyThreshold", this.fuzzyThreshold);
        this.codesensitive = this.buffer.getBoolean("codesensitive", this.codesensitive);
        this.diffOnly = this.buffer.getBoolean("diffOnly", this.diffOnly);
        this.copyToTarget = this.buffer.getBoolean("copyToTarget", this.copyToTarget);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter("fuzzyThreshold", this.fuzzyThreshold);
        this.buffer.setParameter("codesensitive", this.codesensitive);
        this.buffer.setParameter("diffOnly", this.diffOnly);
        this.buffer.setParameter("copyToTarget", this.copyToTarget);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("fuzzyThreshold", "Leverage only if the match is equal or above this score", "Fuzzy Thresholds are between 1 and 100. A score of 100 emans exact match (codes and text) only");
        desc.add("codesensitive", "Include inline codes in the comparison", "Use codes to compare contents");
        desc.add("diffOnly", "Diff only and mark the TextUnit as matched", "Diff only and do not copy the match or create a leverage annotation");
        desc.add("copyToTarget", "Copy to/over the target? (WARNING: Copied target will not be segmented!)", "Copy to/over the target (a leverage annotation will still be created). WARNING: Copied target will not be segmented and any exisiting target will be lost.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Diff Leverage", true, false);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get("fuzzyThreshold"));
        sip.setRange(1, 100);
        sip.setVertical(false);
        desc.addCheckboxPart(paramsDesc.get("codesensitive"));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get("diffOnly"));
        desc.addCheckboxPart(paramsDesc.get("copyToTarget"));
        return desc;
    }

    public int getFuzzyThreshold() {
        return this.fuzzyThreshold;
    }

    public void setFuzzyThreshold(int fuzzyThreshold) {
        this.fuzzyThreshold = fuzzyThreshold;
    }

    public boolean isCodesensitive() {
        return this.codesensitive;
    }

    public void setCodesensitive(boolean codesensitive) {
        this.codesensitive = codesensitive;
    }

    public boolean isDiffOnly() {
        return this.diffOnly;
    }

    public void setDiffOnly(boolean diffOnly) {
        this.diffOnly = diffOnly;
    }

    public void setCopyToTarget(boolean copyToTarget) {
        this.copyToTarget = copyToTarget;
    }

    public boolean isCopyToTarget() {
        return this.copyToTarget;
    }
}

