/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idbasedcopy;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String MARKASTRANSLATENO = "markAsTranslateNo";
    private static final String MARKASAPPROVED = "markAsApproved";
    private boolean markAsTranslateNo;
    private boolean markAsApproved;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.markAsTranslateNo = this.buffer.getBoolean(MARKASTRANSLATENO, this.markAsTranslateNo);
        this.markAsApproved = this.buffer.getBoolean(MARKASAPPROVED, this.markAsApproved);
    }

    @Override
    public void reset() {
        this.markAsTranslateNo = false;
        this.markAsApproved = true;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(MARKASTRANSLATENO, this.markAsTranslateNo);
        this.buffer.setBoolean(MARKASAPPROVED, this.markAsApproved);
        return this.buffer.toString();
    }

    public boolean getMarkAsTranslateNo() {
        return this.markAsTranslateNo;
    }

    public void setMarkAsTranslateNo(boolean markAsTranslateNo) {
        this.markAsTranslateNo = markAsTranslateNo;
    }

    public boolean getMarkAsApproved() {
        return this.markAsApproved;
    }

    public void setMarkAsApproved(boolean markAsApproved) {
        this.markAsApproved = markAsApproved;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(MARKASTRANSLATENO, "Set the text unit as non-translatable", null);
        desc.add(MARKASAPPROVED, "Set the target property 'approved' to 'yes'", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Id-Based Copy Settings");
        desc.addTextLabelPart("If the text unit has a match:");
        desc.addCheckboxPart(paramsDesc.get(MARKASTRANSLATENO));
        desc.addCheckboxPart(paramsDesc.get(MARKASAPPROVED));
        return desc;
    }
}

