/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import java.util.Comparator;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;

public class EventComparator
implements Comparator<Event> {
    private static final int MIN_LENGTH = 10;
    private static final String WHITESPACE_REGEX = "[ \t\r\n\f\u200b]+";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[ \t\r\n\f\u200b]+");
    private int minLength;

    public EventComparator() {
        this.minLength = 10;
    }

    public EventComparator(int minLength) {
        this.minLength = minLength;
    }

    @Override
    public int compare(Event srcEvent, Event trgEvent) {
        if (srcEvent == null || trgEvent == null) {
            return -1;
        }
        if (srcEvent.getEventType() != trgEvent.getEventType()) {
            return -1;
        }
        if (srcEvent.getEventType() == EventType.DOCUMENT_PART && trgEvent.getEventType() == EventType.DOCUMENT_PART) {
            String src = WHITESPACE_PATTERN.matcher(srcEvent.getDocumentPart().toString()).replaceAll("");
            String trg = WHITESPACE_PATTERN.matcher(trgEvent.getDocumentPart().toString()).replaceAll("");
            if (src.length() <= this.minLength || trg.length() <= this.minLength) {
                return -1;
            }
            return src.compareTo(trg);
        }
        return -1;
    }
}

