/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.postprocess.Merger;
import net.sf.okapi.steps.rainbowkit.postprocess.Parameters;

@UsingParameters(value=Parameters.class)
public class MergingStep
extends BasePipelineStep {
    public static final String NAME = "Rainbow Translation Kit Merging";
    private Parameters params = new Parameters();
    private MergingInfo info;
    private Merger merger;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;

    @Override
    public String getDescription() {
        return "Post-process a Rainbow translation kit. Expects: filter events. Sends back: filter events or raw documents.";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                return this.handleStartDocument(event);
            }
        }
        if (this.merger != null) {
            return this.merger.handleEvent(event);
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        this.info = sd.getAnnotation(MergingInfo.class);
        if (this.info == null) {
            throw new OkapiBadFilterInputException("Start document is missing the merging info annotation.");
        }
        Manifest manifest = sd.getAnnotation(Manifest.class);
        if (manifest == null) {
            throw new OkapiBadFilterInputException("Start document is missing the manifest annotation.");
        }
        boolean alwaysForceTargetLocale = "ontram".equals(this.info.getExtractionType());
        LocaleId targetLocaleToUse = this.params.getForceTargetLocale() || alwaysForceTargetLocale ? this.targetLocale : null;
        this.merger = new Merger(manifest, this.fcMapper, this.params.getPreserveSegmentation(), targetLocaleToUse, this.params.getReturnRawDocument(), this.params.getOverrideOutputPath());
        return this.merger.startMerging(this.info, event);
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

