/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.searchandreplace;

import java.util.ArrayList;
import net.sf.okapi.common.BaseParameters;

public class Parameters
extends BaseParameters {
    public boolean regEx;
    public boolean dotAll;
    public boolean ignoreCase;
    public boolean multiLine;
    public boolean target;
    public boolean source;
    public boolean replaceALL;
    public ArrayList<String[]> rules;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.regEx = false;
        this.dotAll = false;
        this.ignoreCase = false;
        this.multiLine = false;
        this.target = true;
        this.source = false;
        this.replaceALL = true;
        this.rules = new ArrayList();
    }

    public void addRule(String[] pattern) {
        this.rules.add(pattern);
    }

    public ArrayList<String[]> getRules() {
        return this.rules;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.regEx = this.buffer.getBoolean("regEx", this.regEx);
        this.dotAll = this.buffer.getBoolean("dotAll", this.dotAll);
        this.ignoreCase = this.buffer.getBoolean("ignoreCase", this.ignoreCase);
        this.multiLine = this.buffer.getBoolean("multiLine", this.multiLine);
        this.target = this.buffer.getBoolean("target", this.target);
        this.source = this.buffer.getBoolean("source", this.source);
        this.replaceALL = this.buffer.getBoolean("replaceALL", this.replaceALL);
        int count = this.buffer.getInteger("count", 0);
        for (int i = 0; i < count; ++i) {
            String[] s = new String[]{this.buffer.getString(String.format("use%d", i), ""), this.buffer.getString(String.format("search%d", i), ""), this.buffer.getString(String.format("replace%d", i), "")};
            this.rules.add(s);
        }
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean("regEx", this.regEx);
        this.buffer.setBoolean("dotAll", this.dotAll);
        this.buffer.setBoolean("ignoreCase", this.ignoreCase);
        this.buffer.setBoolean("multiLine", this.multiLine);
        this.buffer.setInteger("count", this.rules.size());
        this.buffer.setBoolean("target", this.target);
        this.buffer.setBoolean("source", this.source);
        this.buffer.setBoolean("replaceALL", this.replaceALL);
        int i = 0;
        for (String[] temp : this.rules) {
            this.buffer.setString(String.format("use%d", i), temp[0]);
            this.buffer.setString(String.format("search%d", i), temp[1]);
            this.buffer.setString(String.format("replace%d", i), temp[2]);
            ++i;
        }
        return this.buffer.toString();
    }
}

