/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.sentencealigner;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.gcaligner.AlignmentFunction;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import net.sf.okapi.steps.gcaligner.DpMatrix;
import net.sf.okapi.steps.gcaligner.DpMatrixCell;
import net.sf.okapi.steps.gcaligner.Penalties;

public class SentenceAligner {
    private static final Logger LOGGER = Logger.getLogger(SentenceAligner.class.getName());
    private static final long MAX_CELL_SIZE = 80000L;
    private List<AlignmentScorer<Segment>> scorerList;

    public SentenceAligner(List<AlignmentScorer<Segment>> scorerList) {
        this.scorerList = scorerList;
    }

    public ITextUnit align(ITextUnit sourceParagraph, ITextUnit targetParagraph, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        return this.alignWithoutSkeletonAlignment(sourceParagraph, targetParagraph, srcLocale, trgLocale, outputOneTOneMatchesOnly);
    }

    public ITextUnit align(ITextUnit bilingualParagraph, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        return this.alignWithoutSkeletonAlignment(bilingualParagraph, srcLocale, trgLocale, outputOneTOneMatchesOnly);
    }

    private ITextUnit alignWithoutSkeletonAlignment(ITextUnit sourceParagraph, ITextUnit targetParagraph, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        AlignmentFunction<Segment> alignmentFunction = new AlignmentFunction<Segment>(srcLocale, trgLocale, this.scorerList, new Penalties());
        return this.alignSegments(sourceParagraph, targetParagraph, srcLocale, trgLocale, alignmentFunction, outputOneTOneMatchesOnly);
    }

    private ITextUnit alignWithoutSkeletonAlignment(ITextUnit bilingualParagraph, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        AlignmentFunction<Segment> alignmentFunction = new AlignmentFunction<Segment>(srcLocale, trgLocale, this.scorerList, new Penalties());
        return this.alignSegments(bilingualParagraph, srcLocale, trgLocale, alignmentFunction, outputOneTOneMatchesOnly);
    }

    private ITextUnit alignSegments(ITextUnit sourceParagraph, ITextUnit targetParagraph, LocaleId srcLocale, LocaleId trgLocale, AlignmentFunction<Segment> alignmentFunction, boolean outputOneTOneMatchesOnly) {
        if ((long)(sourceParagraph.getSource().getSegments().count() * targetParagraph.getSource().getSegments().count()) > 80000L) {
            throw new IllegalArgumentException("Too many segments. Can only align " + Long.toString(80000L) + ". Where the number equals the source segments times the target segments.");
        }
        DpMatrix<Segment> matrix = new DpMatrix<Segment>(sourceParagraph.getSource().getSegments().asList(), targetParagraph.getSource().getSegments().asList(), alignmentFunction);
        List<DpMatrixCell> result = matrix.align();
        LinkedList<AlignedPair> alignedPairs = new LinkedList<AlignedPair>();
        String srcTuid = sourceParagraph.getName();
        for (DpMatrixCell cell : result) {
            Segment targetSegment;
            Segment sourceSegment;
            if (outputOneTOneMatchesOnly) {
                if (cell.getState() != 3) continue;
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                targetSegment = matrix.getAlignmentElementY(cell.getYindex());
                alignedPairs.add(new AlignedPair(sourceSegment, targetSegment, trgLocale));
                continue;
            }
            if (cell.getState() == 1) {
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                alignedPairs.add(new AlignedPair(sourceSegment, null, trgLocale));
                LOGGER.warning(sourceSegment.toString() + "\nTarget segment deleted (TU ID: " + srcTuid + "): Non 1-1 match. Please confirm alignment.");
                continue;
            }
            if (cell.getState() == 2) {
                Segment targetSegment2 = matrix.getAlignmentElementY(cell.getYindex());
                alignedPairs.add(new AlignedPair(null, targetSegment2, trgLocale));
                LOGGER.warning(targetSegment2.toString() + "\nSource segment deleted (TU ID: " + srcTuid + "): Non 1-1 match. Please confirm alignment.");
                continue;
            }
            if (cell.getState() == 3) {
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                targetSegment = matrix.getAlignmentElementY(cell.getYindex());
                alignedPairs.add(new AlignedPair(sourceSegment, targetSegment, trgLocale));
                continue;
            }
            if (cell.getState() != 4) continue;
            List<Segment> sourceSegments = matrix.getAlignmentElementsX(cell.getMultiMatchXIndexBegin(), cell.getMultiMatchXIndexEnd());
            List<Segment> targetSegments = matrix.getAlignmentElementsY(cell.getMultiMatchYIndexBegin(), cell.getMultiMatchYIndexEnd());
            alignedPairs.add(new AlignedPair(new LinkedList<TextPart>(sourceSegments), new LinkedList<TextPart>(targetSegments), trgLocale));
            Segment s = null;
            try {
                s = sourceSegments.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                s = targetSegments.get(0);
            }
            LOGGER.warning(s.toString() + "\nMulti-Segment Match (TU ID: " + srcTuid + "): Non 1-1 match. Please confirm alignment.");
        }
        sourceParagraph.getAlignedSegments().align(alignedPairs, trgLocale);
        return sourceParagraph;
    }

    private ITextUnit alignSegments(ITextUnit bilingualParagraph, LocaleId srcLocale, LocaleId trgLocale, AlignmentFunction<Segment> alignmentFunction, boolean outputOneTOneMatchesOnly) {
        if ((long)(bilingualParagraph.getSource().getSegments().count() * bilingualParagraph.getTarget(trgLocale).getSegments().count()) > 80000L) {
            throw new IllegalArgumentException("Too many segments. Can only align " + Long.toString(80000L) + ". Where the number equals the source segments times the target segments.");
        }
        DpMatrix<Segment> matrix = new DpMatrix<Segment>(bilingualParagraph.getSource().getSegments().asList(), bilingualParagraph.getTarget(trgLocale).getSegments().asList(), alignmentFunction);
        List<DpMatrixCell> result = matrix.align();
        LinkedList<AlignedPair> alignedPairs = new LinkedList<AlignedPair>();
        for (DpMatrixCell cell : result) {
            Segment targetSegment;
            Segment sourceSegment;
            if (outputOneTOneMatchesOnly) {
                if (cell.getState() != 3) continue;
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                targetSegment = matrix.getAlignmentElementY(cell.getYindex());
                alignedPairs.add(new AlignedPair(sourceSegment, targetSegment, trgLocale));
                continue;
            }
            if (cell.getState() == 1) {
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                alignedPairs.add(new AlignedPair(sourceSegment, null, trgLocale));
                continue;
            }
            if (cell.getState() == 2) {
                Segment targetSegment2 = matrix.getAlignmentElementY(cell.getYindex());
                alignedPairs.add(new AlignedPair(null, targetSegment2, trgLocale));
                continue;
            }
            if (cell.getState() == 3) {
                sourceSegment = matrix.getAlignmentElementX(cell.getXindex());
                targetSegment = matrix.getAlignmentElementY(cell.getYindex());
                alignedPairs.add(new AlignedPair(sourceSegment, targetSegment, trgLocale));
                continue;
            }
            if (cell.getState() != 4) continue;
            List<Segment> sourceSegments = matrix.getAlignmentElementsX(cell.getMultiMatchXIndexBegin(), cell.getMultiMatchXIndexEnd());
            List<Segment> targetSegments = matrix.getAlignmentElementsY(cell.getMultiMatchYIndexBegin(), cell.getMultiMatchYIndexEnd());
            alignedPairs.add(new AlignedPair(new LinkedList<TextPart>(sourceSegments), new LinkedList<TextPart>(targetSegments), trgLocale));
        }
        bilingualParagraph.getAlignedSegments().align(alignedPairs, trgLocale);
        return bilingualParagraph;
    }
}

