/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.ULocale;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.wordcount.ParametersSimpleWordCountStep;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public class SimpleWordCountStep
extends BasePipelineStep {
    private RuleBasedBreakIterator srcWordIterator = null;
    private RuleBasedBreakIterator trgWordIterator = null;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private long srcBatchItemWordCount;
    private long srcBatchWordCount;
    private ParametersSimpleWordCountStep params = new ParametersSimpleWordCountStep();

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.srcLoc = sourceLocale;
        this.srcWordIterator = (RuleBasedBreakIterator)BreakIterator.getWordInstance(ULocale.createCanonical(this.srcLoc.toString()));
        RuleBasedBreakIterator.registerInstance((BreakIterator)this.srcWordIterator, this.srcLoc.toJavaLocale(), 1);
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
        this.trgWordIterator = (RuleBasedBreakIterator)BreakIterator.getWordInstance(ULocale.createCanonical(this.trgLoc.toString()));
        RuleBasedBreakIterator.registerInstance((BreakIterator)this.trgWordIterator, this.trgLoc.toJavaLocale(), 1);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.srcBatchWordCount = 0L;
        return super.handleStartBatch(event);
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.srcBatchItemWordCount = 0L;
        return super.handleStartBatchItem(event);
    }

    @Override
    protected Event handleEndBatchItem(Event event) {
        MetricsAnnotation sma;
        Ending res = event.getEnding();
        if (res == null) {
            res = new Ending("");
            event.setResource(res);
        }
        if ((sma = res.getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            res.setAnnotation(sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", this.srcBatchItemWordCount);
        this.srcBatchWordCount += this.srcBatchItemWordCount;
        return super.handleEndBatchItem(event);
    }

    @Override
    protected Event handleEndBatch(Event event) {
        MetricsAnnotation sma;
        Ending res = event.getEnding();
        if (res == null) {
            res = new Ending("");
            event.setResource(res);
        }
        if ((sma = res.getAnnotation(MetricsAnnotation.class)) == null) {
            sma = new MetricsAnnotation();
            res.setAnnotation(sma);
        }
        Metrics m = sma.getMetrics();
        m.setMetric("TotalWordCount", this.srcBatchWordCount);
        return super.handleEndBatch(event);
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu.isEmpty() || !tu.isTranslatable()) {
            return event;
        }
        if (!tu.getSource().isEmpty()) {
            long srcWordCount = this.countWords(tu.getSource().getUnSegmentedContentCopy().getText(), true);
            this.srcBatchItemWordCount += srcWordCount;
        }
        return event;
    }

    @Override
    public String getName() {
        return "Simple Word Count";
    }

    @Override
    public String getDescription() {
        return "Annotates each text units with a total word count (for both source and all targets) Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (ParametersSimpleWordCountStep)params;
    }

    private long countWords(String text, boolean source) {
        long totalWordCount = 0L;
        int current = 0;
        if (Util.isEmpty(text)) {
            return totalWordCount;
        }
        RuleBasedBreakIterator wordIterator = source ? this.srcWordIterator : this.trgWordIterator;
        wordIterator.setText(text);
        while (current != -1) {
            current = wordIterator.next();
            if (wordIterator.getRuleStatus() == 0) continue;
            ++totalWordCount;
        }
        return totalWordCount;
    }
}

