/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.tokenization.Tokenizer;
import net.sf.okapi.steps.tokenization.common.TokensAnnotation;
import net.sf.okapi.steps.tokenization.tokens.Tokens;
import net.sf.okapi.steps.wordcount.common.BaseCountStep;

public abstract class TokenCountStep
extends BaseCountStep {
    protected abstract String[] getTokenNames();

    @Override
    protected long count(TextContainer textContainer, LocaleId locale) {
        TokensAnnotation ta = textContainer.getAnnotation(TokensAnnotation.class);
        Tokens tokens = null;
        tokens = ta != null ? ta.getFilteredList(this.getTokenNames()) : Tokenizer.tokenize(textContainer, locale, this.getTokenNames());
        if (tokens == null) {
            return 0L;
        }
        return tokens.size();
    }

    @Override
    protected long count(Segment segment, LocaleId locale) {
        TokensAnnotation ta = segment.getAnnotation(TokensAnnotation.class);
        Tokens tokens = null;
        tokens = ta != null ? ta.getFilteredList(this.getTokenNames()) : Tokenizer.tokenize(segment.getContent(), locale, this.getTokenNames());
        if (tokens == null) {
            return 0L;
        }
        return tokens.size();
    }

    @Override
    protected long countInTextUnit(ITextUnit textUnit) {
        if (textUnit == null) {
            return 0L;
        }
        LocaleId srcLocale = this.getSourceLocale();
        TextContainer source = textUnit.getSource();
        long segCount = 0L;
        long segmentsCount = 0L;
        long textContainerCount = 0L;
        ISegments segs = source.getSegments();
        if (segs != null) {
            for (Segment seg : segs) {
                segCount = this.count(seg, srcLocale);
                segmentsCount += segCount;
                this.saveToMetrics(seg, segCount);
            }
        }
        textContainerCount = this.count(source, srcLocale);
        this.saveToMetrics(source, textContainerCount);
        if (textContainerCount > 0L) {
            return textContainerCount;
        }
        if (segmentsCount > 0L) {
            return segmentsCount;
        }
        return 0L;
    }
}

