/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.opc;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.steps.xliffkit.opc.OPCPackageUtil;
import net.sf.okapi.steps.xliffkit.reader.TextUnitMerger;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;

public class OPCPackageReader
extends AbstractFilter {
    private OPCPackage pack;
    private OkapiJsonSession session = new OkapiJsonSession();
    private Event event;
    private LinkedList<PackagePart> coreParts = new LinkedList();
    private PackagePart activePart;
    private PackagePart resourcesPart;
    private XLIFFFilter xliffReader;
    private TextUnitMerger merger;
    private LocaleId srcLoc;
    private String outputEncoding;
    private IFilterWriter filterWriter;
    private boolean generateTargets = false;
    private String outputPath;
    private boolean cacheEvents = false;
    private LinkedList<Event> events = new LinkedList();

    public OPCPackageReader(TextUnitMerger merger) {
        this.merger = merger;
    }

    @Override
    protected boolean isUtf8Bom() {
        return false;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return false;
    }

    private void writeEvent(Event event) {
        if (!this.generateTargets) {
            return;
        }
        if (this.filterWriter == null) {
            return;
        }
        if (this.events == null) {
            return;
        }
        if (this.cacheEvents) {
            this.events.add(event);
        } else {
            while (this.events.size() > 0) {
                this.filterWriter.handleEvent(this.events.poll());
            }
            this.filterWriter.handleEvent(event);
        }
    }

    @Override
    public void close() {
        this.clearParts();
        this.session.end();
        try {
            this.pack.close();
        }
        catch (IOException e) {
            throw new OkapiIOException("OPCPackageReader: cannot close package");
        }
    }

    private void clearParts() {
        this.coreParts.clear();
        this.activePart = null;
        this.resourcesPart = null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.event != null;
    }

    @Override
    public Event next() {
        Event prev = this.event;
        this.event = this.deserializeEvent();
        return prev;
    }

    private Event deserializeEvent() {
        Event event = null;
        if (this.activePart == null) {
            this.activePart = this.coreParts.poll();
            if (this.activePart == null) {
                return null;
            }
            this.resourcesPart = OPCPackageUtil.getResourcesPart(this.activePart);
            try {
                if (this.resourcesPart != null) {
                    this.session.start(this.resourcesPart.getInputStream());
                }
            }
            catch (IOException e) {
                throw new OkapiIOException("OPCPackageReader: cannot get resources from package", e);
            }
            if (this.xliffReader != null) {
                this.xliffReader.close();
                this.xliffReader = null;
            }
            this.xliffReader = new XLIFFFilter();
            try {
                this.xliffReader.open(new RawDocument(this.activePart.getInputStream(), "UTF-8", this.srcLoc, this.srcLoc));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("OPCPackageReader: cannot open input stream for %s", this.activePart.getPartName().getName()), e);
            }
        }
        if ((event = this.session.deserialize(Event.class)) == null) {
            this.session.end();
            this.activePart = null;
            return this.deserializeEvent();
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case START_SUBDOCUMENT: 
            case START_GROUP: 
            case END_SUBDOCUMENT: 
            case END_GROUP: 
            case DOCUMENT_PART: {
                this.writeEvent(event);
            }
        }
        return event;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, false);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.srcLoc = input.getSourceLocale();
            this.pack = OPCPackage.open(input.getStream());
        }
        catch (Exception e) {
            throw new OkapiIOException("OPCPackageReader: cannot open package", e);
        }
        this.clearParts();
        this.coreParts.addAll(OPCPackageUtil.getCoreParts(this.pack));
        this.event = this.deserializeEvent();
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private ITextUnit getNextXliffTu() {
        if (this.xliffReader == null) {
            throw new RuntimeException("OPCPackageReader: xliffReader is not initialized");
        }
        Event ev = null;
        while (this.xliffReader.hasNext()) {
            StartSubDocument startSubDoc;
            Property prop;
            ev = this.xliffReader.next();
            if (ev == null) {
                return null;
            }
            if (ev.getEventType() == EventType.START_SUBDOCUMENT && (prop = (startSubDoc = (StartSubDocument)ev.getResource()).getProperty("targetLanguage")) != null) {
                LocaleId trgLoc = LocaleId.fromString(prop.getValue());
                this.merger.setTrgLoc(trgLoc);
                this.filterWriter.setOptions(trgLoc, this.outputEncoding);
                this.cacheEvents = false;
            }
            if (ev.getEventType() != EventType.TEXT_UNIT) continue;
            return ev.getTextUnit();
        }
        return null;
    }

    private void processStartDocument(Event event) {
        StartDocument startDoc = (StartDocument)event.getResource();
        String srcName = startDoc.getName();
        String partName = this.activePart.getPartName().toString();
        String outFileName = this.outputPath + Util.getDirectoryName(partName) + "/" + Util.getFilename(srcName, true);
        this.filterWriter = startDoc.getFilterWriter();
        if (this.generateTargets) {
            File outputFile = new File(outFileName);
            Util.createDirectories(outputFile.getAbsolutePath());
            this.filterWriter.setOutput(outputFile.getAbsolutePath());
            this.cacheEvents = true;
            this.writeEvent(event);
        }
    }

    private void processEndDocument(Event event) {
        this.writeEvent(event);
        if (this.generateTargets) {
            this.filterWriter.close();
        }
    }

    private void processTextUnit(Event event) {
        if (this.merger == null) {
            return;
        }
        ITextUnit tu = event.getTextUnit();
        ITextUnit xtu = this.getNextXliffTu();
        if (xtu == null) {
            return;
        }
        this.merger.mergeTargets(tu, xtu);
        this.writeEvent(event);
    }

    public void setGeneratorOptions(String outputEncoding, String outputPath) {
        this.outputEncoding = outputEncoding;
        this.generateTargets = !Util.isEmpty(outputPath);
        this.outputPath = outputPath;
    }
}

