/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class DefaultFilenameFilter
implements FilenameFilter {
    private Pattern pattern;

    public DefaultFilenameFilter(String mask, boolean caseSensitive) {
        if (mask == null) {
            throw new NullPointerException("Mask of the filename cannot be null.");
        }
        mask = mask.replace('.', '\b');
        mask = mask.replace("*", ".*");
        mask = mask.replace('?', '.');
        mask = mask.replace("\b", "\\.");
        this.pattern = caseSensitive ? Pattern.compile(mask) : Pattern.compile(mask, 2);
    }

    public DefaultFilenameFilter(String extension) {
        this("*" + extension, false);
    }

    @Override
    public boolean accept(File directory, String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.pattern.matcher(fileName).matches();
    }
}

