/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.exceptions.OkapiUnexpectedResourceTypeException;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;

public class Event {
    public static final Event END_BATCH_EVENT = new Event(EventType.END_BATCH);
    public static final Event NOOP_EVENT = new Event(EventType.NO_OP);
    private EventType filterEventType;
    private IResource resource;

    public Event(EventType filterEventType) {
        this.filterEventType = filterEventType;
    }

    public Event(EventType filterEventType, IResource resource) {
        this.filterEventType = filterEventType;
        this.resource = resource;
    }

    public Event(EventType filterEventType, IResource resource, ISkeleton skeleton) {
        this.filterEventType = filterEventType;
        this.resource = resource;
        this.resource.setSkeleton(skeleton);
    }

    public EventType getEventType() {
        return this.filterEventType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public boolean isTextUnit() {
        return this.filterEventType == EventType.TEXT_UNIT;
    }

    public boolean isDocumentPart() {
        return this.filterEventType == EventType.DOCUMENT_PART;
    }

    public boolean isStartGroup() {
        return this.filterEventType == EventType.START_GROUP;
    }

    public boolean isEndGroup() {
        return this.filterEventType == EventType.END_GROUP;
    }

    public boolean isRawDocument() {
        return this.filterEventType == EventType.RAW_DOCUMENT;
    }

    public boolean isStartDocument() {
        return this.filterEventType == EventType.START_DOCUMENT;
    }

    public boolean isMultiEvent() {
        return this.filterEventType == EventType.MULTI_EVENT;
    }

    public ITextUnit getTextUnit() {
        if (this.isTextUnit()) {
            return (ITextUnit)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not a text unit.");
    }

    public DocumentPart getDocumentPart() {
        if (this.isDocumentPart()) {
            return (DocumentPart)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not a DocumentPart");
    }

    public StartGroup getStartGroup() {
        if (this.isStartGroup()) {
            return (StartGroup)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not a StartGroup");
    }

    public Ending getEndGroup() {
        if (this.isEndGroup()) {
            return (Ending)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not an Ending");
    }

    public Ending getEnding() {
        return (Ending)this.resource;
    }

    public RawDocument getRawDocument() {
        if (this.isRawDocument()) {
            return (RawDocument)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not a RawDocument");
    }

    public StartDocument getStartDocument() {
        if (this.isStartDocument()) {
            return (StartDocument)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not a StartDocument");
    }

    public MultiEvent getMultiEvent() {
        if (this.isMultiEvent()) {
            return (MultiEvent)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not a MultiEvent");
    }

    public boolean isPipelineParametersEvent() {
        return this.filterEventType == EventType.PIPELINE_PARAMETERS;
    }

    public PipelineParameters getPipelineParameters() {
        if (this.isPipelineParametersEvent()) {
            return (PipelineParameters)this.resource;
        }
        throw new OkapiUnexpectedResourceTypeException("Event resource is not a PipelineParameters");
    }

    public String toString() {
        return this.filterEventType.toString();
    }

    public boolean isNoop() {
        return this.filterEventType == EventType.NO_OP;
    }
}

