/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.LCIDUtil;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class LCIDUtilTest {
    @Test
    public void testLCID() {
        Assert.assertEquals((long)1049L, (long)LCIDUtil.getLCID("ru-ru"));
        Assert.assertEquals((long)1049L, (long)LCIDUtil.getLCID("ru-RU"));
        Assert.assertEquals((long)1049L, (long)LCIDUtil.getLCID("ru_RU"));
        Assert.assertEquals((long)1033L, (long)LCIDUtil.getLCID("en-us"));
        Assert.assertEquals((long)1100L, (long)LCIDUtil.getLCID("ml-IN"));
        Assert.assertEquals((Object)"ml-in", (Object)LCIDUtil.getTag(1100));
        Assert.assertEquals((long)7L, (long)LCIDUtil.getLCID("de"));
        Assert.assertEquals((long)9L, (long)LCIDUtil.getLCID("en"));
        Assert.assertEquals((long)10L, (long)LCIDUtil.getLCID("es"));
        Assert.assertEquals((long)12L, (long)LCIDUtil.getLCID("fr"));
        Assert.assertEquals((long)1096L, (long)LCIDUtil.getLCID(new LocaleId("or", "in")));
        Assert.assertEquals((Object)"or-in", (Object)LCIDUtil.getTag(new LocaleId("or", "in")));
    }

    @Test
    public void testLookups() {
        for (LCIDUtil.LCIDDescr descr : LCIDUtil.getTagLookup().values()) {
            int lcid = descr.lcid;
            String tag = descr.tag;
            if (LCIDUtil.getLcidLookup().containsKey(tag)) continue;
            Assert.fail((String)String.format("LcidLookup has no entry for 0x%04x (%s)", lcid, descr.tag));
        }
    }

    public void listLcidLookup() {
        for (String tag : LCIDUtil.getLcidLookup().keySet()) {
            LCIDUtil.LCIDDescr descr = LCIDUtil.getLcidLookup().get(tag);
            System.out.println(tag + ":   " + this.getDescrStr(descr));
        }
    }

    private String getDescrStr(LCIDUtil.LCIDDescr descr) {
        return String.format("Lang: %20s Reg: %20s lcid: 0x%04x tag: %s", descr.language, descr.region, descr.lcid, descr.tag);
    }
}

