/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.Locale;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class LocaleIdTest {
    @Test
    public void testIdentity() {
        LocaleId locId1 = LocaleId.ENGLISH;
        LocaleId locId2 = new LocaleId("en", true);
        Assert.assertEquals((long)0L, (long)locId1.compareTo(locId2));
        Assert.assertEquals((long)locId1.hashCode(), (long)locId2.hashCode());
    }

    @Test
    public void testConstructorFromIdentifier() {
        LocaleId locId = new LocaleId("en-CA", true);
        Assert.assertEquals((Object)"en", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"ca", (Object)locId.getRegion());
        locId = new LocaleId("EN_CA", true);
        Assert.assertEquals((Object)"en", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"ca", (Object)locId.getRegion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullIdentifier() {
        new LocaleId((String)null, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromEmptyIdentifier() {
        new LocaleId("", true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFrombadXIdentifier() {
        new LocaleId("z-test", true);
    }

    @Test
    public void testConstructorFromGoodXIdentifier() {
        new LocaleId("x-custom", true);
    }

    @Test
    public void testConstructorFromBadIdentifier() {
        LocaleId locId = new LocaleId("EN_CA", false);
        Assert.assertEquals((Object)"EN_CA", (Object)locId.getLanguage());
        Assert.assertNull(null, (Object)locId.getRegion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullLanguage() {
        new LocaleId((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromEmptyLanguage() {
        new LocaleId("");
    }

    @Test
    public void testConstructorFromLanguage() {
        LocaleId locId = new LocaleId("en");
        Assert.assertEquals((Object)"en", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        locId = new LocaleId("EN");
        Assert.assertEquals((Object)"en", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullLanguageAndRegion() {
        new LocaleId((String)null, "CA");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromEmptyLanguageAndRegion() {
        new LocaleId("", "CA");
    }

    @Test
    public void testConstructorFromLanguageAndRegion() {
        LocaleId locId = new LocaleId("de", "CH");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"ch", (Object)locId.getRegion());
        locId = new LocaleId("DE", null);
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        locId = new LocaleId("DE", "");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
    }

    @Test
    public void testConstructorFromLanguageRegionUserPart() {
        LocaleId locId = new LocaleId("de", "CH", "win");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"ch", (Object)locId.getRegion());
        Assert.assertEquals((Object)"win", (Object)locId.getUserPart());
        Assert.assertEquals((Object)"de-ch-x-win", (Object)locId.toString());
        locId = new LocaleId("de", "CH", "WIN");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"ch", (Object)locId.getRegion());
        Assert.assertEquals((Object)"win", (Object)locId.getUserPart());
        Assert.assertEquals((Object)"de-ch-x-win", (Object)locId.toString());
        locId = new LocaleId("DE", null, null);
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        Assert.assertNull((Object)locId.getUserPart());
        locId = new LocaleId("DE", null, "win");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        Assert.assertNull((Object)locId.getUserPart());
        locId = new LocaleId("DE", "", "");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        Assert.assertNull((Object)locId.getUserPart());
        locId = new LocaleId("DE", "", "win");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        Assert.assertNull((Object)locId.getUserPart());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFromNullJavaLocale() {
        new LocaleId((Locale)null);
    }

    @Test
    public void testConstructorFromJavaLocale() {
        LocaleId locId = new LocaleId(Locale.CANADA_FRENCH);
        Assert.assertEquals((Object)"fr", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"ca", (Object)locId.getRegion());
        locId = new LocaleId(Locale.SIMPLIFIED_CHINESE);
        Assert.assertEquals((Object)"zh", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"cn", (Object)locId.getRegion());
        locId = new LocaleId(Locale.CHINESE);
        Assert.assertEquals((Object)"zh", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        locId = new LocaleId(Locale.TRADITIONAL_CHINESE);
        Assert.assertEquals((Object)"zh", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"tw", (Object)locId.getRegion());
        locId = new LocaleId(new Locale("th", "TH", "TH"));
        Assert.assertEquals((Object)"th", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"th", (Object)locId.getRegion());
    }

    @Test
    public void testFromBCP() {
        LocaleId locId = LocaleId.fromBCP47("en-us");
        Assert.assertEquals((Object)"en", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"us", (Object)locId.getRegion());
        locId = LocaleId.fromBCP47("kok");
        Assert.assertEquals((Object)"kok", (Object)locId.getLanguage());
        locId = LocaleId.fromBCP47("ar-Latn-EG");
        Assert.assertEquals((Object)"ar", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"eg", (Object)locId.getRegion());
        locId = LocaleId.fromBCP47("az-latn");
        Assert.assertEquals((Object)"az", (Object)locId.getLanguage());
        Assert.assertNull((Object)locId.getRegion());
        locId = LocaleId.fromBCP47("zh-Hant-TW");
        Assert.assertEquals((Object)"zh", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"tw", (Object)locId.getRegion());
        locId = LocaleId.fromBCP47("zh-Latn-TW-pinyin");
        Assert.assertEquals((Object)"zh", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"tw", (Object)locId.getRegion());
        locId = LocaleId.fromBCP47("es-419");
        Assert.assertEquals((Object)"es", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"419", (Object)locId.getRegion());
        locId = LocaleId.fromBCP47("de-CH-1996");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"ch", (Object)locId.getRegion());
        locId = LocaleId.fromBCP47("ja-Latn-hepburn");
        Assert.assertEquals((Object)"ja", (Object)locId.getLanguage());
    }

    @Test
    public void testFromPOSIX() {
        LocaleId locId = LocaleId.fromPOSIXLocale("zu");
        Assert.assertEquals((Object)"zu", (Object)locId.getLanguage());
        locId = LocaleId.fromPOSIXLocale("kok");
        Assert.assertEquals((Object)"kok", (Object)locId.getLanguage());
        locId = LocaleId.fromPOSIXLocale("de_AT");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"at", (Object)locId.getRegion());
        Assert.assertEquals(null, (Object)locId.getUserPart());
        locId = LocaleId.fromPOSIXLocale("de_AT.UTF-8");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"at", (Object)locId.getRegion());
        Assert.assertEquals(null, (Object)locId.getUserPart());
        locId = LocaleId.fromPOSIXLocale("de_AT.UTF-8@ATS");
        Assert.assertEquals((Object)"de", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"at", (Object)locId.getRegion());
        Assert.assertEquals((Object)"ats", (Object)locId.getUserPart());
        locId = LocaleId.fromPOSIXLocale("sr@latin");
        Assert.assertEquals((Object)"sr", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"latin", (Object)locId.getUserPart());
    }

    @Test
    public void testToPOSIX() {
        LocaleId locId = LocaleId.fromPOSIXLocale("en_US.UTF-8");
        String res = locId.toPOSIXLocaleId();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"en_US", (Object)res);
        locId = LocaleId.fromPOSIXLocale("DE");
        res = locId.toPOSIXLocaleId();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"de", (Object)res);
    }

    @Test
    public void testToJavaLocale() {
        LocaleId locId = new LocaleId(Locale.CANADA_FRENCH);
        Locale loc = locId.toJavaLocale();
        Assert.assertNotNull((Object)loc);
        Assert.assertEquals((Object)Locale.CANADA_FRENCH.toString(), (Object)loc.toString());
        Locale jloc = new Locale("th", "TH", "TH");
        locId = new LocaleId(jloc);
        loc = locId.toJavaLocale();
        Assert.assertNotNull((Object)loc);
        Assert.assertEquals((Object)jloc.toString(), (Object)loc.toString());
        locId = new LocaleId(Locale.CHINESE);
        loc = locId.toJavaLocale();
        Assert.assertNotNull((Object)loc);
        Assert.assertEquals((Object)Locale.CHINESE.toString(), (Object)loc.toString());
    }

    @Test
    public void testEqualsWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("fi-se", false);
        Assert.assertFalse((boolean)locId1.equals(locId2));
        locId1 = new LocaleId("kok-abc", false);
        locId2 = new LocaleId("KOK_aBc", true);
        Assert.assertTrue((boolean)locId1.equals(locId2));
        locId1 = new LocaleId("br");
        locId2 = new LocaleId("br");
        Assert.assertTrue((boolean)locId1.equals(locId2));
    }

    @Test
    public void testEqualsWithString() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        Assert.assertFalse((boolean)locId1.equals("fi-se"));
        locId1 = new LocaleId("kok-abc", false);
        Assert.assertTrue((boolean)locId1.equals("KOK-aBc"));
        locId1 = new LocaleId("br");
        Assert.assertTrue((boolean)locId1.equals("BR"));
    }

    @Test
    public void testUsage() {
        Assert.assertEquals((Object)"Austria", (Object)new LocaleId("de-at", false).toJavaLocale().getDisplayCountry(Locale.ENGLISH));
        Assert.assertEquals((Object)"French", (Object)new LocaleId("fr-ca", false).toJavaLocale().getDisplayLanguage(Locale.ENGLISH));
    }

    @Test
    public void testSameLanguageWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("fi-se", false);
        Assert.assertTrue((boolean)locId1.sameLanguageAs(locId2));
        locId1 = new LocaleId("kok", false);
        locId2 = new LocaleId("KOK_id", true);
        Assert.assertTrue((boolean)locId1.sameLanguageAs(locId2));
        locId1 = new LocaleId("br");
        locId2 = new LocaleId("br");
        Assert.assertTrue((boolean)locId1.sameLanguageAs(locId2));
    }

    @Test
    public void testSameLanguageWithString() {
        LocaleId locId = new LocaleId("fi-fi", false);
        Assert.assertTrue((boolean)locId.sameLanguageAs("fi-se"));
        locId = new LocaleId("kok", false);
        Assert.assertTrue((boolean)locId.sameLanguageAs("KoK_id"));
        locId = new LocaleId("br");
        Assert.assertTrue((boolean)locId.sameLanguageAs("br"));
    }

    @Test
    public void testDifferentLanguages() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("sv-fi", true);
        Assert.assertFalse((boolean)locId1.sameLanguageAs(locId2));
        locId1 = new LocaleId("nn", false);
        Assert.assertFalse((boolean)locId1.sameLanguageAs("no"));
    }

    @Test
    public void testSameRegionWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("sv-fi", false);
        Assert.assertTrue((boolean)locId1.sameRegionAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", true);
        Assert.assertTrue((boolean)locId1.sameRegionAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", false);
        Assert.assertFalse((boolean)locId1.sameRegionAs(locId2));
    }

    @Test
    public void testSameRegionWithString() {
        LocaleId locId = new LocaleId("fi-fi", false);
        Assert.assertTrue((boolean)locId.sameRegionAs("sv-fi"));
        locId = new LocaleId("fi-fi", false);
        Assert.assertTrue((boolean)locId.sameRegionAs("sv_FI"));
        locId = new LocaleId("sv_FI", false);
        Assert.assertFalse((boolean)locId.sameRegionAs("fi-fi"));
    }

    @Test
    public void testDifferentRegions() {
        LocaleId locId1 = new LocaleId("sv-se", false);
        LocaleId locId2 = new LocaleId("sv-fi", true);
        Assert.assertFalse((boolean)locId1.sameRegionAs(locId2));
    }

    @Test
    public void testSameUserPartWithLocaleId() {
        LocaleId locId1 = new LocaleId("fi-fi", false);
        LocaleId locId2 = new LocaleId("sv-fi", false);
        Assert.assertTrue((boolean)locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", true);
        Assert.assertTrue((boolean)locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("fi-fi", false);
        locId2 = new LocaleId("sv_FI", false);
        Assert.assertTrue((boolean)locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("es-us-x-win", false);
        locId2 = LocaleId.fromPOSIXLocale("en_us@win");
        Assert.assertTrue((boolean)locId1.sameUserPartAs(locId2));
        locId1 = LocaleId.fromPOSIXLocale("es_us@mac");
        locId2 = LocaleId.fromPOSIXLocale("en_us@win");
        Assert.assertFalse((boolean)locId1.sameUserPartAs(locId2));
    }

    @Test
    public void testSameUserPartWithString() {
        LocaleId locId = new LocaleId("fi-fi", false);
        Assert.assertTrue((boolean)locId.sameUserPartAs("sv-fi"));
        locId = new LocaleId("fi-fi", false);
        Assert.assertTrue((boolean)locId.sameUserPartAs("sv_FI"));
        locId = new LocaleId("sv_FI", false);
        Assert.assertTrue((boolean)locId.sameUserPartAs("fi-fi"));
        locId = new LocaleId("es-us-x-win", false);
        Assert.assertTrue((boolean)locId.sameUserPartAs("en-x-win"));
        locId = LocaleId.fromPOSIXLocale("es_us@mac");
        Assert.assertFalse((boolean)locId.sameUserPartAs("es_us-x-win"));
    }

    @Test
    public void testDifferentUserParts() {
        LocaleId locId1 = new LocaleId("sv-se", false);
        LocaleId locId2 = new LocaleId("sv-fi", true);
        Assert.assertTrue((boolean)locId1.sameUserPartAs(locId2));
        locId1 = new LocaleId("es-us-x-win", false);
        locId2 = new LocaleId("es-us-x-mac", false);
        Assert.assertFalse((boolean)locId1.sameUserPartAs(locId2));
    }

    @Test
    public void testSplitLanguageCode() {
        String in = "en";
        String[] res = LocaleId.splitLanguageCode(in);
        Assert.assertEquals((Object)res[0], (Object)"en");
        Assert.assertEquals((Object)res[1], (Object)"");
    }

    @Test
    public void testSplitLanguageCode_4Letters() {
        String in = "en-BZ";
        String[] res = LocaleId.splitLanguageCode(in);
        Assert.assertEquals((Object)res[0], (Object)"en");
        Assert.assertEquals((Object)res[1], (Object)"BZ");
    }

    @Test
    public void testSplitLanguageCode_Underline() {
        String in = "en_BZ";
        String[] res = LocaleId.splitLanguageCode(in);
        Assert.assertEquals((Object)res[0], (Object)"en");
        Assert.assertEquals((Object)res[1], (Object)"BZ");
    }

    @Test
    public void testRegionAndUserPart() {
        LocaleId locId = new LocaleId("ja-jp-x-calja", true);
        Assert.assertEquals((Object)"ja", (Object)locId.getLanguage());
        Assert.assertEquals((Object)"jp", (Object)locId.getRegion());
        Assert.assertEquals((Object)"calja", (Object)locId.getUserPart());
        locId = new LocaleId("ar-Latn-EG", true);
        Assert.assertEquals((Object)"eg", (Object)locId.getRegion());
        Assert.assertEquals(null, (Object)locId.getUserPart());
        locId = new LocaleId("zh-Hant-TW", true);
        Assert.assertEquals((Object)"tw", (Object)locId.getRegion());
        Assert.assertEquals(null, (Object)locId.getUserPart());
        locId = new LocaleId("zh-Latn-TW-pinyin", true);
        Assert.assertEquals((Object)"tw", (Object)locId.getRegion());
        Assert.assertEquals(null, (Object)locId.getUserPart());
        locId = new LocaleId("de-CH-1996", true);
        Assert.assertEquals((Object)"ch", (Object)locId.getRegion());
        Assert.assertEquals(null, (Object)locId.getUserPart());
        locId = new LocaleId("ja-Latn-hepburn", true);
        Assert.assertEquals(null, (Object)locId.getRegion());
        Assert.assertEquals(null, (Object)locId.getUserPart());
    }

    @Test
    public void testIsBidirectional() {
        Assert.assertTrue((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("ar")));
        Assert.assertTrue((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("he")));
        Assert.assertTrue((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("ar-SA")));
        Assert.assertTrue((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("ur-pk")));
        Assert.assertTrue((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("syc")));
        Assert.assertTrue((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("dv")));
        Assert.assertTrue((boolean)LocaleId.isBidirectional(LocaleId.fromPOSIXLocale("ar_EG")));
        Assert.assertFalse((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("en-ar")));
        Assert.assertFalse((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("arn")));
        Assert.assertFalse((boolean)LocaleId.isBidirectional(LocaleId.fromBCP47("tr")));
    }

    @Test
    public void testVariablesWithString() {
        String srcLoc = new LocaleId("de", "CH").toString();
        String trgLoc = new LocaleId("en", "IE").toString();
        Assert.assertEquals((Object)"", (Object)LocaleId.replaceVariables("", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de-ch,en-ie", (Object)LocaleId.replaceVariables("${srcLang},${trgLang}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"DE-CH,EN-IE", (Object)LocaleId.replaceVariables("${srcLangU},${trgLangU}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de-ch,en-ie", (Object)LocaleId.replaceVariables("${srcLangL},${trgLangL}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de_CH,en_IE", (Object)LocaleId.replaceVariables("${srcLoc},${trgLoc}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de,en", (Object)LocaleId.replaceVariables("${srcLocLang},${trgLocLang}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"CH,IE", (Object)LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"CH,", (Object)LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, null));
        Assert.assertEquals((Object)",en-ie", (Object)LocaleId.replaceVariables("${srcLang},${trgLang}", null, trgLoc));
    }

    @Test
    public void testVariablesWithLocaleId() {
        LocaleId srcLoc = new LocaleId("de", "CH");
        LocaleId trgLoc = new LocaleId("en", "IE");
        Assert.assertEquals((Object)"", (Object)LocaleId.replaceVariables("", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de-ch,en-ie", (Object)LocaleId.replaceVariables("${srcLang},${trgLang}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"DE-CH,EN-IE", (Object)LocaleId.replaceVariables("${srcLangU},${trgLangU}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de-ch,en-ie", (Object)LocaleId.replaceVariables("${srcLangL},${trgLangL}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de_CH,en_IE", (Object)LocaleId.replaceVariables("${srcLoc},${trgLoc}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"de,en", (Object)LocaleId.replaceVariables("${srcLocLang},${trgLocLang}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"CH,IE", (Object)LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, trgLoc));
        Assert.assertEquals((Object)"CH,", (Object)LocaleId.replaceVariables("${srcLocReg},${trgLocReg}", srcLoc, null));
        Assert.assertEquals((Object)",en-ie", (Object)LocaleId.replaceVariables("${srcLang},${trgLang}", null, trgLoc));
    }
}

