/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.List;
import java.util.regex.Pattern;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.RegexUtil;
import org.junit.Assert;
import org.junit.Test;

public class RegexUtilTest {
    @Test
    public void testReplaceAll() {
        Assert.assertEquals((Object)"e{1@^}ddddd{2@^5}+", (Object)RegexUtil.replaceAll("e{1,}ddddd{2,5}+", "\\{.*?(,).*?\\}", 1, "@^"));
        Assert.assertEquals((Object)"\"@eins\"\"", (Object)RegexUtil.replaceAll("\"\"\"eins\"\"", "((\\\"\\\")+)[^\\\"]|[^\\\"]((\\\"\\\")+)", 1, "@"));
        Assert.assertEquals((Object)"\"\"\"eins@", (Object)RegexUtil.replaceAll("\"\"\"eins\"\"", "((\\\"\\\")+)[^\\\"]|[^\\\"]((\\\"\\\")+)", 3, "@"));
    }

    @Test
    public void testCountMatches() {
        Assert.assertEquals((long)3L, (long)RegexUtil.countMatches("1 text 2 text 1 text 1 text 2", "1"));
        Assert.assertEquals((long)2L, (long)RegexUtil.countMatches("1 text 2 text 1 text 1 text 2", "2"));
    }

    @Test
    public void testCountQualifiers() {
        Assert.assertEquals((long)3L, (long)RegexUtil.countLeadingQualifiers("\"text, \"text\", text,\"text\"\"\"", "\""));
        Assert.assertEquals((long)4L, (long)RegexUtil.countTrailingQualifiers("\"text, \"text\", text,\"text\"\"\"", "\""));
        Assert.assertEquals((long)3L, (long)RegexUtil.countLeadingQualifiers("\"\u0432\u0430\u0432\u044b, \"\u044b\u0432\u044b\u0432\u0430\u044b\u0432\u0432\u0430\", \u044b\u0432\u0430\u0430\u0430,\"\u044b\u0444\u044b\u0432\u044b\"\"\"", "\""));
        Assert.assertEquals((long)4L, (long)RegexUtil.countTrailingQualifiers("\"\u0432\u0430\u0432\u044b, \"\u044b\u0432\u044b\u0432\u0430\u044b\u0432\u0432\u0430\", \u044b\u0432\u0430\u0430\u0430,\"\u044b\u0444\u044b\u0432\u044b\"\"\"", "\""));
    }

    @Test
    public void testGetQuotedAreas() {
        String st = "((abc)d(e\\(((f)ghi)\\Qj\\)k\\Elm)nop\\Qqrs\\E";
        List<Range> quotedAreas = RegexUtil.getQuotedAreas(st);
        Assert.assertEquals((long)2L, (long)quotedAreas.size());
        Assert.assertEquals((long)21L, (long)quotedAreas.get((int)0).start);
        Assert.assertEquals((long)24L, (long)quotedAreas.get((int)0).end);
        Assert.assertEquals((long)35L, (long)quotedAreas.get((int)1).start);
        Assert.assertEquals((long)37L, (long)quotedAreas.get((int)1).end);
    }

    @Test
    public void testGetGroupAtPos() {
        String st = "((abc)d(e\\(((f)ghi)\\Qj\\)k\\Elm)nop)qr";
        Assert.assertEquals((long)0L, (long)RegexUtil.getGroupAtPos(st, 0));
        Assert.assertEquals((long)1L, (long)RegexUtil.getGroupAtPos(st, 1));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 2));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 3));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 4));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 5));
        Assert.assertEquals((long)1L, (long)RegexUtil.getGroupAtPos(st, 6));
        Assert.assertEquals((long)1L, (long)RegexUtil.getGroupAtPos(st, 7));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 8));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 9));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 10));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 11));
        Assert.assertEquals((long)4L, (long)RegexUtil.getGroupAtPos(st, 12));
        Assert.assertEquals((long)5L, (long)RegexUtil.getGroupAtPos(st, 13));
        Assert.assertEquals((long)5L, (long)RegexUtil.getGroupAtPos(st, 14));
        Assert.assertEquals((long)4L, (long)RegexUtil.getGroupAtPos(st, 15));
        Assert.assertEquals((long)4L, (long)RegexUtil.getGroupAtPos(st, 16));
        Assert.assertEquals((long)4L, (long)RegexUtil.getGroupAtPos(st, 17));
        Assert.assertEquals((long)4L, (long)RegexUtil.getGroupAtPos(st, 18));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 19));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 21));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 22));
        Assert.assertEquals((long)3L, (long)RegexUtil.getGroupAtPos(st, 23));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 24));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 25));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 26));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 27));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 28));
        Assert.assertEquals((long)2L, (long)RegexUtil.getGroupAtPos(st, 29));
        Assert.assertEquals((long)1L, (long)RegexUtil.getGroupAtPos(st, 30));
        Assert.assertEquals((long)1L, (long)RegexUtil.getGroupAtPos(st, 31));
        Assert.assertEquals((long)1L, (long)RegexUtil.getGroupAtPos(st, 32));
        Assert.assertEquals((long)1L, (long)RegexUtil.getGroupAtPos(st, 33));
        Assert.assertEquals((long)0L, (long)RegexUtil.getGroupAtPos(st, 34));
        Assert.assertEquals((long)0L, (long)RegexUtil.getGroupAtPos(st, 35));
    }

    @Test
    public void testUpdateGroupReferences() {
        String st1 = "abcdefghijk abcdefghijkghab";
        String regex1 = "((ab)cdef(gh)ijk) \\1\\3\\2";
        String st2 = "ablmncdefghijk ablmncdefghijkghlmn";
        String regex2 = "((ab)(lmn)cdef(gh)ijk) \\1\\3\\2";
        String regex3 = "((ab)(lmn)cdef(gh)ijk) \\1\\4\\3";
        Assert.assertTrue((boolean)Pattern.compile(regex1).matcher(st1).matches());
        Assert.assertFalse((boolean)Pattern.compile(regex2).matcher(st2).matches());
        Assert.assertTrue((boolean)Pattern.compile(regex3).matcher(st2).matches());
        Assert.assertEquals((Object)regex3, (Object)RegexUtil.updateGroupReferences(regex2, 3));
        Assert.assertTrue((boolean)Pattern.compile(RegexUtil.updateGroupReferences(regex2, 3)).matcher(st2).matches());
    }
}

