/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.IEncoder;

public class PHPContentEncoder
implements IEncoder {
    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
    }

    @Override
    public String encode(String text, int context) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch > '\u007f') {
                if (Character.isHighSurrogate(ch)) {
                    int cp = text.codePointAt(i++);
                    String tmp = new String(Character.toChars(cp));
                    escaped.append(tmp);
                    continue;
                }
                escaped.append(String.valueOf(ch));
                continue;
            }
            switch (ch) {
                default: 
            }
            escaped.append(ch);
        }
        return escaped.toString();
    }

    @Override
    public String encode(char value, int context) {
        if (value > '\u007f') {
            return String.valueOf(value);
        }
        switch (value) {
            default: 
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, int context) {
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                String tmp = new String(Character.toChars(value));
                return tmp;
            }
            return String.valueOf((char)value);
        }
        switch ((char)value) {
            default: 
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return "\n";
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return null;
    }
}

