/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.InvalidPositionException;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class GenericContent {
    private final Pattern patternOpening = Pattern.compile("\\<(\\d+?)\\>");
    private final Pattern patternClosing = Pattern.compile("\\</(\\d+?)\\>");
    private final Pattern patternIsolated = Pattern.compile("\\<(\\d+?)/\\>");
    private final Pattern patternIsolatedB = Pattern.compile("\\<b(\\d+?)/\\>");
    private final Pattern patternIsolatedE = Pattern.compile("\\<e(\\d+?)/\\>");
    private final Pattern patternLCOpening = Pattern.compile("\\<g(\\d+?)\\>");
    private final Pattern patternLCClosing = Pattern.compile("\\</g(\\d+?)\\>");
    private final Pattern patternLCIsolated = Pattern.compile("\\<x(\\d+?)/\\>");
    private final Pattern patternLCIsolatedB = Pattern.compile("\\<b(\\d+?)/\\>");
    private final Pattern patternLCIsolatedE = Pattern.compile("\\<e(\\d+?)/\\>");
    private String codedText;
    private List<Code> codes;

    public GenericContent() {
        this.codedText = "";
    }

    public GenericContent(TextFragment content) {
        this.setContent(content);
    }

    public GenericContent setContent(TextFragment content) {
        this.codedText = content.getCodedText();
        this.codes = content.getCodes();
        return this;
    }

    public String printSegmentedContent(TextContainer container, boolean showSegments) {
        return this.printSegmentedContent(container, showSegments, false);
    }

    public String printSegmentedContent(TextContainer container, boolean showSegments, boolean normalText) {
        StringBuilder tmp = new StringBuilder();
        for (TextPart part : container) {
            if (part instanceof Segment) {
                if (showSegments) {
                    tmp.append("[");
                }
                tmp.append(this.setContent(part.text).toString(normalText));
                if (!showSegments) continue;
                tmp.append("]");
                continue;
            }
            tmp.append(this.setContent(part.text).toString(normalText));
        }
        return tmp.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean normalText) {
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < this.codedText.length(); ++i) {
            switch (this.codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    if (normalText) {
                        tmp.append(this.codes.get(index).toString());
                        continue block5;
                    }
                    tmp.append(String.format("<%d>", this.codes.get(index).getId()));
                    continue block5;
                }
                case 57602: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    if (normalText) {
                        tmp.append(this.codes.get(index).toString());
                        continue block5;
                    }
                    tmp.append(String.format("</%d>", this.codes.get(index).getId()));
                    continue block5;
                }
                case 57603: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    if (normalText) {
                        tmp.append(this.codes.get(index).toString());
                        continue block5;
                    }
                    if (this.codes.get(index).getTagType() == TextFragment.TagType.OPENING) {
                        tmp.append(String.format("<b%d/>", this.codes.get(index).getId()));
                        continue block5;
                    }
                    if (this.codes.get(index).getTagType() == TextFragment.TagType.CLOSING) {
                        tmp.append(String.format("<e%d/>", this.codes.get(index).getId()));
                        continue block5;
                    }
                    tmp.append(String.format("<%d/>", this.codes.get(index).getId()));
                    continue block5;
                }
                default: {
                    tmp.append(this.codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public Range getCodedTextPosition(Range position) {
        Range result = new Range(0, 0);
        int genericPos = 0;
        int codedPos = 0;
        for (int i = 0; i < this.codedText.length(); ++i) {
            switch (this.codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    genericPos += String.format("<%d>", this.codes.get(index).getId()).length();
                    codedPos += 2;
                    break;
                }
                case 57602: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    genericPos += String.format("</%d>", this.codes.get(index).getId()).length();
                    codedPos += 2;
                    break;
                }
                case 57603: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    genericPos = this.codes.get(index).getTagType() == TextFragment.TagType.OPENING ? (genericPos += String.format("<b%d/>", this.codes.get(index).getId()).length()) : (this.codes.get(index).getTagType() == TextFragment.TagType.CLOSING ? (genericPos += String.format("<e%d/>", this.codes.get(index).getId()).length()) : (genericPos += String.format("<%d/>", this.codes.get(index).getId()).length()));
                    codedPos += 2;
                    break;
                }
                default: {
                    ++genericPos;
                    ++codedPos;
                }
            }
            if (genericPos == position.start) {
                result.start = codedPos;
                if (position.start == position.end) {
                    result.end = result.start;
                    return result;
                }
            }
            if (genericPos != position.end) continue;
            result.end = codedPos;
            return result;
        }
        throw new InvalidPositionException(String.format("Position %d or %d is invalid.", position.start, position.end));
    }

    public void updateFragment(String genericText, TextFragment fragment, boolean allowCodeDeletion) {
        int index;
        int n;
        if (genericText == null) {
            throw new NullPointerException("Parameter genericText is null");
        }
        if (!fragment.hasCode() && genericText.indexOf(60) == -1) {
            fragment.setCodedText(genericText);
            return;
        }
        StringBuilder tmp = new StringBuilder(genericText);
        int start = 0;
        int diff = 0;
        Matcher m = this.patternOpening.matcher(genericText);
        while (m.find(start)) {
            n = m.start();
            index = fragment.getIndex(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternClosing.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = fragment.getIndexForClosing(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            fragment.getCode(index).setId(-1);
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternIsolated.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = fragment.getIndex(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternIsolatedB.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = fragment.getIndex(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternIsolatedE.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            index = fragment.getIndexForClosing(Integer.valueOf(m.group(1)));
            if (index == -1) {
                throw new InvalidContentException(String.format("Invalid code: '%s'", m.group()));
            }
            fragment.getCode(index).setId(-1);
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(index))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        fragment.setCodedText(tmp.toString(), allowCodeDeletion);
    }

    public TextFragment fromLetterCodedToFragment(String text, TextFragment fragment, boolean reuseCodes) {
        int index;
        Code code;
        int n;
        if (text.indexOf(60) == -1) {
            if (fragment != null) {
                fragment.setCodedText(text, true);
                return fragment;
            }
            return new TextFragment(text);
        }
        if (fragment == null) {
            reuseCodes = false;
        }
        ArrayList<Code> codes = new ArrayList<Code>();
        StringBuilder tmp = new StringBuilder(text);
        int start = 0;
        int diff = 0;
        Matcher m = this.patternLCOpening.matcher(text);
        while (m.find(start)) {
            n = m.start();
            code = null;
            if (reuseCodes && (index = fragment.getIndex(Integer.valueOf(m.group(1)))) > -1) {
                code = fragment.getCode(index).clone();
            }
            if (code == null) {
                code = new Code(TextFragment.TagType.OPENING, "Xpt", tmp.substring(n + diff, n + diff + m.group().length()));
                code.setId(Integer.valueOf(m.group(1)));
            }
            codes.add(code);
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar(codes.size() - 1))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternLCClosing.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            code = null;
            if (reuseCodes && (index = fragment.getIndexForClosing(Integer.valueOf(m.group(1)))) > -1) {
                code = fragment.getCode(index).clone();
            }
            if (code == null) {
                code = new Code(TextFragment.TagType.CLOSING, "Xpt", tmp.substring(n + diff, n + diff + m.group().length()));
                code.setId(Integer.valueOf(m.group(1)));
            }
            codes.add(code);
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar(codes.size() - 1))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternLCIsolated.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            code = null;
            if (reuseCodes && (index = fragment.getIndex(Integer.valueOf(m.group(1)))) > -1) {
                code = fragment.getCode(index).clone();
            }
            if (code == null) {
                code = new Code(TextFragment.TagType.PLACEHOLDER, "Xph", tmp.substring(n + diff, n + diff + m.group().length()));
                code.setId(Integer.valueOf(m.group(1)));
            }
            codes.add(code);
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(codes.size() - 1))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternLCIsolatedB.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            code = null;
            if (reuseCodes && (index = fragment.getIndex(Integer.valueOf(m.group(1)))) > -1) {
                code = fragment.getCode(index).clone();
            }
            if (code == null) {
                code = new Code(TextFragment.TagType.OPENING, "Xpt", tmp.substring(n + diff, n + diff + m.group().length()));
                code.setId(Integer.valueOf(m.group(1)));
            }
            codes.add(code);
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(codes.size() - 1))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        diff = 0;
        start = 0;
        m = this.patternLCIsolatedE.matcher(tmp.toString());
        while (m.find(start)) {
            n = m.start();
            code = null;
            if (reuseCodes && (index = fragment.getIndexForClosing(Integer.valueOf(m.group(1)))) > -1) {
                code = fragment.getCode(index).clone();
            }
            if (code == null) {
                code = new Code(TextFragment.TagType.CLOSING, "Xpt", tmp.substring(n + diff, n + diff + m.group().length()));
                code.setId(Integer.valueOf(m.group(1)));
            }
            codes.add(code);
            tmp.replace(n + diff, n + diff + m.group().length(), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar(codes.size() - 1))));
            diff += 2 - m.group().length();
            start = n + m.group().length();
        }
        if (fragment != null) {
            fragment.setCodedText(tmp.toString(), codes, true);
            return fragment;
        }
        return new TextFragment(tmp.toString(), codes);
    }

    public String fromFragmentToLetterCoded(TextFragment fragment) {
        String codedText = fragment.getCodedText();
        List<Code> codes = fragment.getCodes();
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < codedText.length(); ++i) {
            switch (codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(codedText.charAt(++i));
                    tmp.append(String.format("<g%d>", codes.get(index).getId()));
                    continue block5;
                }
                case 57602: {
                    int index = TextFragment.toIndex(codedText.charAt(++i));
                    tmp.append(String.format("</g%d>", codes.get(index).getId()));
                    continue block5;
                }
                case 57603: {
                    int index = TextFragment.toIndex(codedText.charAt(++i));
                    if (codes.get(index).getTagType() == TextFragment.TagType.OPENING) {
                        tmp.append(String.format("<b%d/>", codes.get(index).getId()));
                        continue block5;
                    }
                    if (codes.get(index).getTagType() == TextFragment.TagType.CLOSING) {
                        tmp.append(String.format("<e%d/>", codes.get(index).getId()));
                        continue block5;
                    }
                    tmp.append(String.format("<x%d/>", codes.get(index).getId()));
                    continue block5;
                }
                default: {
                    tmp.append(codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }
}

