/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.threaded;

import java.util.concurrent.BlockingQueue;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.threaded.BaseThreadedPipelineStepAdaptor;
import net.sf.okapi.common.pipeline.threaded.IConsumer;
import net.sf.okapi.common.pipeline.threaded.RuntimeInterruptedException;

class ConsumerPipelineStepAdaptor
extends BaseThreadedPipelineStepAdaptor
implements IConsumer {
    private BlockingQueue<Event> consumerQueue;

    public ConsumerPipelineStepAdaptor(IPipelineStep step) {
        super(step);
    }

    @Override
    public void setConsumerQueue(BlockingQueue<Event> consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    protected Event takeFromQueue() {
        Event event;
        if (this.consumerQueue == null) {
            throw new RuntimeException("consumer queue is null");
        }
        try {
            event = this.consumerQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        return event;
    }

    @Override
    protected void processBlockingQueue() {
        Event e = this.takeFromQueue();
        this.getStep().handleEvent(e);
    }

    @Override
    protected void clearBlockingQueues() {
        this.consumerQueue.clear();
    }
}

