/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.threaded;

import java.util.concurrent.BlockingQueue;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.threaded.BaseThreadedPipelineStepAdaptor;
import net.sf.okapi.common.pipeline.threaded.IFirstStep;
import net.sf.okapi.common.pipeline.threaded.IProducer;
import net.sf.okapi.common.pipeline.threaded.RuntimeInterruptedException;

class ProducerPipelineStepAdaptor
extends BaseThreadedPipelineStepAdaptor
implements IProducer,
IFirstStep {
    private BlockingQueue<Event> producerQueue;
    private BlockingQueue<Event> inputQueue;

    public ProducerPipelineStepAdaptor(IPipelineStep step) {
        super(step);
    }

    @Override
    public void setProducerQueue(BlockingQueue<Event> producerQueue) {
        this.producerQueue = producerQueue;
    }

    @Override
    public void setInputQueue(BlockingQueue<Event> inputQueue) {
        this.inputQueue = inputQueue;
    }

    protected void addToQueue(Event event) {
        if (this.producerQueue == null) {
            throw new RuntimeException("producer queue is null");
        }
        try {
            this.producerQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
    }

    protected Event takeFromQueue() {
        Event event;
        if (this.inputQueue == null) {
            throw new RuntimeException("input queue is null");
        }
        try {
            event = this.inputQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        return event;
    }

    @Override
    protected void processBlockingQueue() {
        Event e = this.takeFromQueue();
        e = this.getStep().handleEvent(e);
        this.addToQueue(e);
    }

    @Override
    protected void clearBlockingQueues() {
        this.producerQueue.clear();
    }
}

