/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.query;

import java.security.InvalidParameterException;
import java.util.Date;
import net.sf.okapi.common.HashCodeUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.TextFragment;

public class QueryResult
implements Comparable<QueryResult> {
    public static int QUALITY_UNDEFINED = Integer.MIN_VALUE;
    public static int COMBINEDSCORE_UNDEFINED = Integer.MIN_VALUE;
    public int weight;
    private int fuzzyScore;
    public MatchType matchType = MatchType.UKNOWN;
    public TextFragment source;
    public TextFragment target;
    public Date creationDate = new Date(0L);
    public String entryId = null;
    public int connectorId;
    public String origin;
    private int quality = QUALITY_UNDEFINED;
    private int combinedScore = COMBINEDSCORE_UNDEFINED;

    public AltTranslation toAltTranslation(TextFragment originalSource, LocaleId sourceLocId, LocaleId targetLocId) {
        return new AltTranslation(sourceLocId, targetLocId, originalSource, this.source, this.target, this.matchType, this.getCombinedScore(), this.origin, this.getFuzzyScore(), this.getQuality());
    }

    public boolean fromMT() {
        return this.matchType == MatchType.MT;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        if (quality < 0 && quality != QUALITY_UNDEFINED || quality > 100) {
            throw new InvalidParameterException("Invalid quality value.");
        }
        this.quality = quality;
    }

    public int getCombinedScore() {
        if (this.combinedScore == COMBINEDSCORE_UNDEFINED) {
            return this.fuzzyScore;
        }
        return this.combinedScore;
    }

    public void setCombinedScore(int combinedScore) {
        if (combinedScore < 0 && combinedScore != COMBINEDSCORE_UNDEFINED || combinedScore > 100) {
            throw new InvalidParameterException("Invalid combined score value.");
        }
        this.combinedScore = combinedScore;
    }

    public int getFuzzyScore() {
        return this.fuzzyScore;
    }

    public void setFuzzyScore(int fuzzyScore) {
        if (fuzzyScore < 0) {
            throw new InvalidParameterException("Invalid score value.");
        }
        this.fuzzyScore = fuzzyScore;
    }

    @Override
    public int compareTo(QueryResult other) {
        boolean EQUAL = false;
        if (this == other) {
            return 0;
        }
        String thisSource = this.source.toText();
        String otherSource = other.source.toText();
        int comparison = Float.compare(this.weight, other.weight);
        if (comparison != 0) {
            return comparison;
        }
        if (!(this.isTrueFuzzy(this.matchType) && this.isTrueFuzzy(other.matchType) || (comparison = this.matchType.compareTo(other.matchType)) == 0)) {
            return comparison;
        }
        comparison = Float.compare(this.getCombinedScore(), other.getCombinedScore());
        if (comparison != 0) {
            return comparison * -1;
        }
        comparison = thisSource.compareTo(otherSource);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.creationDate.compareTo(other.creationDate);
        if (comparison != 0) {
            return comparison * -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueryResult)) {
            return false;
        }
        QueryResult otherHit = (QueryResult)other;
        return this.weight == otherHit.weight && this.matchType == otherHit.matchType && this.source.toText().equals(otherHit.source.toText()) && this.target.toText().equals(otherHit.target.toText());
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.weight);
        result = HashCodeUtil.hash(result, (Object)this.matchType);
        result = HashCodeUtil.hash(result, this.source.toText());
        result = HashCodeUtil.hash(result, this.target.toText());
        return result;
    }

    private boolean isTrueFuzzy(MatchType type) {
        return type == MatchType.FUZZY_PREVIOUS_VERSION || type == MatchType.FUZZY_UNIQUE_ID || type == MatchType.FUZZY;
    }
}

