/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.tmx.Parameters;
import net.sf.okapi.filters.tmx.TmxTu;
import net.sf.okapi.filters.tmx.TmxTuv;

@UsingParameters(value=Parameters.class)
public class TmxFilter
implements IFilter {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean hasNext;
    private XMLStreamReader reader;
    private String docName;
    private int tuId;
    private IdGenerator otherId;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private LinkedList<Event> queue;
    private boolean canceled;
    private GenericSkeleton skel;
    private String encoding;
    private Parameters params;
    private Stack<Boolean> preserveSpaces;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private boolean skipUtWarning;
    private TuvXmlLang tuvTrgType = TuvXmlLang.UNDEFINED;
    private HashMap<String, String> rulesMap = new HashMap();
    private Stack<String> elemStack = new Stack();
    private EncoderManager encoderManager;
    private boolean skipInvalidTu = false;

    public TmxFilter() {
        this.params = new Parameters();
        this.rulesMap.put("<seg>", "<bpt><ept><it><ph><hi><ut>");
        this.rulesMap.put("<sub>", "<bpt><ept><it><ph><hi><ut>");
        this.rulesMap.put("<hi>", "<bpt><ept><it><ph><hi><ut>");
        this.rulesMap.put("<bpt>", "<sub>");
        this.rulesMap.put("<ept>", "<sub>");
        this.rulesMap.put("<it>", "<sub>");
        this.rulesMap.put("<ph>", "<sub>");
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_tmx";
    }

    @Override
    public String getDisplayName() {
        return "TMX Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-tmx+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-tmx+xml", this.getClass().getName(), "TMX", "Configuration for Translation Memory eXchange (TMX) documents.", null, ".tmx;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-tmx+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty() && !this.read()) {
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(this.skel);
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.close();
            this.canceled = false;
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            if (detector.isAutodetected()) {
                input.setEncoding(detector.getEncoding());
                this.reader = fact.createXMLStreamReader(input.getStream(), detector.getEncoding());
            } else {
                this.reader = fact.createXMLStreamReader(input.getStream());
            }
            String realEnc = this.reader.getCharacterEncodingScheme();
            this.encoding = realEnc != null ? realEnc : input.getEncoding();
            this.srcLang = input.getSourceLocale();
            if (Util.isNullOrEmpty(this.srcLang)) {
                throw new NullPointerException("Source language not set.");
            }
            this.trgLang = input.getTargetLocale();
            if (Util.isNullOrEmpty(this.trgLang)) {
                throw new NullPointerException("Target language not set.");
            }
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.preserveSpaces = new Stack();
            this.preserveSpaces.push(false);
            this.tuId = 0;
            this.otherId = new IdGenerator(null, "d");
            this.hasNext = true;
            this.queue = new LinkedList();
            this.skipUtWarning = false;
            this.tuvTrgType = TuvXmlLang.UNDEFINED;
            StartDocument startDoc = new StartDocument(this.otherId.createId());
            startDoc.setName(this.docName);
            startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
            startDoc.setLocale(this.srcLang);
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType("application/x-tmx+xml");
            startDoc.setMimeType("application/x-tmx+xml");
            startDoc.setMultilingual(true);
            startDoc.setLineBreak(this.lineBreak);
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
            this.skel = new GenericSkeleton();
            startDoc.setProperty(new Property("encoding", this.encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>");
            startDoc.setSkeleton(this.skel);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private boolean read() throws XMLStreamException {
        this.skel = new GenericSkeleton();
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    DocumentPart dp;
                    if (this.reader.getLocalName().equals("tu")) {
                        if (!this.skel.isEmpty(false)) {
                            dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                            this.skel = new GenericSkeleton();
                            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                        }
                        return this.processTranslationUnit();
                    }
                    this.storeStartElement();
                    if (this.params.consolidateDpSkeleton) break;
                    dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                    this.skel = new GenericSkeleton();
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    break;
                }
                case 2: {
                    this.storeEndElement();
                    if (this.params.consolidateDpSkeleton) break;
                    DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                    this.skel = new GenericSkeleton();
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    break;
                }
                case 6: 
                case 12: {
                    this.skel.append(this.reader.getText().replace("\n", this.lineBreak));
                    break;
                }
                case 4: {
                    this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.escapeGT, null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    break;
                }
                case 11: {
                    break;
                }
                case 9: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        return false;
    }

    private void storeStartElement() {
        int i;
        String prefix = this.reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.skel.append("<" + this.reader.getLocalName());
        } else {
            this.skel.append("<" + prefix + ":" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            this.skel.append(String.format(" xmlns%s=\"%s\"", prefix.length() > 0 ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
        }
        count = this.reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            prefix = this.reader.getAttributePrefix(i);
            this.skel.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i), Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, this.params.escapeGT, null)));
        }
        this.skel.append(">");
    }

    private void storeEndElement() {
        String ns = this.reader.getPrefix();
        if (ns == null || ns.length() == 0) {
            this.skel.append("</" + this.reader.getLocalName() + ">");
        } else {
            this.skel.append("</" + ns + ":" + this.reader.getLocalName() + ">");
        }
    }

    private boolean processTuDocumentPart(TmxTu tmxTu) {
        String propName = "";
        String startElement = this.reader.getLocalName();
        if (this.tuvTrgType == TuvXmlLang.UNDEFINED) {
            propName = tmxTu.parseStartElement(this.reader, startElement, this.params.escapeGT);
        } else if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.processAllTargets) {
            propName = tmxTu.curTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.processAllTargets, startElement);
        }
        try {
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 4: {
                        if (this.tuvTrgType == TuvXmlLang.UNDEFINED) {
                            tmxTu.appendToSkel(Util.escapeToXML(this.reader.getText(), 0, this.params.escapeGT, null));
                            tmxTu.addProp(new Property(propName, this.reader.getText(), true));
                            break;
                        }
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.processAllTargets) {
                            tmxTu.curTuv.skelBefore.append(Util.escapeToXML(this.reader.getText(), 0, this.params.escapeGT, null));
                            tmxTu.curTuv.setProperty(new Property(propName, this.reader.getText(), true));
                            break;
                        }
                        if (this.tuvTrgType != TuvXmlLang.OTHER) break;
                        tmxTu.curTuv.skelBefore.append(Util.escapeToXML(this.reader.getText(), 0, this.params.escapeGT, null));
                        break;
                    }
                    case 2: {
                        if (!this.reader.getLocalName().equalsIgnoreCase(startElement)) break;
                        if (this.tuvTrgType == TuvXmlLang.UNDEFINED) {
                            tmxTu.parseEndElement(this.reader, true);
                        } else if (this.tuvTrgType == TuvXmlLang.UNDEFINED || this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.processAllTargets) {
                            tmxTu.curTuv.parseEndElement(this.reader, true);
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean processSeg(TmxTu tmxTu) {
        int id = 0;
        TextFragment tf = this.tuvTrgType == TuvXmlLang.SOURCE ? tmxTu.curTuv.tc.getFirstContent() : (this.tuvTrgType == TuvXmlLang.TARGET || this.params.processAllTargets ? tmxTu.curTuv.tc.getFirstContent() : null);
        tmxTu.curTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.processAllTargets);
        try {
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                if (this.skipInvalidTu) {
                    if (eventType != 2 || !this.reader.getLocalName().equalsIgnoreCase("seg")) continue;
                    return false;
                }
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.processAllTargets) {
                            tf.append(this.reader.getText());
                            break;
                        }
                        tmxTu.curTuv.appendToSkel(Util.escapeToXML(this.reader.getText(), 0, this.params.escapeGT, null));
                        break;
                    }
                    case 1: {
                        String curLocalName = this.reader.getLocalName().toLowerCase();
                        if (!this.isValidElement(this.elemStack.peek(), curLocalName, this.params.exitOnInvalid)) {
                            this.skipInvalidTu = true;
                            break;
                        }
                        if (curLocalName.equals("ut") && !this.skipUtWarning) {
                            this.logger.warning("<ut> is been deprecated in tmx 1.4.");
                            this.skipUtWarning = true;
                        }
                        this.elemStack.push(curLocalName);
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.processAllTargets) {
                            if (curLocalName.equals("hi")) {
                                String typeAttr = this.getTypeAttribute();
                                tf.append(TextFragment.TagType.OPENING, typeAttr != null ? typeAttr : "hi", "<hi>");
                                break;
                            }
                            if (curLocalName.equals("ph") || curLocalName.equals("it") || curLocalName.equals("ut")) {
                                this.appendCode(TextFragment.TagType.PLACEHOLDER, ++id, curLocalName, curLocalName, tf);
                                break;
                            }
                            if (curLocalName.equals("bpt")) {
                                this.appendCode(TextFragment.TagType.OPENING, ++id, curLocalName, "Xpt", tf);
                                break;
                            }
                            if (!curLocalName.equals("ept")) break;
                            this.appendCode(TextFragment.TagType.CLOSING, -1, curLocalName, "Xpt", tf);
                            break;
                        }
                        tmxTu.curTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.processAllTargets);
                        break;
                    }
                    case 2: {
                        String curLocalName = this.reader.getLocalName();
                        this.elemStack.pop();
                        if (curLocalName.equalsIgnoreCase("seg")) {
                            tmxTu.curTuv.finishedSegSection = true;
                            tmxTu.curTuv.parseEndElement(this.reader);
                            return true;
                        }
                        if (this.tuvTrgType == TuvXmlLang.SOURCE || this.tuvTrgType == TuvXmlLang.TARGET || this.params.processAllTargets) {
                            if (!curLocalName.equals("hi")) break;
                            tf.append(TextFragment.TagType.CLOSING, "hi", "</hi>");
                            break;
                        }
                        tmxTu.curTuv.parseEndElement(this.reader, true);
                    }
                }
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean processTranslationUnit() {
        TmxTu tmxTu = new TmxTu(this.srcLang, this.trgLang, this.lineBreak);
        tmxTu.parseStartElement(this.reader, this.params.escapeGT);
        try {
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                if (this.skipInvalidTu) {
                    if (eventType != 2 || !this.reader.getLocalName().equalsIgnoreCase("tu")) continue;
                    this.tuvTrgType = TuvXmlLang.UNDEFINED;
                    this.skipInvalidTu = false;
                    this.elemStack.clear();
                    Property p = tmxTu.getProp("tuid");
                    if (p != null) {
                        this.logger.warning("Skipping invalid <tu> element with tuid: " + p.getValue() + ".");
                    } else {
                        this.logger.warning("Skipping invalid <tu> element.");
                    }
                    return true;
                }
                switch (eventType) {
                    case 5: {
                        tmxTu.smartAppendToSkel(this.tuvTrgType, "<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                        break;
                    }
                    case 4: {
                        tmxTu.smartAppendToSkel(this.tuvTrgType, Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.escapeGT, null));
                        break;
                    }
                    case 1: {
                        String curLocalName = this.reader.getLocalName();
                        if (curLocalName.equalsIgnoreCase("note") || curLocalName.equalsIgnoreCase("prop")) {
                            this.processTuDocumentPart(tmxTu);
                            break;
                        }
                        if (this.reader.getLocalName().equals("tuv")) {
                            LocaleId currentLang = this.getXmlLangFromCurTuv();
                            this.tuvTrgType = this.getTuvTrgType(currentLang);
                            TmxTuv tmxTuv = tmxTu.addTmxTuv(currentLang, this.tuvTrgType);
                            tmxTuv.parseStartElement(this.reader, this.tuvTrgType, this.params.processAllTargets);
                            break;
                        }
                        if (!this.reader.getLocalName().equals("seg")) break;
                        this.elemStack.push("seg");
                        this.processSeg(tmxTu);
                        break;
                    }
                    case 2: {
                        String curLocalName = this.reader.getLocalName();
                        if (curLocalName.equalsIgnoreCase("tu")) {
                            tmxTu.parseEndElement(this.reader);
                            this.tuId = tmxTu.addPrimaryTextUnitEvent(this.tuId, this.params.processAllTargets, this.queue);
                            this.tuId = tmxTu.addDuplicateTextUnitEvents(this.tuId, this.params.processAllTargets, this.queue);
                            this.tuvTrgType = TuvXmlLang.UNDEFINED;
                            return true;
                        }
                        if (curLocalName.equals("tuv")) {
                            tmxTu.curTuv.parseEndElement(this.reader);
                            break;
                        }
                        if (this.params.exitOnInvalid) {
                            throw new OkapiBadFilterInputException("Only <note>, <prop>, and <tuv> elements are allowed inside <tu>");
                        }
                        this.logger.warning("Only <note>, <prop>, and <tuv> elements are allowed inside <tu>");
                        this.skipInvalidTu = true;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return false;
    }

    private void appendCode(TextFragment.TagType tagType, int id, String tagName, String type, TextFragment fragment) {
        try {
            String prefix;
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = null;
            outerCode = new StringBuilder();
            outerCode.append("<" + tagName);
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                prefix = this.reader.getAttributePrefix(i);
                outerCode.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i), Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, this.params.escapeGT, null)));
            }
            outerCode.append(">");
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        int i;
                        String localName = this.reader.getLocalName().toLowerCase();
                        if (!this.isValidElement(this.elemStack.peek(), localName, true)) {
                            // empty if block
                        }
                        if (localName.equals("ut") && !this.skipUtWarning) {
                            this.logger.warning("<ut> is been deprecated in tmx 1.4.");
                            this.skipUtWarning = true;
                        }
                        this.elemStack.push(localName);
                        if ("sub".equals(this.reader.getLocalName())) {
                            this.logger.warning("A <sub> element was detected. It will be included in its parent code as <sub> is currently not supported.");
                        }
                        prefix = this.reader.getPrefix();
                        StringBuilder tmpg = new StringBuilder();
                        if (prefix == null || prefix.length() == 0) {
                            tmpg.append("<" + this.reader.getLocalName());
                        } else {
                            tmpg.append("<" + prefix + ":" + this.reader.getLocalName());
                        }
                        count = this.reader.getNamespaceCount();
                        for (i = 0; i < count; ++i) {
                            prefix = this.reader.getNamespacePrefix(i);
                            tmpg.append(String.format(" xmlns%s=\"%s\"", prefix != null ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
                        }
                        count = this.reader.getAttributeCount();
                        for (i = 0; i < count; ++i) {
                            if (!this.reader.isAttributeSpecified(i)) continue;
                            prefix = this.reader.getAttributePrefix(i);
                            tmpg.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i), Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, this.params.escapeGT, null)));
                        }
                        tmpg.append(">");
                        innerCode.append(tmpg.toString());
                        outerCode.append(tmpg.toString());
                        break;
                    }
                    case 2: {
                        this.elemStack.pop();
                        if (tagName.equals(this.reader.getLocalName()) && (this.elemStack.peek().equals("seg") || this.elemStack.peek().equals("hi"))) {
                            Code code = fragment.append(tagType, type, innerCode.toString(), id);
                            outerCode.append("</" + tagName + ">");
                            code.setOuterData(outerCode.toString());
                            return;
                        }
                        String ns = this.reader.getPrefix();
                        if (ns == null || ns.length() == 0) {
                            innerCode.append("</" + this.reader.getLocalName() + ">");
                            outerCode.append("</" + this.reader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + ns + ":" + this.reader.getLocalName() + ">");
                        outerCode.append("</" + ns + ":" + this.reader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.reader.getText());
                        outerCode.append(Util.escapeToXML(this.reader.getText(), 0, this.params.escapeGT, null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private TuvXmlLang getTuvTrgType(LocaleId lang) {
        if (lang.equals(this.srcLang)) {
            return TuvXmlLang.SOURCE;
        }
        if (lang.equals(this.trgLang)) {
            return TuvXmlLang.TARGET;
        }
        return TuvXmlLang.OTHER;
    }

    private LocaleId getXmlLangFromCurTuv() {
        String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
        if (tmp != null) {
            return LocaleId.fromString(tmp);
        }
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.getAttributeLocalName(i).equals("lang")) continue;
            return LocaleId.fromString(this.reader.getAttributeValue(i));
        }
        throw new OkapiBadFilterInputException("The required xml:lang or lang attribute is missing in <tuv>. The file is not valid TMX.");
    }

    private String getTypeAttribute() {
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.getAttributeLocalName(i).equals("lang")) continue;
            return this.reader.getAttributeValue(i);
        }
        return null;
    }

    private boolean isValidElement(String curElem, String newElem, boolean throwException) {
        String rules = this.rulesMap.get("<" + curElem + ">");
        if (rules != null && rules.contains("<" + newElem + ">")) {
            return true;
        }
        if (throwException) {
            throw new OkapiBadFilterInputException("<" + newElem + "> not allowed in <" + curElem + ">. Only " + rules + " allowed.");
        }
        this.logger.warning("<" + newElem + "> not allowed in <" + curElem + ">. Only " + rules + " allowed.");
        return false;
    }

    public static enum TuvXmlLang {
        UNDEFINED,
        SOURCE,
        TARGET,
        OTHER;

    }
}

