/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.xini.jaxb.Empty;
import net.sf.okapi.filters.xini.jaxb.EndPlaceHolder;
import net.sf.okapi.filters.xini.jaxb.ObjectFactory;
import net.sf.okapi.filters.xini.jaxb.PlaceHolder;
import net.sf.okapi.filters.xini.jaxb.PlaceHolderType;
import net.sf.okapi.filters.xini.jaxb.StartPlaceHolder;
import net.sf.okapi.filters.xini.jaxb.TextContent;

public class InlineCodeTransformer {
    private static final Logger LOGGER = Logger.getLogger(InlineCodeTransformer.class.getName());
    private static final boolean TARGET_IS_TKIT = true;
    private static final boolean TARGET_IS_FILTER = false;
    private static final Map<String, String> tagType;
    private static ObjectFactory objectFactory;
    public static final String CODE_TYPE_SUP = "superscript";
    public static final String CODE_TYPE_SUB = "subscript";
    private int id = -2;

    public ArrayList<Serializable> codesToJAXBForFilter(String codedText, List<Code> codes) {
        return this.codesToJAXB(codedText, codes, false);
    }

    public ArrayList<Serializable> codesToJAXBForTKit(String codedText, List<Code> codes) {
        return this.codesToJAXB(codedText, codes, true);
    }

    public ArrayList<Serializable> codesToJAXB(String codedText, List<Code> codes, boolean targetIsRainbowkit) {
        ArrayList<Serializable> parts = new ArrayList<Serializable>();
        StringBuilder tempString = new StringBuilder();
        block5: for (int charIndex = 0; charIndex < codedText.length(); ++charIndex) {
            char chr = codedText.charAt(charIndex);
            if (!TextFragment.isMarker(chr)) {
                tempString.append(chr);
                continue;
            }
            int codePoint = codedText.codePointAt(charIndex);
            Integer codeIndex = TextFragment.toIndex(codedText.charAt(++charIndex));
            Code code = codes.get(codeIndex);
            boolean codeIsIsolated = false;
            if (tempString.length() > 0) {
                parts.add((Serializable)((Object)tempString.toString()));
            }
            tempString = new StringBuilder();
            switch (codePoint) {
                case 57601: {
                    Integer endMarkerIndex = this.findEndMark(codes, code, codedText, charIndex);
                    String innerCodedText = null;
                    if (endMarkerIndex != null) {
                        innerCodedText = codedText.substring(charIndex + 1, endMarkerIndex - 1);
                        charIndex = endMarkerIndex;
                    } else {
                        codeIsIsolated = true;
                    }
                    parts.add(this.codeToXMLObject(code, codes, innerCodedText, codeIsIsolated, targetIsRainbowkit));
                    continue block5;
                }
                case 57602: {
                    parts.add(this.codeToXMLObject(code, codes, null, true, targetIsRainbowkit));
                    continue block5;
                }
                case 57603: {
                    parts.add(this.codeToXMLObject(code, codes, null, true, targetIsRainbowkit));
                }
            }
        }
        if (tempString.length() > 0) {
            parts.add((Serializable)((Object)tempString.toString()));
        }
        return parts;
    }

    private Integer findEndMark(List<Code> codes, Code code, String codedText, int startCharIndex) {
        for (int charIndex = startCharIndex; charIndex < codedText.length(); ++charIndex) {
            int codePoint = codedText.codePointAt(charIndex);
            if (codePoint != 57602 || codedText.length() <= charIndex + 1) continue;
            int endCodeIndex = TextFragment.toIndex(codedText.charAt(++charIndex));
            Code endCode = codes.get(endCodeIndex);
            try {
                if (!endCode.getType().equals(code.getType()) || endCode.getId() != code.getId() || codePoint != 57602) continue;
                return charIndex;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return null;
    }

    private Serializable codeToXMLObject(Code code, List<Code> codes, String innerCodedText, boolean codeIsIsolated, boolean targetIsRainbowkit) {
        if (!targetIsRainbowkit) {
            return this.codeToXMLObjectForXINIFilter(code, codes, innerCodedText, codeIsIsolated);
        }
        return this.codeToXMLObjectForRainbowKit(code, codes, innerCodedText, codeIsIsolated);
    }

    private Serializable codeToXMLObjectForXINIFilter(Code code, List<Code> codes, String innerCodedText, boolean codeIsIsolated) {
        Object inlineElement;
        String codeType = code.getType();
        String phTypeAttribute = null;
        if ("null".equals(codeType)) {
            codeType = null;
        } else if (codeType.equals("x-sph") || codeType.equals("x-eph")) {
            phTypeAttribute = null;
        } else if (codeType.startsWith("x-sph-") || codeType.startsWith("x-eph-")) {
            phTypeAttribute = codeType.substring(6);
        } else if (codeType.startsWith("x-")) {
            phTypeAttribute = codeType.substring(2);
        }
        if (!codeIsIsolated) {
            ArrayList<Serializable> innerXML = null;
            if (innerCodedText != null && !innerCodedText.isEmpty()) {
                innerXML = this.codesToJAXB(innerCodedText, codes, false);
            }
            TextContent tc = new TextContent();
            if (innerXML != null) {
                tc.getContent().addAll(innerXML);
            }
            if ("bold".equals(codeType)) {
                inlineElement = objectFactory.createTextContentB(tc);
            } else if ("italic".equals(codeType)) {
                inlineElement = objectFactory.createTextContentI(tc);
            } else if ("underlined".equals(codeType)) {
                inlineElement = objectFactory.createTextContentU(tc);
            } else if (CODE_TYPE_SUP.equals(codeType)) {
                inlineElement = objectFactory.createTextContentSup(tc);
            } else if (CODE_TYPE_SUB.equals(codeType)) {
                inlineElement = objectFactory.createTextContentSub(tc);
            } else {
                PlaceHolder ph = new PlaceHolder();
                ph.setID(code.getId());
                if (phTypeAttribute != null) {
                    ph.setType(PlaceHolderType.fromValue(phTypeAttribute));
                }
                ph.getContent().addAll(tc.getContent());
                inlineElement = objectFactory.createTextContentPh(ph);
            }
        } else if (codeIsIsolated && codeType == "lb") {
            inlineElement = objectFactory.createTextContentBr(new Empty());
        } else if (codeIsIsolated && code.getTagType() == TextFragment.TagType.PLACEHOLDER) {
            PlaceHolder ph = new PlaceHolder();
            ph.setID(code.getId());
            if (phTypeAttribute != null) {
                ph.setType(PlaceHolderType.fromValue(phTypeAttribute));
            }
            inlineElement = objectFactory.createTextContentPh(ph);
        } else if (code.getTagType() == TextFragment.TagType.OPENING) {
            StartPlaceHolder sph = new StartPlaceHolder();
            sph.setID(code.getId());
            if (phTypeAttribute != null) {
                sph.setType(PlaceHolderType.fromValue(phTypeAttribute));
            }
            inlineElement = objectFactory.createTextContentSph(sph);
        } else {
            EndPlaceHolder eph = new EndPlaceHolder();
            eph.setID(code.getId());
            if (phTypeAttribute != null) {
                eph.setType(PlaceHolderType.fromValue(phTypeAttribute));
            }
            inlineElement = objectFactory.createTextContentEph(eph);
        }
        return inlineElement;
    }

    private Serializable codeToXMLObjectForRainbowKit(Code code, List<Code> codes, String innerCodedText, boolean codeIsIsolated) {
        Object phelement;
        String codeOuterData = code.getOuterData();
        if (!codeIsIsolated || codeIsIsolated && code.getTagType() == TextFragment.TagType.PLACEHOLDER) {
            Code correspondingCode;
            PlaceHolder ph = new PlaceHolder();
            ph.setID(code.getId());
            ph.setType(PlaceHolderType.PH);
            ph.setOpening(codeOuterData);
            if (code.getTagType() == TextFragment.TagType.OPENING && (correspondingCode = InlineCodeTransformer.lookupForCorrespondingCode(code, codes)) != null) {
                ph.setClosing(correspondingCode.getOuterData());
            }
            if (innerCodedText != null && !innerCodedText.isEmpty()) {
                ph.getContent().addAll(this.codesToJAXB(innerCodedText, codes, true));
            }
            phelement = objectFactory.createTextContentPh(ph);
        } else if (code.getTagType() == TextFragment.TagType.OPENING) {
            StartPlaceHolder sph = new StartPlaceHolder();
            sph.setID(code.getId());
            sph.setType(PlaceHolderType.PH);
            sph.setOpening(codeOuterData);
            phelement = objectFactory.createTextContentSph(sph);
        } else {
            EndPlaceHolder eph = new EndPlaceHolder();
            eph.setID(code.getId());
            eph.setType(PlaceHolderType.PH);
            eph.setClosing(codeOuterData);
            phelement = objectFactory.createTextContentEph(eph);
        }
        return phelement;
    }

    private static Code lookupForCorrespondingCode(Code code, List<Code> codes) {
        int wantedCodeId = code.getId();
        String wantedCodeType = code.getType();
        int startPosition = codes.indexOf(code) + 1;
        if (startPosition > codes.size()) {
            return null;
        }
        for (int i = startPosition; i < codes.size(); ++i) {
            Code currentCode = codes.get(i);
            if (currentCode.getId() != wantedCodeId || currentCode.getType() != wantedCodeType) continue;
            return currentCode;
        }
        return null;
    }

    public TextFragment serializeTextPartsForFilter(List<Serializable> parts) {
        return this.serializeTextParts(parts, false);
    }

    public TextFragment serializeTextPartsForTKit(List<Serializable> parts) {
        return this.serializeTextParts(parts, true);
    }

    public TextFragment serializeTextParts(List<Serializable> parts, boolean targetIsTKit) {
        TextFragment fragment = new TextFragment();
        for (Serializable part : parts) {
            if (part instanceof String) {
                fragment.append((String)((Object)part));
                continue;
            }
            if (!(part instanceof JAXBElement)) continue;
            fragment.insert(-1, this.processInlineTag(part, targetIsTKit), true);
        }
        return fragment;
    }

    private TextFragment processInlineTag(Serializable part, boolean targetIsTKit) {
        if (targetIsTKit) {
            return this.processInlineTagForTKit(part);
        }
        return this.processInlineTagForFilter(part);
    }

    private TextFragment processInlineTagForFilter(Serializable part) {
        TextFragment fragment = new TextFragment();
        JAXBElement jaxbEl = (JAXBElement)part;
        List<Serializable> content = null;
        if (jaxbEl.getValue() instanceof PlaceHolder) {
            JAXBElement ph = (JAXBElement)part;
            content = ((PlaceHolder)ph.getValue()).getContent();
            if (content == null || content.isEmpty()) {
                Code code = new Code(TextFragment.TagType.PLACEHOLDER, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                PlaceHolderType phTypeValue = ((PlaceHolder)ph.getValue()).getType();
                if (phTypeValue != null) {
                    code.setType("x-" + phTypeValue.value());
                }
                fragment.append(code);
            } else {
                Code code = new Code(TextFragment.TagType.OPENING, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                PlaceHolderType phTypeValue = ((PlaceHolder)ph.getValue()).getType();
                if (phTypeValue != null) {
                    code.setType("x-" + phTypeValue.value());
                }
                fragment.append(code);
                TextFragment innerText = this.serializeTextParts(content, false);
                fragment.insert(-1, innerText, true);
                code = new Code(TextFragment.TagType.CLOSING, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                if (phTypeValue != null) {
                    code.setType("x-" + phTypeValue.value());
                }
                fragment.append(code);
            }
        } else if (jaxbEl.getValue() instanceof StartPlaceHolder) {
            JAXBElement sph = (JAXBElement)part;
            Code code = new Code(TextFragment.TagType.OPENING, null);
            code.setId(((StartPlaceHolder)sph.getValue()).getID());
            PlaceHolderType sphTypeValue = ((StartPlaceHolder)sph.getValue()).getType();
            String sphCodeType = "x-sph";
            if (sphTypeValue != null) {
                sphCodeType = sphCodeType + "-" + sphTypeValue.value();
            }
            code.setType(sphCodeType);
            fragment.append(code);
        } else if (jaxbEl.getValue() instanceof EndPlaceHolder) {
            JAXBElement eph = (JAXBElement)part;
            Code code = new Code(TextFragment.TagType.CLOSING, null);
            code.setId(((EndPlaceHolder)eph.getValue()).getID());
            PlaceHolderType ephTypeValue = ((EndPlaceHolder)eph.getValue()).getType();
            String ephCodeType = "x-eph";
            if (ephTypeValue != null) {
                ephCodeType = ephCodeType + "-" + ephTypeValue.value();
            }
            code.setType(ephCodeType);
            fragment.append(code);
        } else if (jaxbEl.getValue() instanceof Empty) {
            Code code = new Code(TextFragment.TagType.PLACEHOLDER, null);
            code.setType("lb");
            code.setId(this.getNextDecrementedID());
            fragment.append(code);
        } else if (jaxbEl.getValue() instanceof TextContent) {
            JAXBElement inlineElem = (JAXBElement)part;
            content = ((TextContent)inlineElem.getValue()).getContent();
            if (content == null || content.isEmpty()) {
                Code code = new Code(TextFragment.TagType.PLACEHOLDER, null);
                code.setId(this.getNextDecrementedID());
                this.changeCodeType(code, (JAXBElement<TextContent>)inlineElem);
                fragment.append(code);
            } else {
                Code code = new Code(TextFragment.TagType.OPENING, null);
                int codeId = this.getNextDecrementedID();
                code.setId(codeId);
                this.changeCodeType(code, (JAXBElement<TextContent>)inlineElem);
                fragment.append(code);
                TextFragment innerText = this.serializeTextParts(content, false);
                fragment.insert(-1, innerText, true);
                code = new Code(TextFragment.TagType.CLOSING, null);
                code.setId(codeId);
                this.changeCodeType(code, (JAXBElement<TextContent>)inlineElem);
                fragment.append(code);
            }
        } else {
            throw new OkapiBadFilterInputException("Unknown inline element: " + part);
        }
        return fragment;
    }

    private void changeCodeType(Code code, JAXBElement<TextContent> inlineElem) {
        String elementName = inlineElem.getName().getLocalPart();
        code.setType(tagType.get(elementName));
    }

    private TextFragment processInlineTagForTKit(Serializable part) {
        TextFragment fragment = new TextFragment();
        JAXBElement jaxbEl = (JAXBElement)part;
        List<Serializable> content = null;
        if (jaxbEl.getValue() instanceof PlaceHolder) {
            JAXBElement ph = (JAXBElement)part;
            content = ((PlaceHolder)ph.getValue()).getContent();
            if (content == null || content.isEmpty()) {
                Code code = new Code(TextFragment.TagType.PLACEHOLDER, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                fragment.append(code);
            } else {
                Code code = new Code(TextFragment.TagType.OPENING, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                fragment.append(code);
                TextFragment innerText = this.serializeTextParts(content, true);
                fragment.append(innerText);
                code = new Code(TextFragment.TagType.CLOSING, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                fragment.append(code);
            }
        } else if (jaxbEl.getValue() instanceof StartPlaceHolder) {
            JAXBElement sph = (JAXBElement)part;
            Code code = new Code(TextFragment.TagType.OPENING, null);
            code.setId(((StartPlaceHolder)sph.getValue()).getID());
            fragment.append(code);
        } else if (jaxbEl.getValue() instanceof EndPlaceHolder) {
            JAXBElement eph = (JAXBElement)part;
            Code code = new Code(TextFragment.TagType.CLOSING, null);
            code.setId(((EndPlaceHolder)eph.getValue()).getID());
            fragment.append(code);
        } else if (jaxbEl.getValue() instanceof Empty) {
            LOGGER.warning("Inline element " + jaxbEl.getName() + " will be ignored");
        } else if (jaxbEl.getValue() instanceof TextContent) {
            LOGGER.warning("Inline element " + jaxbEl.getName() + " will be ignored");
            JAXBElement txtC = (JAXBElement)part;
            TextFragment innerText = this.serializeTextParts(((TextContent)txtC.getValue()).getContent(), true);
            fragment.append(innerText);
        } else {
            throw new OkapiBadFilterInputException("Unknown inline element: " + part);
        }
        return fragment;
    }

    private int getNextDecrementedID() {
        return this.id--;
    }

    static {
        HashMap<String, String> tagTypes = new HashMap<String, String>();
        tagTypes.put("b", "bold");
        tagTypes.put("i", "italic");
        tagTypes.put("u", "underlined");
        tagTypes.put("sup", CODE_TYPE_SUP);
        tagTypes.put("sub", CODE_TYPE_SUB);
        tagTypes.put("br", "lb");
        tagType = Collections.unmodifiableMap(tagTypes);
        objectFactory = new ObjectFactory();
    }
}

