/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.DefaultEntityResolver;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.TermsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xml.ContextItem;
import net.sf.okapi.filters.xml.Parameters;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.its.ITSEngine;
import org.w3c.its.ITraversal;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@UsingParameters(value=Parameters.class)
public class XMLFilter
implements IFilter {
    private String docName;
    private String encoding;
    private LocaleId srcLang;
    private String lineBreak;
    private Document doc;
    private ITraversal trav;
    private LinkedList<Event> queue;
    private int tuId;
    private IdGenerator otherId;
    private TextFragment frag;
    private GenericSkeleton skel;
    private Stack<ContextItem> context;
    private boolean canceled;
    private Parameters params = new Parameters();
    private boolean hasUTF8BOM;
    private EncoderManager encoderManager;
    private IEncoder cfEncoder;
    private TermsAnnotation terms;
    private RawDocument input;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public String getName() {
        return "okf_xml";
    }

    @Override
    public String getDisplayName() {
        return "XML Filter";
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/xml", this.getClass().getName(), "Generic XML", "Configuration for generic XML documents (default ITS rules).", null, ".xml;"));
        list.add(new FilterConfiguration(this.getName() + "-resx", "text/xml", this.getClass().getName(), "RESX", "Configuration for Microsoft RESX documents (without binary data).", "resx.fprm", ".resx;"));
        list.add(new FilterConfiguration(this.getName() + "-MozillaRDF", "text/xml", this.getClass().getName(), "Mozilla RDF", "Configuration for Mozilla RDF documents.", "MozillaRDF.fprm", ".rdf;"));
        list.add(new FilterConfiguration(this.getName() + "-JavaProperties", "text/xml", this.getClass().getName(), "Java Properties XML", "Configuration for Java Properties files in XML.", "JavaProperties.fprm"));
        list.add(new FilterConfiguration(this.getName() + "-AndroidStrings", "text/xml", this.getClass().getName(), "Android Strings", "Configuration for Android Strings XML documents.", "AndroidStrings.fprm"));
        list.add(new FilterConfiguration(this.getName() + "-WixLocalization", "text/xml", this.getClass().getName(), "WiX Localization", "Configuration for WiX (Windows Installer XML) Localization files.", "WixLocalization.fprm", ".wxl;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue = null;
            return new Event(EventType.CANCELED);
        }
        if (this.queue == null) {
            return null;
        }
        do {
            if (this.queue.size() > 0) {
                Event event = this.queue.poll();
                if (event.getEventType() == EventType.END_DOCUMENT) {
                    this.queue = null;
                }
                return event;
            }
            this.process();
        } while (this.queue.size() != 0);
        return null;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        DocumentType dt;
        DocumentBuilder docBuilder;
        this.close();
        this.input = input;
        this.canceled = false;
        this.tuId = 0;
        this.otherId = new IdGenerator(null, "o");
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        fact.setValidating(false);
        fact.setExpandEntityReferences(!this.params.protectEntityRef);
        try {
            docBuilder = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiIOException(e);
        }
        docBuilder.setEntityResolver(new DefaultEntityResolver());
        input.setEncoding("UTF-8");
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectBom();
        if (detector.isAutodetected()) {
            this.encoding = detector.getEncoding();
            if (this.encoding.equals("UTF-16LE") || this.encoding.equals("UTF-16BE")) {
                this.encoding = "UTF-16";
            }
            input.setEncoding(this.encoding);
        }
        try {
            InputSource is = new InputSource(input.getStream());
            this.doc = docBuilder.parse(is);
        }
        catch (SAXException e) {
            throw new OkapiIOException("Error when parsing the document.\n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error when reading the document.\n" + e.getMessage(), e);
        }
        this.encoding = this.doc.getXmlEncoding();
        if (this.encoding == null) {
            this.encoding = detector.getEncoding();
        }
        this.srcLang = input.getSourceLocale();
        if (this.srcLang == null) {
            throw new NullPointerException("Source language not set.");
        }
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        if (this.params.useCodeFinder) {
            this.params.codeFinder.compile();
        }
        ITSEngine itsEng = new ITSEngine(this.doc, input.getInputURI());
        if (this.params != null && this.params.getDocument() != null) {
            itsEng.addExternalRules(this.params.getDocument(), this.params.getURI());
        }
        itsEng.applyRules(159);
        this.trav = itsEng;
        this.trav.startTraversal();
        this.context = new Stack();
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(this.otherId.createId());
        startDoc.setName(this.docName);
        String realEnc = this.doc.getInputEncoding();
        if (realEnc != null) {
            this.encoding = realEnc;
        }
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setLocale(this.srcLang);
        this.params.quoteModeDefined = true;
        this.params.quoteMode = 3;
        if (!itsEng.getTranslatableAttributeRuleTriggered() && !this.params.escapeQuotes) {
            this.params.quoteModeDefined = true;
            this.params.quoteMode = 0;
        }
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType("text/xml");
        startDoc.setMimeType("text/xml");
        this.skel = new GenericSkeleton();
        if (!this.params.omitXMLDeclaration) {
            this.skel.add("<?xml version=\"" + this.doc.getXmlVersion() + "\"");
            this.skel.add(" encoding=\"");
            this.skel.addValuePlaceholder(startDoc, "encoding", LocaleId.EMPTY);
            this.skel.add("\"");
            startDoc.setProperty(new Property("encoding", this.encoding, false));
            if (this.doc.getXmlStandalone()) {
                this.skel.add(" standalone=\"yes\"");
            }
            this.skel.add("?>" + this.lineBreak);
        }
        if ((dt = this.doc.getDoctype()) != null) {
            this.rebuildDocTypeSection(dt);
        }
        startDoc.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
    }

    private void rebuildDocTypeSection(DocumentType dt) {
        StringBuilder tmp = new StringBuilder();
        if (dt.getPublicId() != null) {
            tmp.append(String.format("<!DOCTYPE %s PUBLIC \"%s\" \"%s\"", dt.getName(), dt.getPublicId(), dt.getSystemId()));
        } else if (dt.getSystemId() != null) {
            tmp.append(String.format("<!DOCTYPE %s SYSTEM \"%s\"", dt.getName(), dt.getSystemId()));
        } else if (dt.getInternalSubset() != null) {
            tmp.append(String.format("<!DOCTYPE %s", dt.getName()));
        }
        if (dt.getInternalSubset() != null) {
            tmp.append(" [");
            tmp.append(dt.getInternalSubset().replace("\n", this.lineBreak));
            tmp.append("]");
        }
        if (tmp.length() > 0) {
            tmp.append(">" + this.lineBreak);
            this.skel.add(tmp.toString());
        }
    }

    private void process() {
        this.frag = null;
        this.skel = new GenericSkeleton();
        if (this.context.size() > 0 && this.context.peek().translate) {
            this.frag = new TextFragment();
        }
        while (true) {
            Node node;
            if ((node = this.trav.nextNode()) == null) {
                Ending ending = new Ending(this.otherId.createId());
                if (this.skel != null && !this.skel.isEmpty()) {
                    ending.setSkeleton(this.skel);
                }
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                return;
            }
            switch (node.getNodeType()) {
                case 4: {
                    if (this.frag == null) {
                        this.skel.append(this.buildCDATA(node));
                        break;
                    }
                    if (this.trav.translate()) {
                        this.frag.append(node.getNodeValue());
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildCDATA(node));
                    break;
                }
                case 3: {
                    if (this.frag == null) {
                        this.skel.append(Util.escapeToXML(node.getNodeValue().replace("\n", this.lineBreak), 0, false, null));
                        break;
                    }
                    if (this.trav.translate()) {
                        if (this.params.lineBreakAsCode) {
                            this.escapeAndAppend(this.frag, node.getNodeValue());
                            break;
                        }
                        this.frag.append(node.getNodeValue());
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, Util.escapeToXML(node.getNodeValue().replace("\n", this.params.escapeLineBreak ? "&#10;" : this.lineBreak), 0, false, null));
                    break;
                }
                case 1: {
                    if (!this.processElementTag(node)) break;
                    return;
                }
                case 7: {
                    if (this.frag == null) {
                        this.skel.add(this.buildPI(node));
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildPI(node));
                    break;
                }
                case 8: {
                    if (this.frag == null) {
                        this.skel.add(this.buildComment(node));
                        break;
                    }
                    this.frag.append(TextFragment.TagType.PLACEHOLDER, null, this.buildComment(node));
                    break;
                }
                case 5: {
                    if (this.trav.backTracking()) break;
                    if (this.frag == null) {
                        this.skel.add("&" + node.getNodeName() + ";");
                    } else {
                        this.frag.append(TextFragment.TagType.PLACEHOLDER, "ref", "&" + node.getNodeName() + ";");
                    }
                    if (!node.hasChildNodes()) break;
                    Node thisNode = node;
                    while ((node = this.trav.nextNode()) != thisNode) {
                    }
                    break;
                }
                case 10: {
                    break;
                }
                case 12: {
                    break;
                }
            }
        }
    }

    private void escapeAndAppend(TextFragment frag, String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "&#10;");
                continue;
            }
            frag.append(text.charAt(i));
        }
    }

    private void addStartTagToSkeleton(Node node) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("<" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName());
        if (node.hasAttributes()) {
            NamedNodeMap list = node.getAttributes();
            for (int i = 0; i < list.getLength(); ++i) {
                Attr attr = (Attr)list.item(i);
                if (!attr.getSpecified()) continue;
                tmp.append(" " + (attr.getPrefix() == null ? "" : attr.getPrefix() + ":") + attr.getLocalName() + "=\"");
                if (this.trav.translate(attr) && attr.getValue().length() > 0) {
                    this.skel.append(tmp.toString());
                    tmp.setLength(0);
                    this.addAttributeTextUnit(attr, true);
                    tmp.append("\"");
                    continue;
                }
                if (attr.getName().equals("xml:lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
            }
        }
        if (!node.hasChildNodes()) {
            tmp.append("/");
        }
        tmp.append(">");
        this.skel.append(tmp.toString());
    }

    private void addStartTagToFragment(Node node) {
        StringBuilder tmp = new StringBuilder();
        String id = null;
        tmp.append("<" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName());
        if (node.hasAttributes()) {
            NamedNodeMap list = node.getAttributes();
            for (int i = 0; i < list.getLength(); ++i) {
                Attr attr = (Attr)list.item(i);
                if (!attr.getSpecified()) continue;
                tmp.append(" " + (attr.getPrefix() == null ? "" : attr.getPrefix() + ":") + attr.getLocalName() + "=\"");
                if (this.trav.translate(attr) && attr.getValue().length() > 0) {
                    id = this.addAttributeTextUnit(attr, false);
                    tmp.append(TextFragment.makeRefMarker(id));
                    tmp.append("\"");
                    continue;
                }
                if (attr.getName().equals("xml:lang")) {
                    tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
                    continue;
                }
                tmp.append(Util.escapeToXML(attr.getNodeValue(), 3, false, null) + "\"");
            }
        }
        if (!node.hasChildNodes()) {
            tmp.append("/");
        }
        tmp.append(">");
        Code code = this.frag.append(node.hasChildNodes() ? TextFragment.TagType.OPENING : TextFragment.TagType.PLACEHOLDER, node.getLocalName(), tmp.toString());
        code.setReferenceFlag(id != null);
    }

    private String addAttributeTextUnit(Attr attr, boolean addToSkeleton) {
        String id = String.valueOf(++this.tuId);
        TextUnit tu = new TextUnit(id, attr.getValue(), true, "text/xml");
        if (this.params.useCodeFinder) {
            TextFragment tf = tu.getSource().getFirstContent();
            this.params.codeFinder.process(tf);
            List<Code> codes = tf.getCodes();
            for (Code code : codes) {
                if (!code.getType().equals("regxph")) continue;
                if (this.cfEncoder == null) {
                    this.cfEncoder = this.getEncoderManager().getEncoder();
                    this.cfEncoder.setOptions(this.params, "utf-8", this.lineBreak);
                }
                code.setData(this.cfEncoder.encode(code.getData(), 0));
            }
        }
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        if (addToSkeleton) {
            this.skel.addReference(tu);
        }
        return id;
    }

    private String buildEndTag(Node node) {
        if (node.hasChildNodes()) {
            return "</" + (node.getPrefix() == null ? "" : node.getPrefix() + ":") + node.getLocalName() + ">";
        }
        return "";
    }

    private String buildPI(Node node) {
        return "<?" + node.getNodeName() + " " + node.getNodeValue() + "?>";
    }

    private String buildCDATA(Node node) {
        return "<![CDATA[" + node.getNodeValue().replace("\n", this.lineBreak) + "]]>";
    }

    private String buildComment(Node node) {
        return "<!--" + node.getNodeValue().replace("\n", this.lineBreak) + "-->";
    }

    private boolean processElementTag(Node node) {
        if (this.trav.backTracking()) {
            if (this.frag == null) {
                this.skel.add(this.buildEndTag(node));
                if (node.isSameNode(this.context.peek().node)) {
                    this.context.pop();
                }
                if (this.isContextTranslatable()) {
                    this.frag = new TextFragment();
                }
            } else {
                if (node.isSameNode(this.context.peek().node)) {
                    return this.addTextUnit(node, true);
                }
                this.frag.append(TextFragment.TagType.CLOSING, node.getLocalName(), this.buildEndTag(node));
            }
            if (this.trav.isTerm()) {
                if (this.terms == null) {
                    this.terms = new TermsAnnotation();
                }
                this.terms.add(node.getTextContent(), this.trav.getTermInfo());
            }
        } else {
            switch (this.trav.getWithinText()) {
                case 1: 
                case 2: {
                    if (this.frag == null) {
                        this.addStartTagToSkeleton(node);
                        if (!node.hasChildNodes()) break;
                        this.context.push(new ContextItem(node, this.trav));
                        break;
                    }
                    this.addStartTagToFragment(node);
                    break;
                }
                default: {
                    if (this.frag == null) {
                        this.addStartTagToSkeleton(node);
                        if (this.trav.translate()) {
                            this.frag = new TextFragment();
                        }
                        if (!node.hasChildNodes()) break;
                        this.context.push(new ContextItem(node, this.trav));
                        break;
                    }
                    this.addTextUnit(node, false);
                    this.addStartTagToSkeleton(node);
                    if (this.trav.translate()) {
                        this.frag = new TextFragment();
                    }
                    if (!node.hasChildNodes()) break;
                    this.context.push(new ContextItem(node, this.trav));
                }
            }
        }
        return false;
    }

    private boolean isContextTranslatable() {
        if (this.context.size() == 0) {
            return false;
        }
        return this.context.peek().translate;
    }

    private boolean addTextUnit(Node node, boolean popStack) {
        String id;
        boolean extract;
        boolean bl = extract = this.frag.hasText(false) || this.params.extractIfOnlyCodes && this.frag.hasCode();
        if (extract) {
            if (this.params.useCodeFinder) {
                this.params.codeFinder.process(this.frag);
                List<Code> codes = this.frag.getCodes();
                for (Code code : codes) {
                    if (!code.getType().equals("regxph")) continue;
                    if (this.cfEncoder == null) {
                        this.cfEncoder = this.getEncoderManager().getEncoder();
                        this.cfEncoder.setOptions(this.params, "utf-8", this.lineBreak);
                    }
                    code.setData(this.cfEncoder.encode(code.getData(), 0));
                }
            }
            boolean bl2 = extract = this.frag.hasText(false) || this.params.extractIfOnlyCodes && this.frag.hasCode();
        }
        if (!extract) {
            if (!this.frag.isEmpty()) {
                this.skel.add(this.frag.toText().replace("\n", this.params.escapeLineBreak ? "&#10;" : this.lineBreak));
            }
            this.frag = null;
            if (popStack) {
                this.context.pop();
                this.skel.add(this.buildEndTag(node));
                if (this.isContextTranslatable()) {
                    this.frag = new TextFragment();
                }
            }
            return false;
        }
        TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
        tu.setMimeType("text/xml");
        tu.setSourceContent(this.frag);
        String locNote = this.context.peek().locNote;
        if (locNote != null) {
            tu.setProperty(new Property("note", locNote));
        }
        if (this.terms != null) {
            tu.getSource().setAnnotation(this.terms);
            this.terms = null;
        }
        if ((id = this.context.peek().idPointer) != null) {
            tu.setName(id);
        }
        if (this.context.peek().preserveWS) {
            tu.setPreserveWhitespaces(true);
        } else {
            tu.setPreserveWhitespaces(false);
            tu.getSource().unwrap(false, true);
        }
        this.skel.addContentPlaceholder(tu);
        if (popStack) {
            this.context.pop();
            this.skel.add(this.buildEndTag(node));
        }
        tu.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        this.frag = null;
        if (popStack && this.isContextTranslatable()) {
            this.frag = new TextFragment();
        }
        this.skel = new GenericSkeleton();
        return true;
    }
}

