/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.net.URI;
import net.sf.okapi.common.Util;
import net.sf.okapi.lib.verification.IssueType;

public class Issue {
    public static final int SEVERITY_LOW = 0;
    public static final int SEVERITY_MEDIUM = 1;
    public static final int SEVERITY_HIGH = 2;
    public URI docURI;
    public IssueType issueType;
    public String tuId;
    public String segId;
    public String message;
    public int srcStart;
    public int srcEnd;
    public int trgStart;
    public int trgEnd;
    public boolean enabled;
    public int severity;
    public Object extra;
    public String tuName;
    public String oriSource;
    public String oriTarget;
    public long tuKey;
    public long docKey;

    public Issue(URI docId, IssueType issueType, String tuId, String segId, String message, int srcStart, int srcEnd, int trgStart, int trgEnd, int severity, String tuName) {
        this.docURI = docId;
        this.issueType = issueType;
        this.tuId = tuId;
        this.segId = segId;
        this.message = message;
        this.srcStart = srcStart;
        this.srcEnd = srcEnd;
        this.trgStart = trgStart;
        this.trgEnd = trgEnd;
        this.severity = severity;
        this.tuName = tuName;
    }

    String getSignature() {
        return String.format("%s-%s-%s-%d-%s", new Object[]{this.docURI, this.tuId, this.segId == null ? "" : this.segId, this.srcStart, this.issueType});
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("<its:qaItem");
        tmp.append(" docUri=\"" + Util.escapeToXML(this.docURI.getPath(), 3, false, null) + "\"");
        tmp.append(" tuId=\"" + Util.escapeToXML(this.tuId, 3, false, null) + "\"");
        tmp.append(" segId=\"" + Util.escapeToXML(this.segId, 3, false, null) + "\"");
        tmp.append(" tuName=\"" + (this.tuName != null ? Util.escapeToXML(this.tuName, 3, false, null) : "") + "\"");
        tmp.append(String.format(" srcStart=\"%d\" srcEnd=\"%d\"", this.srcStart, this.srcEnd));
        tmp.append(String.format(" trgStart=\"%d\" trgEnd=\"%d\"", this.trgStart, this.trgEnd));
        tmp.append(String.format(" severity=\"%d\"", this.severity));
        tmp.append("><its:qaNote>" + Util.escapeToXML(this.message, 0, false, null) + "<its:qaNote>");
        tmp.append("</its:qaItem>");
        return tmp.toString();
    }
}

