/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.lib.xliff.DataStore;
import net.sf.okapi.lib.xliff.EventData;
import net.sf.okapi.lib.xliff.ExtendedElements;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.SectionData;
import net.sf.okapi.lib.xliff.Segment;
import org.oasisopen.xliff.v2.Directionality;
import org.oasisopen.xliff.v2.ICandidate;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IExtendedElements;
import org.oasisopen.xliff.v2.IFragment;
import org.oasisopen.xliff.v2.IGlossEntry;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IPart;
import org.oasisopen.xliff.v2.ISegment;
import org.oasisopen.xliff.v2.IUnit;

public class Unit
extends EventData
implements IUnit {
    private static final long serialVersionUID = 64L;
    private ArrayList<IPart> parts;
    private DataStore store;
    private ArrayList<ICandidate> candidates;
    private List<IGlossEntry> glossEntries;
    private ArrayList<INote> notes;
    private IExtendedElements xelems;
    private LinkedHashMap<String, String> custProps;

    public Unit(String id) {
        this.setId(id);
        this.parts = new ArrayList();
        this.store = new DataStore();
    }

    public Unit(String id, SectionData fileData) {
        this(id);
        if (fileData != null) {
            this.setSourceDir(fileData.getSourceDir());
            this.setTargetDir(fileData.getTargetDir());
        }
    }

    @Override
    public Iterator<IPart> iterator() {
        return new Iterator<IPart>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public IPart next() {
                return (IPart)Unit.this.parts.get(++this.current - 1);
            }

            @Override
            public boolean hasNext() {
                return !Unit.this.parts.isEmpty() && this.current < Unit.this.parts.size();
            }
        };
    }

    @Override
    public int getPartCount() {
        return this.parts.size();
    }

    @Override
    public ISegment appendNewSegment() {
        Segment seg = new Segment(this.store);
        this.parts.add(seg);
        return seg;
    }

    @Override
    public IPart appendNewIgnorable() {
        Part part = new Part(this.store);
        this.parts.add(part);
        return part;
    }

    @Override
    public IPart getPart(int partIndex) {
        return this.parts.get(partIndex);
    }

    @Override
    public IDataStore getDataStore() {
        return this.store;
    }

    @Override
    public void addCandidate(ICandidate candidate) {
        if (this.candidates == null) {
            this.candidates = new ArrayList();
        }
        this.candidates.add(candidate);
    }

    @Override
    public List<ICandidate> getCandidates() {
        if (this.candidates == null) {
            return Collections.emptyList();
        }
        return this.candidates;
    }

    @Override
    public int getCandidateCount() {
        if (this.candidates == null) {
            return 0;
        }
        return this.candidates.size();
    }

    @Override
    public void addNote(INote note) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(note);
    }

    @Override
    public List<INote> getNotes() {
        if (this.notes == null) {
            return Collections.emptyList();
        }
        return this.notes;
    }

    @Override
    public int getNoteCount() {
        if (this.notes == null) {
            return 0;
        }
        return this.notes.size();
    }

    @Override
    public void split(int partIndex, int srcStart, int srcEnd, int trgStart, int trgEnd) {
        Segment seg;
        IPart part = this.getPart(partIndex);
        IFragment src = part.getSource();
        String ctext = src.getCodedText();
        if (srcEnd == -1) {
            srcEnd = ctext.length() - 1;
        }
        if (srcStart > srcEnd) {
            throw new RuntimeException("Bad range.");
        }
        if (ctext.length() < srcEnd) {
            throw new RuntimeException("Range out of bounds.");
        }
        if (srcStart >= ctext.length() || Fragment.isMarker(ctext.codePointAt(srcStart + 1))) {
            // empty if block
        }
        String left = "";
        left = ctext.substring(0, srcStart);
        String mid = "";
        mid = ctext.substring(srcStart, srcEnd);
        String right = "";
        right = ctext.substring(srcEnd);
        if (!right.isEmpty()) {
            seg = new Segment(this.store);
            seg.getSource().setCodedText(right);
            this.parts.add(partIndex + 1, seg);
        }
        if (!left.isEmpty()) {
            seg = new Segment(this.store);
            seg.getSource().setCodedText(left);
            this.parts.add(partIndex, seg);
        }
        if (mid.isEmpty()) {
            this.parts.remove(part);
        } else if (mid.length() != ctext.length()) {
            part.getSource().setCodedText(mid);
        }
    }

    @Override
    public void join(int startPartIndex, int endPartIndex, boolean adjustTargetIgnorable) {
        if (startPartIndex < 0 || startPartIndex >= this.getPartCount()) {
            throw new RuntimeException("Invalid startPartIndex value.");
        }
        if (endPartIndex == -1) {
            endPartIndex = this.getPartCount() - 1;
        }
        if (endPartIndex == startPartIndex) {
            return;
        }
        if (endPartIndex <= startPartIndex || endPartIndex >= this.getPartCount()) {
            throw new RuntimeException("Invalid endPartIndex value.");
        }
        IPart startPart = this.getPart(startPartIndex);
        Fragment startSource = (Fragment)startPart.getSource();
        Fragment startTarget = null;
        if (startPart.hasTarget()) {
            startTarget = (Fragment)startPart.getTarget(false);
        }
        boolean approved = false;
        if (startPart.isSegment()) {
            approved = ((ISegment)startPart).getApproved();
        }
        int i = startPartIndex + 1;
        do {
            IPart part = this.parts.get(i);
            Fragment frag = (Fragment)part.getSource();
            startSource.append(frag);
            if (part.hasTarget()) {
                frag = (Fragment)part.getTarget(false);
                if (startTarget != null) {
                    startTarget.append(frag);
                } else {
                    startPart.setTarget(frag);
                }
            } else if (!part.isSegment() && adjustTargetIgnorable) {
                if (startTarget != null) {
                    startTarget.append(frag);
                } else {
                    startPart.setTarget(frag);
                }
            }
            if (!startPart.isSegment() || ((ISegment)startPart).getApproved()) continue;
            approved = false;
        } while (++i <= endPartIndex);
        if (startPart.isSegment()) {
            ((ISegment)startPart).setApproved(approved);
        }
        i = startPartIndex + 1;
        do {
            this.parts.remove(startPartIndex + 1);
        } while (++i <= endPartIndex);
        int removedCount = endPartIndex - startPartIndex;
        int srcOrder = 1;
        for (IPart part : this.parts) {
            int order = part.getTargetOrder();
            if (order > startPartIndex + 1) {
                part.setTargetOrder(order - removedCount == srcOrder ? 0 : order - removedCount);
            }
            ++srcOrder;
        }
    }

    @Override
    public IExtendedElements getExtendedElements() {
        if (this.xelems == null) {
            this.xelems = new ExtendedElements(null);
        }
        return this.xelems;
    }

    @Override
    public boolean hasExtendedElements() {
        if (this.xelems == null) {
            return false;
        }
        return this.xelems.size() > 0;
    }

    @Override
    public IExtendedElements setExtendedElements(IExtendedElements elements) {
        this.xelems = elements;
        return this.getExtendedElements();
    }

    @Override
    public boolean hasCustomProperties() {
        if (this.custProps == null) {
            return false;
        }
        return !this.custProps.isEmpty();
    }

    @Override
    public LinkedHashMap<String, String> getCustomProperties() {
        if (this.custProps == null) {
            this.custProps = new LinkedHashMap();
        }
        return this.custProps;
    }

    @Override
    public LinkedHashMap<String, String> setCustomProperties(LinkedHashMap<String, String> properties) {
        if (properties == null) {
            properties = new LinkedHashMap();
        }
        this.custProps = properties;
        return this.custProps;
    }

    @Override
    public boolean hasGlossary() {
        if (this.glossEntries == null) {
            return false;
        }
        return this.glossEntries.size() > 0;
    }

    @Override
    public List<IGlossEntry> getGlossaryEntries() {
        if (this.glossEntries == null) {
            this.glossEntries = new ArrayList<IGlossEntry>();
        }
        return this.glossEntries;
    }

    @Override
    public List<IGlossEntry> setGlossaryEntries(List<IGlossEntry> entries) {
        if (entries == null) {
            entries = new ArrayList<IGlossEntry>();
        }
        this.glossEntries = entries;
        return this.glossEntries;
    }

    @Override
    public Directionality getSourceDir(boolean resolved) {
        return this.store.getSourceDir();
    }

    @Override
    public void setSourceDir(Directionality dir) {
        this.store.setSourceDir(dir);
    }

    @Override
    public Directionality getTargetDir(boolean resolved) {
        return this.store.getTargetDir();
    }

    @Override
    public void setTargetDir(Directionality dir) {
        this.store.setTargetDir(dir);
    }
}

