/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xmlvalidation;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xmlvalidation.DTDResolver;
import net.sf.okapi.steps.xmlvalidation.Parameters;
import net.sf.okapi.steps.xmlvalidation.ValidatingErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@UsingParameters(value=Parameters.class)
public class XMLValidationStep
extends BasePipelineStep {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private XMLInputFactory xmlInputFact;
    private String currentFileDir;
    private Parameters params = new Parameters();

    @Override
    public void destroy() {
        this.xmlInputFact = null;
    }

    @Override
    public String getDescription() {
        return "Validate XML documents. Expects: raw XML document. Sends back: raw XML document.";
    }

    @Override
    public String getName() {
        return "XML Validation";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.xmlInputFact = XMLInputFactory.newInstance();
        if (this.params.isValidate()) {
            this.logger.info("Validating using XML Schema: " + this.params.getSchemaPath());
        }
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        block16: {
            RawDocument rawDoc = (RawDocument)event.getResource();
            this.currentFileDir = Util.getDirectoryName(rawDoc.getInputURI().getPath());
            StreamSource xmlInput = null;
            xmlInput = rawDoc.getInputURI() == null ? new StreamSource(rawDoc.getStream()) : new StreamSource(rawDoc.getStream(), rawDoc.getInputURI().getPath());
            try {
                XMLStreamReader reader = this.xmlInputFact.createXMLStreamReader(xmlInput);
                while (reader.hasNext()) {
                    reader.next();
                }
                reader.close();
            }
            catch (XMLStreamException e) {
                this.logger.severe("Well-Formedness Error Line: " + e.getLocation().getLineNumber() + ", Column: " + e.getLocation().getColumnNumber() + ", Offset: " + e.getLocation().getCharacterOffset() + "\n" + e.getMessage());
                return event;
            }
            if (this.params.isValidate()) {
                xmlInput = new StreamSource(rawDoc.getStream());
                try {
                    SchemaFactory factory = null;
                    if (this.params.getValidationType() == 0) {
                        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                        saxFactory.setNamespaceAware(true);
                        saxFactory.setValidating(true);
                        SAXParser parser = saxFactory.newSAXParser();
                        XMLReader reader = parser.getXMLReader();
                        reader.setErrorHandler(new ValidatingErrorHandler(this.logger));
                        reader.setEntityResolver(new DTDResolver(this.currentFileDir));
                        reader.parse(new InputSource(rawDoc.getStream()));
                        break block16;
                    }
                    if (this.params.getValidationType() == 1) {
                        factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    } else if (this.params.getValidationType() == 2) {
                        System.setProperty(SchemaFactory.class.getName() + ":" + "http://relaxng.org/ns/structure/1.0", "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory");
                        factory = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
                        if (this.params.getSchemaPath().length() <= 0) {
                            throw new OkapiBadStepInputException("Please specify a valid RelaxNG schema path");
                        }
                    }
                    URL schemaLocation = null;
                    if (this.params.getSchemaPath().length() > 0) {
                        try {
                            schemaLocation = new URL(this.params.getSchemaPath());
                        }
                        catch (MalformedURLException e) {
                            schemaLocation = new File(this.params.getSchemaPath()).toURI().toURL();
                        }
                    }
                    Schema schema = schemaLocation == null ? factory.newSchema() : factory.newSchema(schemaLocation);
                    Validator validator = schema.newValidator();
                    validator.setErrorHandler(new ValidatingErrorHandler(this.logger));
                    validator.validate(xmlInput);
                }
                catch (SAXException e) {
                    this.logger.severe(e.getMessage());
                    return event;
                }
                catch (IOException e) {
                    this.logger.severe(e.getMessage());
                    return event;
                }
                catch (ParserConfigurationException e) {
                    this.logger.severe(e.getMessage());
                    return event;
                }
            }
        }
        return event;
    }
}

