/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.its.ITSEngine;
import org.w3c.its.ITraversal;

public class Main {
    public static void main(String[] args) {
        try {
            Node node;
            System.out.println("ITSTest");
            File inputFile = args.length > 0 ? new File(args[0]) : new File("input.xml");
            System.out.println("   input: " + inputFile.getAbsolutePath());
            File outputFile = args.length > 1 ? new File(args[1]) : new File("output.xml");
            System.out.println("  output: " + outputFile.getAbsolutePath());
            File rulesFile = null;
            if (args.length > 2) {
                rulesFile = new File(args[2]);
            }
            System.out.print("   rules: ");
            if (rulesFile == null) {
                System.out.print("No external rules file will be used.");
            } else {
                System.out.println(rulesFile.getAbsolutePath());
            }
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            fact.setValidating(false);
            Document doc = fact.newDocumentBuilder().parse(inputFile);
            ITraversal trav = Main.applyITSRules(doc, inputFile, rulesFile);
            trav.startTraversal();
            while ((node = trav.nextNode()) != null) {
                switch (node.getNodeType()) {
                    case 1: {
                        if (trav.backTracking()) break;
                        Element element = (Element)node;
                        if (trav.translate() && Main.hasTextChild(node)) {
                            element.appendChild(doc.createTextNode(" + TRANSLATION"));
                        }
                        if (trav.isTerm() && Main.hasTextChild(node)) {
                            element.appendChild(doc.createTextNode(" + TERM!"));
                        }
                        if (element.hasAttributes()) {
                            NamedNodeMap map = element.getAttributes();
                            for (int i = 0; i < map.getLength(); ++i) {
                                Attr attr = (Attr)map.item(i);
                                if (trav.translate(attr)) {
                                    attr.setValue(attr.getValue() + " + TRANSLATION");
                                }
                                if (!trav.isTerm(attr)) continue;
                                attr.setValue(attr.getValue() + " + TERM!");
                            }
                        }
                        element.appendChild(doc.createTextNode(" + lang=" + trav.getLanguage()));
                        element.appendChild(doc.createTextNode(" + idValue=" + trav.getIdValue()));
                        element.appendChild(doc.createTextNode(" + ws=" + (trav.preserveWS() ? "preserve" : "default")));
                    }
                }
            }
            Main.saveDocument(doc, outputFile);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static ITraversal applyITSRules(Document doc, File inputFile, File rulesFile) {
        ITSEngine itsEng = new ITSEngine(doc, inputFile.toURI());
        if (rulesFile != null) {
            itsEng.addExternalRules(rulesFile.toURI());
        }
        itsEng.applyRules(65535);
        return itsEng;
    }

    private static boolean hasTextChild(Node element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 3) continue;
            return true;
        }
        return false;
    }

    private static void saveDocument(Document doc, File outputFile) throws TransformerFactoryConfigurationError, TransformerException, FileNotFoundException {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        FileOutputStream output = new FileOutputStream(outputFile);
        trans.transform(new DOMSource(doc), new StreamResult(output));
    }
}

