/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;

public class LCIDUtil {
    private static List<LCIDDescr> descriptors = new ArrayList<LCIDDescr>();
    private static HashMap<Integer, LCIDDescr> tagLookup = new HashMap();
    private static HashMap<String, LCIDDescr> lcidLookup = new HashMap();
    private static LCIDUtil inst;

    private static void registerLCID(String language, String region, int lcid) {
        LCIDDescr descr0 = tagLookup.get(lcid);
        if (descr0 != null) {
            String st;
            String lang0 = descr0.language;
            String reg0 = descr0.region;
            String string = st = Util.isEmpty(reg0) ? lang0 : String.format("%s (%s)", lang0, reg0);
            if (language.equals(lang0) && region.equals(reg0)) {
                Logger.getLogger(LCIDUtil.class.getName()).warning(String.format("Already registered LCID: (0x%04x) %s", lcid, st));
            }
        }
        if (inst == null) {
            inst = new LCIDUtil();
        }
        LCIDUtil lCIDUtil = inst;
        lCIDUtil.getClass();
        LCIDDescr descr = lCIDUtil.new LCIDDescr(language, region, lcid, null);
        descriptors.add(descr);
        tagLookup.put(lcid, descr);
    }

    private static void registerTag(int lcid, String tag) {
        LCIDDescr descr = tagLookup.get(lcid);
        if (descr == null) {
            Logger.getLogger(LCIDUtil.class.getName()).warning(String.format("Unregistered LCID: 0x%04x %s\n", lcid, tag));
            return;
        }
        descr.tag = tag = new LocaleId(tag).toString();
        lcidLookup.put(tag, descr);
    }

    public static List<LCIDDescr> getDescriptors() {
        return descriptors;
    }

    public static String getTag(int lcid) {
        LCIDDescr descr = tagLookup.get(lcid);
        return descr != null ? descr.tag : "";
    }

    public static int getLCID(String tag) {
        return LCIDUtil.getLCID(new LocaleId(tag));
    }

    public static String getTag(LocaleId locId) {
        LCIDDescr descr = lcidLookup.get(locId.toString());
        return descr != null ? descr.tag : "";
    }

    public static int getLCID(LocaleId locId) {
        LCIDDescr descr = lcidLookup.get(locId.toString());
        return descr != null ? descr.lcid : 0;
    }

    public static String getLCID_asString(LocaleId locId) {
        return Util.intToStr(LCIDUtil.getLCID(locId));
    }

    public static LocaleId getLocaleId(String tag) {
        return new LocaleId(tag);
    }

    public static LocaleId getLocaleId(int lcid) {
        return new LocaleId(LCIDUtil.getTag(lcid));
    }

    public static HashMap<Integer, LCIDDescr> getTagLookup() {
        return tagLookup;
    }

    public static HashMap<String, LCIDDescr> getLcidLookup() {
        return lcidLookup;
    }

    static {
        LCIDUtil.registerLCID("Afrikaans", "South Africa", 1078);
        LCIDUtil.registerLCID("Albanian", "Albania", 1052);
        LCIDUtil.registerLCID("Alsatian", "France", 1156);
        LCIDUtil.registerLCID("Amharic", "Ethiopia", 1118);
        LCIDUtil.registerLCID("Arabic", "Saudi Arabia", 1025);
        LCIDUtil.registerLCID("Arabic", "Iraq", 2049);
        LCIDUtil.registerLCID("Arabic", "Egypt", 3073);
        LCIDUtil.registerLCID("Arabic", "Libya", 4097);
        LCIDUtil.registerLCID("Arabic", "Algeria", 5121);
        LCIDUtil.registerLCID("Arabic", "Morocco", 6145);
        LCIDUtil.registerLCID("Arabic", "Tunisia", 7169);
        LCIDUtil.registerLCID("Arabic", "Oman", 8193);
        LCIDUtil.registerLCID("Arabic", "Yemen", 9217);
        LCIDUtil.registerLCID("Arabic", "Syria", 10241);
        LCIDUtil.registerLCID("Arabic", "Jordan", 11265);
        LCIDUtil.registerLCID("Arabic", "Lebanon", 12289);
        LCIDUtil.registerLCID("Arabic", "Kuwait", 13313);
        LCIDUtil.registerLCID("Arabic", "U.A.E.", 14337);
        LCIDUtil.registerLCID("Arabic", "Kingdom of Bahrain", 15361);
        LCIDUtil.registerLCID("Arabic", "Qatar", 16385);
        LCIDUtil.registerLCID("Armenian", "Armenia", 1067);
        LCIDUtil.registerLCID("Assamese", "India", 1101);
        LCIDUtil.registerLCID("Azeri (Cyrillic)", "Azerbaijan", 2092);
        LCIDUtil.registerLCID("Azeri (Latin)", "Azerbaijan", 1068);
        LCIDUtil.registerLCID("Bashkir", "Russia", 1133);
        LCIDUtil.registerLCID("Basque", "Spain", 1069);
        LCIDUtil.registerLCID("Belarusian", "Belarus", 1059);
        LCIDUtil.registerLCID("Bengali", "India", 1093);
        LCIDUtil.registerLCID("Bengali", "Bangladesh", 2117);
        LCIDUtil.registerLCID("Bosnian (Cyrillic)", "Bosnia and Herzegovina", 8218);
        LCIDUtil.registerLCID("Bosnian (Latin)", "Bosnia and Herzegovina", 5146);
        LCIDUtil.registerLCID("Breton", "France", 1150);
        LCIDUtil.registerLCID("Bulgarian", "Bulgaria", 1026);
        LCIDUtil.registerLCID("Catalan", "(Catalan)", 1027);
        LCIDUtil.registerLCID("Chinese", "Simplified", 4);
        LCIDUtil.registerLCID("Chinese", "Taiwan", 1028);
        LCIDUtil.registerLCID("Chinese", "People's Republic of China", 2052);
        LCIDUtil.registerLCID("Chinese", "Hong Kong SAR", 3076);
        LCIDUtil.registerLCID("Chinese", "Singapore", 4100);
        LCIDUtil.registerLCID("Chinese", "Macao SAR", 5124);
        LCIDUtil.registerLCID("Chinese", "Traditional", 31748);
        LCIDUtil.registerLCID("Corsican", "France", 1155);
        LCIDUtil.registerLCID("Croatian", "Croatia", 1050);
        LCIDUtil.registerLCID("Croatian (Latin)", "Bosnia and Herzegovina", 4122);
        LCIDUtil.registerLCID("Czech", "Czech Republic", 1029);
        LCIDUtil.registerLCID("Danish", "Denmark", 1030);
        LCIDUtil.registerLCID("Dari", "Afghanistan", 1164);
        LCIDUtil.registerLCID("Divehi", "Maldives", 1125);
        LCIDUtil.registerLCID("Dutch", "Belgium", 2067);
        LCIDUtil.registerLCID("Dutch", "Netherlands", 1043);
        LCIDUtil.registerLCID("English", "Canada", 4105);
        LCIDUtil.registerLCID("English", "Jamaica", 8201);
        LCIDUtil.registerLCID("English", "Caribbean", 9225);
        LCIDUtil.registerLCID("English", "Belize", 10249);
        LCIDUtil.registerLCID("English", "Trinidad", 11273);
        LCIDUtil.registerLCID("English", "United Kingdom", 2057);
        LCIDUtil.registerLCID("English", "Ireland", 6153);
        LCIDUtil.registerLCID("English", "India", 16393);
        LCIDUtil.registerLCID("English", "South Africa", 7177);
        LCIDUtil.registerLCID("English", "Zimbabwe", 12297);
        LCIDUtil.registerLCID("English", "Australia", 3081);
        LCIDUtil.registerLCID("English", "New Zealand", 5129);
        LCIDUtil.registerLCID("English", "Philippines", 13321);
        LCIDUtil.registerLCID("English", "United States", 1033);
        LCIDUtil.registerLCID("English", "Malaysia", 17417);
        LCIDUtil.registerLCID("English", "Singapore", 18441);
        LCIDUtil.registerLCID("Estonian", "Estonia", 1061);
        LCIDUtil.registerLCID("Faroese", "Faroe Islands", 1080);
        LCIDUtil.registerLCID("Filipino", "Philippines", 1124);
        LCIDUtil.registerLCID("Finnish", "Finland", 1035);
        LCIDUtil.registerLCID("French", "Canada", 3084);
        LCIDUtil.registerLCID("French", "France", 1036);
        LCIDUtil.registerLCID("French", "Monaco", 6156);
        LCIDUtil.registerLCID("French", "Switzerland", 4108);
        LCIDUtil.registerLCID("French", "Belgium", 2060);
        LCIDUtil.registerLCID("French", "Luxembourg", 5132);
        LCIDUtil.registerLCID("Frisian", "Netherlands", 1122);
        LCIDUtil.registerLCID("Galician", "Galician", 1110);
        LCIDUtil.registerLCID("Georgian", "Georgia", 1079);
        LCIDUtil.registerLCID("German", "Germany", 1031);
        LCIDUtil.registerLCID("German", "Switzerland", 2055);
        LCIDUtil.registerLCID("German", "Austria", 3079);
        LCIDUtil.registerLCID("German", "Liechtenstein", 5127);
        LCIDUtil.registerLCID("German", "Luxembourg", 4103);
        LCIDUtil.registerLCID("Greek", "Greece", 1032);
        LCIDUtil.registerLCID("Greenlandic", "Greenland", 1135);
        LCIDUtil.registerLCID("Gujarati", "India", 1095);
        LCIDUtil.registerLCID("Hausa", "Nigeria", 1128);
        LCIDUtil.registerLCID("Hebrew", "Israel", 1037);
        LCIDUtil.registerLCID("Hindi", "India", 1081);
        LCIDUtil.registerLCID("Hungarian", "Hungary", 1038);
        LCIDUtil.registerLCID("Icelandic", "Iceland", 1039);
        LCIDUtil.registerLCID("Igbo", "Nigeria", 1136);
        LCIDUtil.registerLCID("Indonesian", "Indonesia", 1057);
        LCIDUtil.registerLCID("Inuktitut (Syllabics)", "Canada", 1117);
        LCIDUtil.registerLCID("Inuktitut (Latin)", "Canada", 2141);
        LCIDUtil.registerLCID("Irish", "Ireland", 2108);
        LCIDUtil.registerLCID("isiXhosa", "South Africa", 1076);
        LCIDUtil.registerLCID("isiZulu", "South Africa", 1077);
        LCIDUtil.registerLCID("Italian", "Italy", 1040);
        LCIDUtil.registerLCID("Italian", "Switzerland", 2064);
        LCIDUtil.registerLCID("Japanese", "Japan", 1041);
        LCIDUtil.registerLCID("Kannada", "India", 1099);
        LCIDUtil.registerLCID("Kazakh", "Kazakhstan", 1087);
        LCIDUtil.registerLCID("Khmer", "Cambodia", 1107);
        LCIDUtil.registerLCID("K'iche", "Guatemala", 1158);
        LCIDUtil.registerLCID("Kinyarwanda", "Rwanda", 1159);
        LCIDUtil.registerLCID("Kiswahili", "Kenya", 1089);
        LCIDUtil.registerLCID("Konkani", "India", 1111);
        LCIDUtil.registerLCID("Korean", "Korea", 1042);
        LCIDUtil.registerLCID("Kyrgyz", "Kyrgyzstan", 1088);
        LCIDUtil.registerLCID("Lao", "Lao PDR", 1108);
        LCIDUtil.registerLCID("Latvian", "Latvia", 1062);
        LCIDUtil.registerLCID("Lithuanian", "Lithuania", 1063);
        LCIDUtil.registerLCID("Lower Sorbian", "Germany", 2094);
        LCIDUtil.registerLCID("Luxembourgish", "Luxembourg", 1134);
        LCIDUtil.registerLCID("Macedonian (FYROM)", "Macedonia, Former Yugoslav Republic of", 1071);
        LCIDUtil.registerLCID("Malay", "Malaysia", 1086);
        LCIDUtil.registerLCID("Malay", "Brunei Darussalam", 2110);
        LCIDUtil.registerLCID("Malayalam", "India", 1100);
        LCIDUtil.registerLCID("Maltese", "Malta", 1082);
        LCIDUtil.registerLCID("Maori", "New Zealand", 1153);
        LCIDUtil.registerLCID("Mapudungun ", "Chile", 1146);
        LCIDUtil.registerLCID("Marathi", "India", 1102);
        LCIDUtil.registerLCID("Mohawk", "Mohawk", 1148);
        LCIDUtil.registerLCID("Mongolian (Cyrillic)", "Mongolia", 1104);
        LCIDUtil.registerLCID("Mongolian (Mongolian)", "People's Republic of China", 2128);
        LCIDUtil.registerLCID("Nepali", "Nepal", 1121);
        LCIDUtil.registerLCID("Norwegian (Bokmal)", "Norway", 1044);
        LCIDUtil.registerLCID("Norwegian (Nynorsk)", "Norway", 2068);
        LCIDUtil.registerLCID("Occitan", "France", 1154);
        LCIDUtil.registerLCID("Oriya", "India", 1096);
        LCIDUtil.registerLCID("Pashto", "Afghanistan", 1123);
        LCIDUtil.registerLCID("Persian", "Iran", 1065);
        LCIDUtil.registerLCID("Polish", "Poland", 1045);
        LCIDUtil.registerLCID("Portuguese", "Brazil", 1046);
        LCIDUtil.registerLCID("Portuguese", "Portugal", 2070);
        LCIDUtil.registerLCID("Punjabi (Gurmukhi)", "India", 1094);
        LCIDUtil.registerLCID("Quechua", "Bolivia", 1131);
        LCIDUtil.registerLCID("Quechua", "Ecuador", 2155);
        LCIDUtil.registerLCID("Quechua", "Peru", 3179);
        LCIDUtil.registerLCID("Romanian", "Romania", 1048);
        LCIDUtil.registerLCID("Romansh", "Switzerland", 1047);
        LCIDUtil.registerLCID("Russian", "Russia", 1049);
        LCIDUtil.registerLCID("Sakha", "Russia", 1157);
        LCIDUtil.registerLCID("Sami, Inari", "Finland", 9275);
        LCIDUtil.registerLCID("Sami, Lule", "Sweden", 5179);
        LCIDUtil.registerLCID("Sami, Lule", "Norway", 4155);
        LCIDUtil.registerLCID("Sami, Northern", "Norway", 1083);
        LCIDUtil.registerLCID("Sami, Northern", "Sweden", 2107);
        LCIDUtil.registerLCID("Sami, Northern", "Finland", 3131);
        LCIDUtil.registerLCID("Sami, Skolt", "Finland", 8251);
        LCIDUtil.registerLCID("Sami, Southern", "Norway", 6203);
        LCIDUtil.registerLCID("Sami, Southern", "Sweden", 7227);
        LCIDUtil.registerLCID("Sanskrit", "India", 1103);
        LCIDUtil.registerLCID("Scottish Gaelic", "United Kingdom", 1169);
        LCIDUtil.registerLCID("Serbian (Cyrillic) sr-Cyrl-CS", "Serbia and Montenegro (Former)", 3098);
        LCIDUtil.registerLCID("Serbian (Cyrillic) sr-Cyrl-RS", "Serbia", 10266);
        LCIDUtil.registerLCID("Serbian(Cyrillic) sr-Cyrl-ME", "Montenegro", 12314);
        LCIDUtil.registerLCID("Serbian (Cyrillic)", "Bosnia and Herzegovina", 7194);
        LCIDUtil.registerLCID("Serbian (Latin) sr-Latn-RS", "Serbia", 9242);
        LCIDUtil.registerLCID("Serbian (Latin) Sr-Latn-ME", "Montenegro", 11290);
        LCIDUtil.registerLCID("Serbian (Latin)", "Montenegro", 2074);
        LCIDUtil.registerLCID("Serbian (Latin)", "Bosnia and Herzegovina", 6170);
        LCIDUtil.registerLCID("Sesotho sa Leboa", "South Africa", 1132);
        LCIDUtil.registerLCID("Setswana", "South Africa", 1074);
        LCIDUtil.registerLCID("Sinhala", "Sri Lanka", 1115);
        LCIDUtil.registerLCID("Slovak", "Slovakia", 1051);
        LCIDUtil.registerLCID("Slovenian", "Slovenia", 1060);
        LCIDUtil.registerLCID("Spanish", "Mexico", 2058);
        LCIDUtil.registerLCID("Spanish", "Guatemala", 4106);
        LCIDUtil.registerLCID("Spanish", "Costa Rica", 5130);
        LCIDUtil.registerLCID("Spanish", "Panama", 6154);
        LCIDUtil.registerLCID("Spanish", "Dominican Republic", 7178);
        LCIDUtil.registerLCID("Spanish", "Venezuela", 8202);
        LCIDUtil.registerLCID("Spanish", "Colombia", 9226);
        LCIDUtil.registerLCID("Spanish", "Peru", 10250);
        LCIDUtil.registerLCID("Spanish", "Argentina", 11274);
        LCIDUtil.registerLCID("Spanish", "Ecuador", 12298);
        LCIDUtil.registerLCID("Spanish", "Chile", 13322);
        LCIDUtil.registerLCID("Spanish", "Paraguay", 15370);
        LCIDUtil.registerLCID("Spanish", "Bolivia", 16394);
        LCIDUtil.registerLCID("Spanish", "El Salvador", 17418);
        LCIDUtil.registerLCID("Spanish", "Honduras", 18442);
        LCIDUtil.registerLCID("Spanish", "Nicaragua", 19466);
        LCIDUtil.registerLCID("Spanish", "Commonwealth of Puerto Rico", 20490);
        LCIDUtil.registerLCID("Spanish", "United States", 21514);
        LCIDUtil.registerLCID("Spanish", "Uruguay", 14346);
        LCIDUtil.registerLCID("Spanish (International Sort)", "Spain", 3082);
        LCIDUtil.registerLCID("Spanish (Traditional Sort)", "Spain", 1034);
        LCIDUtil.registerLCID("Sutu", "South Africa", 1072);
        LCIDUtil.registerLCID("Swedish", "Sweden", 1053);
        LCIDUtil.registerLCID("Swedish", "Finland", 2077);
        LCIDUtil.registerLCID("Syriac", "Syria", 1114);
        LCIDUtil.registerLCID("Tajik", "Tajikistan", 1064);
        LCIDUtil.registerLCID("Tamazight (Latin)", "Algeria", 2143);
        LCIDUtil.registerLCID("Tamil", "India", 1097);
        LCIDUtil.registerLCID("Tatar", "Russia", 1092);
        LCIDUtil.registerLCID("Telugu", "India", 1098);
        LCIDUtil.registerLCID("Thai", "Thailand", 1054);
        LCIDUtil.registerLCID("Tibetan", "People's Republic of China", 1105);
        LCIDUtil.registerLCID("Turkish", "Turkey", 1055);
        LCIDUtil.registerLCID("Turkmen", "Turkmenistan", 1090);
        LCIDUtil.registerLCID("Uighur", "People's Republic of China", 1152);
        LCIDUtil.registerLCID("Ukrainian", "Ukraine", 1058);
        LCIDUtil.registerLCID("Upper Sorbian", "Germany", 1070);
        LCIDUtil.registerLCID("Urdu", "Pakistan", 1056);
        LCIDUtil.registerLCID("Uzbek (Cyrillic)", "Uzbekistan", 2115);
        LCIDUtil.registerLCID("Uzbek (Latin)", "Uzbekistan", 1091);
        LCIDUtil.registerLCID("Vietnamese", "Vietnam", 1066);
        LCIDUtil.registerLCID("Welsh", "United Kingdom", 1106);
        LCIDUtil.registerLCID("Wolof", "Senegal", 1160);
        LCIDUtil.registerLCID("Yi", "People's Republic of China", 1144);
        LCIDUtil.registerLCID("Yoruba", "Nigeria", 1130);
        LCIDUtil.registerLCID("Arabic", "", 1);
        LCIDUtil.registerLCID("Bulgarian", "", 2);
        LCIDUtil.registerLCID("Catalan", "", 3);
        LCIDUtil.registerLCID("Czech", "", 5);
        LCIDUtil.registerLCID("Danish", "", 6);
        LCIDUtil.registerLCID("German", "", 7);
        LCIDUtil.registerLCID("Greek", "", 8);
        LCIDUtil.registerLCID("English", "", 9);
        LCIDUtil.registerLCID("Spanish", "", 10);
        LCIDUtil.registerLCID("Finnish", "", 11);
        LCIDUtil.registerLCID("French", "", 12);
        LCIDUtil.registerLCID("Hebrew", "", 13);
        LCIDUtil.registerLCID("Hungarian", "", 14);
        LCIDUtil.registerLCID("Icelandic", "", 15);
        LCIDUtil.registerLCID("Italian", "", 16);
        LCIDUtil.registerLCID("Japanese", "", 17);
        LCIDUtil.registerLCID("Korean", "", 18);
        LCIDUtil.registerLCID("Dutch", "", 19);
        LCIDUtil.registerLCID("", "", 20);
        LCIDUtil.registerLCID("Polish", "", 21);
        LCIDUtil.registerLCID("Portuguese", "", 22);
        LCIDUtil.registerLCID("", "", 23);
        LCIDUtil.registerLCID("Romanian", "", 24);
        LCIDUtil.registerLCID("Russian", "", 25);
        LCIDUtil.registerLCID("Croatian", "", 26);
        LCIDUtil.registerLCID("Slovak", "", 27);
        LCIDUtil.registerLCID("Albanian", "", 28);
        LCIDUtil.registerLCID("Swedish", "", 29);
        LCIDUtil.registerLCID("Thai", "", 30);
        LCIDUtil.registerLCID("Turkish", "", 31);
        LCIDUtil.registerLCID("Urdu", "", 32);
        LCIDUtil.registerLCID("Indonesian", "", 33);
        LCIDUtil.registerLCID("Ukrainian", "", 34);
        LCIDUtil.registerLCID("Belarusian", "", 35);
        LCIDUtil.registerLCID("Slovenian", "", 36);
        LCIDUtil.registerLCID("Estonian", "", 37);
        LCIDUtil.registerLCID("Latvian", "", 38);
        LCIDUtil.registerLCID("Lithuanian", "", 39);
        LCIDUtil.registerLCID("Persian", "", 41);
        LCIDUtil.registerLCID("Vietnamese", "", 42);
        LCIDUtil.registerLCID("Armenian", "", 43);
        LCIDUtil.registerLCID("Azerbaijani", "", 44);
        LCIDUtil.registerLCID("Basque", "", 45);
        LCIDUtil.registerLCID("Macedonian", "", 47);
        LCIDUtil.registerLCID("Afrikaans", "", 54);
        LCIDUtil.registerLCID("Georgian", "", 55);
        LCIDUtil.registerLCID("Faroese", "", 56);
        LCIDUtil.registerLCID("Hindi", "", 57);
        LCIDUtil.registerLCID("Maltese", "", 58);
        LCIDUtil.registerLCID("Irish", "", 60);
        LCIDUtil.registerLCID("Malay", "", 62);
        LCIDUtil.registerLCID("Kazakh", "", 63);
        LCIDUtil.registerLCID("Swahili", "", 65);
        LCIDUtil.registerLCID("Uzbek", "", 67);
        LCIDUtil.registerLCID("Bengali", "", 69);
        LCIDUtil.registerLCID("Punjabi", "", 70);
        LCIDUtil.registerLCID("Gujarati", "", 71);
        LCIDUtil.registerLCID("Oriya", "", 72);
        LCIDUtil.registerLCID("Tamil", "", 73);
        LCIDUtil.registerLCID("Telugu", "", 74);
        LCIDUtil.registerLCID("Kannada", "", 75);
        LCIDUtil.registerLCID("Malayalam", "", 76);
        LCIDUtil.registerLCID("Assamese", "", 77);
        LCIDUtil.registerLCID("Marathi", "", 78);
        LCIDUtil.registerLCID("Welsh", "", 82);
        LCIDUtil.registerLCID("Khmer", "", 83);
        LCIDUtil.registerLCID("Galician", "", 86);
        LCIDUtil.registerLCID("Konkani", "", 87);
        LCIDUtil.registerLCID("Sinhala", "", 91);
        LCIDUtil.registerLCID("Amharic", "", 94);
        LCIDUtil.registerLCID("Nepali", "", 97);
        LCIDUtil.registerLCID("Pashto", "", 99);
        LCIDUtil.registerLCID("Hausa", "", 104);
        LCIDUtil.registerLCID("Kalaallisut", "", 111);
        LCIDUtil.registerLCID("Sichuan yi", "", 120);
        LCIDUtil.registerLCID("Tigrinya", "", 1139);
        LCIDUtil.registerLCID("Hawaiian", "", 1141);
        LCIDUtil.registerLCID("Somali", "", 1143);
        LCIDUtil.registerLCID("Urdu", "", 2080);
        LCIDUtil.registerLCID("Nepali", "", 2145);
        LCIDUtil.registerLCID("Tigrinya", "", 2163);
        LCIDUtil.registerLCID("French", "SN", 10252);
        LCIDUtil.registerLCID("English", "HK", 15369);
        LCIDUtil.registerLCID("Serbian", "Cyrillic", 27674);
        LCIDUtil.registerLCID("Serbian", "Latin", 28698);
        LCIDUtil.registerLCID("Azerbaijani", "Cyrillic", 29740);
        LCIDUtil.registerLCID("Chinese", "", 30724);
        LCIDUtil.registerLCID("Norwegian", "nynorsk", 30740);
        LCIDUtil.registerLCID("Azerbaijani", "Latin", 30764);
        LCIDUtil.registerLCID("Uzbek", "Cyrillic", 30787);
        LCIDUtil.registerLCID("Norwegian", "bokmol", 31764);
        LCIDUtil.registerLCID("Serbian", "", 31770);
        LCIDUtil.registerLCID("Uzbek", "Latin", 31811);
        LCIDUtil.registerLCID("Hausa", "Latin", 31848);
        LCIDUtil.registerLCID("Tajik", "", 40);
        LCIDUtil.registerLCID("Sorbian", "", 46);
        LCIDUtil.registerLCID("Setswana", "", 50);
        LCIDUtil.registerLCID("isiXhosa", "", 52);
        LCIDUtil.registerLCID("isiZulu", "", 53);
        LCIDUtil.registerLCID("Sami", "", 59);
        LCIDUtil.registerLCID("Kyrgyz", "", 64);
        LCIDUtil.registerLCID("Turkmen", "", 66);
        LCIDUtil.registerLCID("Tatar", "", 68);
        LCIDUtil.registerLCID("Sanskrit", "", 79);
        LCIDUtil.registerLCID("Mongolian", "", 80);
        LCIDUtil.registerLCID("Tibetan", "", 81);
        LCIDUtil.registerLCID("Lao", "", 84);
        LCIDUtil.registerLCID("Syriac", "", 90);
        LCIDUtil.registerLCID("Inuktitut", "", 93);
        LCIDUtil.registerLCID("Tamazight", "", 95);
        LCIDUtil.registerLCID("Frisian", "", 98);
        LCIDUtil.registerLCID("Filipino", "", 100);
        LCIDUtil.registerLCID("Divehi", "", 101);
        LCIDUtil.registerLCID("Yoruba", "", 106);
        LCIDUtil.registerLCID("Quechua", "", 107);
        LCIDUtil.registerLCID("Northern Sotho", "", 108);
        LCIDUtil.registerLCID("Bashkir", "", 109);
        LCIDUtil.registerLCID("Luxembourgish", "", 110);
        LCIDUtil.registerLCID("Igbo", "", 112);
        LCIDUtil.registerLCID("Mapudungun", "", 122);
        LCIDUtil.registerLCID("Mohawk", "", 124);
        LCIDUtil.registerLCID("Breton", "", 126);
        LCIDUtil.registerLCID("Uighur", "", 128);
        LCIDUtil.registerLCID("Maori", "", 129);
        LCIDUtil.registerLCID("Occitan", "", 130);
        LCIDUtil.registerLCID("Corsican", "", 131);
        LCIDUtil.registerLCID("Alsatian", "", 132);
        LCIDUtil.registerLCID("Yakut", "", 133);
        LCIDUtil.registerLCID("K'iche", "", 134);
        LCIDUtil.registerLCID("Kinyarwanda", "", 135);
        LCIDUtil.registerLCID("Wolof", "", 136);
        LCIDUtil.registerLCID("Dari", "", 140);
        LCIDUtil.registerLCID("Gaelic", "", 145);
        LCIDUtil.registerLCID("Tsonga", "", 1073);
        LCIDUtil.registerLCID("Venda", "South Africa", 1075);
        LCIDUtil.registerLCID("Burmese", "Myanmar", 1109);
        LCIDUtil.registerLCID("Manipuri", "India", 1112);
        LCIDUtil.registerLCID("Sindhi", "India", 1113);
        LCIDUtil.registerLCID("Cherokee", "United States", 1116);
        LCIDUtil.registerLCID("Tamazight", "Morocco", 1119);
        LCIDUtil.registerLCID("Edo", "Nigeria", 1126);
        LCIDUtil.registerLCID("Fulfulde", "Nigeria", 1127);
        LCIDUtil.registerLCID("Ibibio", "Nigeria", 1129);
        LCIDUtil.registerLCID("Kanuri", "Nigeria", 1137);
        LCIDUtil.registerLCID("West Central Oromo", "Ethiopia", 1138);
        LCIDUtil.registerLCID("Guarani", "Paraguay", 1140);
        LCIDUtil.registerLCID("Papiamento", "Netherlands Antilles", 1145);
        LCIDUtil.registerLCID("Plateau Malagasy", "Madagascar", 1165);
        LCIDUtil.registerLCID("Romanian", "Macao", 2072);
        LCIDUtil.registerLCID("Russian", "Macao", 2073);
        LCIDUtil.registerLCID("Panjabi", "Pakistan", 2118);
        LCIDUtil.registerLCID("Tibetan", "Bhutan", 2129);
        LCIDUtil.registerLCID("Sindhi", "Pakistan", 2137);
        LCIDUtil.registerLCID("Tamanaku", "Morocco", 3167);
        LCIDUtil.registerLCID("French", "", 7180);
        LCIDUtil.registerLCID("French", "Reunion", 8204);
        LCIDUtil.registerLCID("French", "Congo", 9228);
        LCIDUtil.registerLCID("French", "Cameroon", 11276);
        LCIDUtil.registerLCID("French", "Cote d'Ivoire", 12300);
        LCIDUtil.registerLCID("French", "Mali", 13324);
        LCIDUtil.registerLCID("English", "Indonesia", 14345);
        LCIDUtil.registerLCID("French", "Morocco", 14348);
        LCIDUtil.registerLCID("French", "Haiti", 15372);
        LCIDUtil.registerLCID("Bosnian", "Cyrillic", 25626);
        LCIDUtil.registerLCID("Bosnian", "Latin", 26650);
        LCIDUtil.registerLCID("Inari Sami", "", 28731);
        LCIDUtil.registerLCID("Skolt Sami", "", 29755);
        LCIDUtil.registerLCID("Bosnian", "", 30746);
        LCIDUtil.registerLCID("Southern Sami", "", 30779);
        LCIDUtil.registerLCID("Mongolian", "Cyrillic", 30800);
        LCIDUtil.registerLCID("Inuktitut", "Unified Canadian Aboriginal Syllabics", 30813);
        LCIDUtil.registerLCID("Tajik", "Cyrillic", 31784);
        LCIDUtil.registerLCID("Lower Sorbian", "", 31790);
        LCIDUtil.registerLCID("Lule Sami", "", 31803);
        LCIDUtil.registerLCID("Mongolian", "Mongolia", 31824);
        LCIDUtil.registerLCID("Inuktitut", "Latin", 31837);
        LCIDUtil.registerLCID("Central Atlas Tamazight", "Latin", 31839);
        LCIDUtil.registerLCID("Greek 2", "Greece", 8200);
        LCIDUtil.registerLCID("Lithuanian", "Lithuania", 2087);
        LCIDUtil.registerLCID("Sutu", "", 48);
        LCIDUtil.registerLCID("Gaelic", "Scotland", 1084);
        LCIDUtil.registerLCID("Sindhi", "", 89);
        LCIDUtil.registerLCID("Somali", "", 119);
        LCIDUtil.registerTag(1, "ar");
        LCIDUtil.registerTag(2, "bg");
        LCIDUtil.registerTag(3, "ca");
        LCIDUtil.registerTag(4, "zh");
        LCIDUtil.registerTag(5, "cs");
        LCIDUtil.registerTag(6, "da");
        LCIDUtil.registerTag(7, "de");
        LCIDUtil.registerTag(8, "el");
        LCIDUtil.registerTag(9, "en");
        LCIDUtil.registerTag(10, "es");
        LCIDUtil.registerTag(11, "fi");
        LCIDUtil.registerTag(12, "fr");
        LCIDUtil.registerTag(13, "he");
        LCIDUtil.registerTag(14, "hu");
        LCIDUtil.registerTag(15, "is");
        LCIDUtil.registerTag(16, "it");
        LCIDUtil.registerTag(17, "ja");
        LCIDUtil.registerTag(18, "ko");
        LCIDUtil.registerTag(19, "nl");
        LCIDUtil.registerTag(20, "nb");
        LCIDUtil.registerTag(21, "pl");
        LCIDUtil.registerTag(22, "pt");
        LCIDUtil.registerTag(23, "rm");
        LCIDUtil.registerTag(24, "ro");
        LCIDUtil.registerTag(25, "ru");
        LCIDUtil.registerTag(26, "hr");
        LCIDUtil.registerTag(27, "sk");
        LCIDUtil.registerTag(28, "sq");
        LCIDUtil.registerTag(29, "sv");
        LCIDUtil.registerTag(30, "th");
        LCIDUtil.registerTag(31, "tr");
        LCIDUtil.registerTag(32, "ur");
        LCIDUtil.registerTag(33, "id");
        LCIDUtil.registerTag(34, "uk");
        LCIDUtil.registerTag(35, "be");
        LCIDUtil.registerTag(36, "sl");
        LCIDUtil.registerTag(37, "et");
        LCIDUtil.registerTag(38, "lv");
        LCIDUtil.registerTag(39, "lt");
        LCIDUtil.registerTag(40, "tg");
        LCIDUtil.registerTag(41, "fa");
        LCIDUtil.registerTag(42, "vi");
        LCIDUtil.registerTag(43, "hy");
        LCIDUtil.registerTag(44, "az");
        LCIDUtil.registerTag(45, "eu");
        LCIDUtil.registerTag(46, "hsb");
        LCIDUtil.registerTag(47, "mk");
        LCIDUtil.registerTag(50, "tn");
        LCIDUtil.registerTag(52, "xh");
        LCIDUtil.registerTag(53, "zu");
        LCIDUtil.registerTag(54, "af");
        LCIDUtil.registerTag(55, "ka");
        LCIDUtil.registerTag(56, "fo");
        LCIDUtil.registerTag(57, "hi");
        LCIDUtil.registerTag(58, "mt");
        LCIDUtil.registerTag(59, "se");
        LCIDUtil.registerTag(60, "ga");
        LCIDUtil.registerTag(62, "ms");
        LCIDUtil.registerTag(63, "kk");
        LCIDUtil.registerTag(64, "ky");
        LCIDUtil.registerTag(65, "sw");
        LCIDUtil.registerTag(66, "tk");
        LCIDUtil.registerTag(67, "uz");
        LCIDUtil.registerTag(68, "tt");
        LCIDUtil.registerTag(69, "bn");
        LCIDUtil.registerTag(70, "pa");
        LCIDUtil.registerTag(71, "gu");
        LCIDUtil.registerTag(72, "or");
        LCIDUtil.registerTag(73, "ta");
        LCIDUtil.registerTag(74, "te");
        LCIDUtil.registerTag(75, "kn");
        LCIDUtil.registerTag(76, "ml");
        LCIDUtil.registerTag(77, "as");
        LCIDUtil.registerTag(78, "mr");
        LCIDUtil.registerTag(79, "sa");
        LCIDUtil.registerTag(80, "mn");
        LCIDUtil.registerTag(81, "bo");
        LCIDUtil.registerTag(82, "cy");
        LCIDUtil.registerTag(83, "km");
        LCIDUtil.registerTag(84, "lo");
        LCIDUtil.registerTag(86, "gl");
        LCIDUtil.registerTag(87, "kok");
        LCIDUtil.registerTag(90, "syr");
        LCIDUtil.registerTag(91, "si");
        LCIDUtil.registerTag(93, "iu");
        LCIDUtil.registerTag(94, "am");
        LCIDUtil.registerTag(95, "tzm");
        LCIDUtil.registerTag(97, "ne");
        LCIDUtil.registerTag(98, "fy");
        LCIDUtil.registerTag(99, "ps");
        LCIDUtil.registerTag(100, "fil");
        LCIDUtil.registerTag(101, "dv");
        LCIDUtil.registerTag(104, "ha");
        LCIDUtil.registerTag(106, "yo");
        LCIDUtil.registerTag(107, "quz");
        LCIDUtil.registerTag(108, "nso");
        LCIDUtil.registerTag(109, "ba");
        LCIDUtil.registerTag(110, "lb");
        LCIDUtil.registerTag(111, "kl");
        LCIDUtil.registerTag(112, "ig");
        LCIDUtil.registerTag(120, "ii");
        LCIDUtil.registerTag(122, "arn");
        LCIDUtil.registerTag(124, "moh");
        LCIDUtil.registerTag(126, "br");
        LCIDUtil.registerTag(128, "ug");
        LCIDUtil.registerTag(129, "mi");
        LCIDUtil.registerTag(130, "oc");
        LCIDUtil.registerTag(131, "co");
        LCIDUtil.registerTag(132, "gsw");
        LCIDUtil.registerTag(133, "sah");
        LCIDUtil.registerTag(134, "qut");
        LCIDUtil.registerTag(135, "rw");
        LCIDUtil.registerTag(136, "wo");
        LCIDUtil.registerTag(140, "prs");
        LCIDUtil.registerTag(145, "gd");
        LCIDUtil.registerTag(1025, "ar-SA");
        LCIDUtil.registerTag(1026, "bg-BG");
        LCIDUtil.registerTag(1027, "ca-ES");
        LCIDUtil.registerTag(1028, "zh-TW");
        LCIDUtil.registerTag(31748, "zh-Hant");
        LCIDUtil.registerTag(1029, "cs-CZ");
        LCIDUtil.registerTag(1030, "da-DK");
        LCIDUtil.registerTag(1031, "de-DE");
        LCIDUtil.registerTag(1032, "el-GR");
        LCIDUtil.registerTag(1033, "en-US");
        LCIDUtil.registerTag(1034, "es-ES_tradnl");
        LCIDUtil.registerTag(1035, "fi-FI");
        LCIDUtil.registerTag(1036, "fr-FR");
        LCIDUtil.registerTag(1037, "he-IL");
        LCIDUtil.registerTag(1038, "hu-HU");
        LCIDUtil.registerTag(1039, "is-IS");
        LCIDUtil.registerTag(1040, "it-IT");
        LCIDUtil.registerTag(1041, "ja-JP");
        LCIDUtil.registerTag(1042, "ko-KR");
        LCIDUtil.registerTag(1043, "nl-NL");
        LCIDUtil.registerTag(1044, "nb-NO");
        LCIDUtil.registerTag(1045, "pl-PL");
        LCIDUtil.registerTag(1046, "pt-BR");
        LCIDUtil.registerTag(1047, "rm-CH");
        LCIDUtil.registerTag(1048, "ro-RO");
        LCIDUtil.registerTag(1049, "ru-RU");
        LCIDUtil.registerTag(1050, "hr-HR");
        LCIDUtil.registerTag(1051, "sk-SK");
        LCIDUtil.registerTag(1052, "sq-AL");
        LCIDUtil.registerTag(1053, "sv-SE");
        LCIDUtil.registerTag(1054, "th-TH");
        LCIDUtil.registerTag(1055, "tr-TR");
        LCIDUtil.registerTag(1056, "ur-PK");
        LCIDUtil.registerTag(1057, "id-ID");
        LCIDUtil.registerTag(1058, "uk-UA");
        LCIDUtil.registerTag(1059, "be-BY");
        LCIDUtil.registerTag(1060, "sl-SI");
        LCIDUtil.registerTag(1061, "et-EE");
        LCIDUtil.registerTag(1062, "lv-LV");
        LCIDUtil.registerTag(1063, "lt-LT");
        LCIDUtil.registerTag(1064, "tg-Cyrl-TJ");
        LCIDUtil.registerTag(1065, "fa-IR");
        LCIDUtil.registerTag(1066, "vi-VN");
        LCIDUtil.registerTag(1067, "hy-AM");
        LCIDUtil.registerTag(1068, "az-Latn-AZ");
        LCIDUtil.registerTag(1069, "eu-ES");
        LCIDUtil.registerTag(1070, "wen-DE");
        LCIDUtil.registerTag(1071, "mk-MK");
        LCIDUtil.registerTag(1072, "st-ZA");
        LCIDUtil.registerTag(1073, "ts-ZA");
        LCIDUtil.registerTag(1074, "tn-ZA");
        LCIDUtil.registerTag(1075, "ven-ZA");
        LCIDUtil.registerTag(1076, "xh-ZA");
        LCIDUtil.registerTag(1077, "zu-ZA");
        LCIDUtil.registerTag(1078, "af-ZA");
        LCIDUtil.registerTag(1079, "ka-GE");
        LCIDUtil.registerTag(1080, "fo-FO");
        LCIDUtil.registerTag(1081, "hi-IN");
        LCIDUtil.registerTag(1082, "mt-MT");
        LCIDUtil.registerTag(1083, "se-NO");
        LCIDUtil.registerTag(1086, "ms-MY");
        LCIDUtil.registerTag(1087, "kk-KZ");
        LCIDUtil.registerTag(1088, "ky-KG");
        LCIDUtil.registerTag(1089, "sw-KE");
        LCIDUtil.registerTag(1090, "tk-TM");
        LCIDUtil.registerTag(1091, "uz-Latn-UZ");
        LCIDUtil.registerTag(1092, "tt-RU");
        LCIDUtil.registerTag(1093, "bn-IN");
        LCIDUtil.registerTag(1094, "pa-IN");
        LCIDUtil.registerTag(1095, "gu-IN");
        LCIDUtil.registerTag(1096, "or-IN");
        LCIDUtil.registerTag(1097, "ta-IN");
        LCIDUtil.registerTag(1098, "te-IN");
        LCIDUtil.registerTag(1099, "kn-IN");
        LCIDUtil.registerTag(1100, "ml-IN");
        LCIDUtil.registerTag(1101, "as-IN");
        LCIDUtil.registerTag(1102, "mr-IN");
        LCIDUtil.registerTag(1103, "sa-IN");
        LCIDUtil.registerTag(1104, "mn-MN");
        LCIDUtil.registerTag(1105, "bo-CN");
        LCIDUtil.registerTag(1106, "cy-GB");
        LCIDUtil.registerTag(1107, "km-KH");
        LCIDUtil.registerTag(1108, "lo-LA");
        LCIDUtil.registerTag(1109, "my-MM");
        LCIDUtil.registerTag(1110, "gl-ES");
        LCIDUtil.registerTag(1111, "kok-IN");
        LCIDUtil.registerTag(1112, "mni");
        LCIDUtil.registerTag(1113, "sd-IN");
        LCIDUtil.registerTag(1114, "syr-SY");
        LCIDUtil.registerTag(1115, "si-LK");
        LCIDUtil.registerTag(1116, "chr-US");
        LCIDUtil.registerTag(1117, "iu-Cans-CA");
        LCIDUtil.registerTag(1118, "am-ET");
        LCIDUtil.registerTag(1119, "tmz");
        LCIDUtil.registerTag(1121, "ne-NP");
        LCIDUtil.registerTag(1122, "fy-NL");
        LCIDUtil.registerTag(1123, "ps-AF");
        LCIDUtil.registerTag(1124, "fil-PH");
        LCIDUtil.registerTag(1125, "dv-MV");
        LCIDUtil.registerTag(1126, "bin-NG");
        LCIDUtil.registerTag(1127, "fuv-NG");
        LCIDUtil.registerTag(1128, "ha-Latn-NG");
        LCIDUtil.registerTag(1129, "ibb-NG");
        LCIDUtil.registerTag(1130, "yo-NG");
        LCIDUtil.registerTag(1131, "quz-BO");
        LCIDUtil.registerTag(1132, "nso-ZA");
        LCIDUtil.registerTag(1133, "ba-RU");
        LCIDUtil.registerTag(1134, "lb-LU");
        LCIDUtil.registerTag(1135, "kl-GL");
        LCIDUtil.registerTag(1136, "ig-NG");
        LCIDUtil.registerTag(1137, "kr-NG");
        LCIDUtil.registerTag(1138, "gaz-ET");
        LCIDUtil.registerTag(1139, "ti-ER");
        LCIDUtil.registerTag(1140, "gn-PY");
        LCIDUtil.registerTag(1141, "haw-US");
        LCIDUtil.registerTag(1143, "so-SO");
        LCIDUtil.registerTag(1144, "ii-CN");
        LCIDUtil.registerTag(1145, "pap-AN");
        LCIDUtil.registerTag(1146, "arn-CL");
        LCIDUtil.registerTag(1148, "moh-CA");
        LCIDUtil.registerTag(1150, "br-FR");
        LCIDUtil.registerTag(1152, "ug-CN");
        LCIDUtil.registerTag(1153, "mi-NZ");
        LCIDUtil.registerTag(1154, "oc-FR");
        LCIDUtil.registerTag(1155, "co-FR");
        LCIDUtil.registerTag(1156, "gsw-FR");
        LCIDUtil.registerTag(1157, "sah-RU");
        LCIDUtil.registerTag(1158, "qut-GT");
        LCIDUtil.registerTag(1159, "rw-RW");
        LCIDUtil.registerTag(1160, "wo-SN");
        LCIDUtil.registerTag(1164, "prs-AF");
        LCIDUtil.registerTag(1165, "plt-MG");
        LCIDUtil.registerTag(1169, "gd-GB");
        LCIDUtil.registerTag(2049, "ar-IQ");
        LCIDUtil.registerTag(2052, "zh-CN");
        LCIDUtil.registerTag(2055, "de-CH");
        LCIDUtil.registerTag(2057, "en-GB");
        LCIDUtil.registerTag(2058, "es-MX");
        LCIDUtil.registerTag(2060, "fr-BE");
        LCIDUtil.registerTag(2064, "it-CH");
        LCIDUtil.registerTag(2067, "nl-BE");
        LCIDUtil.registerTag(2068, "nn-NO");
        LCIDUtil.registerTag(2070, "pt-PT");
        LCIDUtil.registerTag(2072, "ro-MO");
        LCIDUtil.registerTag(2073, "ru-MO");
        LCIDUtil.registerTag(2074, "sr-Latn-CS");
        LCIDUtil.registerTag(2077, "sv-FI");
        LCIDUtil.registerTag(2080, "ur-IN");
        LCIDUtil.registerTag(2092, "az-Cyrl-AZ");
        LCIDUtil.registerTag(2094, "dsb-DE");
        LCIDUtil.registerTag(2107, "se-SE");
        LCIDUtil.registerTag(2108, "ga-IE");
        LCIDUtil.registerTag(2110, "ms-BN");
        LCIDUtil.registerTag(2115, "uz-Cyrl-UZ");
        LCIDUtil.registerTag(2117, "bn-BD");
        LCIDUtil.registerTag(2118, "pa-PK");
        LCIDUtil.registerTag(2128, "mn-Mong-CN");
        LCIDUtil.registerTag(2129, "bo-BT");
        LCIDUtil.registerTag(2137, "sd-PK");
        LCIDUtil.registerTag(2141, "iu-Latn-CA");
        LCIDUtil.registerTag(2143, "tzm-Latn-DZ");
        LCIDUtil.registerTag(2145, "ne-IN");
        LCIDUtil.registerTag(2155, "quz-EC");
        LCIDUtil.registerTag(2163, "ti-ET");
        LCIDUtil.registerTag(3073, "ar-EG");
        LCIDUtil.registerTag(3076, "zh-HK");
        LCIDUtil.registerTag(3079, "de-AT");
        LCIDUtil.registerTag(3081, "en-AU");
        LCIDUtil.registerTag(3082, "es-ES");
        LCIDUtil.registerTag(3084, "fr-CA");
        LCIDUtil.registerTag(3098, "sr-Cyrl-CS");
        LCIDUtil.registerTag(3131, "se-FI");
        LCIDUtil.registerTag(3167, "tmz-MA");
        LCIDUtil.registerTag(3179, "quz-PE");
        LCIDUtil.registerTag(4097, "ar-LY");
        LCIDUtil.registerTag(4100, "zh-SG");
        LCIDUtil.registerTag(4103, "de-LU");
        LCIDUtil.registerTag(4105, "en-CA");
        LCIDUtil.registerTag(4106, "es-GT");
        LCIDUtil.registerTag(4108, "fr-CH");
        LCIDUtil.registerTag(4122, "hr-BA");
        LCIDUtil.registerTag(4155, "smj-NO");
        LCIDUtil.registerTag(5121, "ar-DZ");
        LCIDUtil.registerTag(5124, "zh-MO");
        LCIDUtil.registerTag(5127, "de-LI");
        LCIDUtil.registerTag(5129, "en-NZ");
        LCIDUtil.registerTag(5130, "es-CR");
        LCIDUtil.registerTag(5132, "fr-LU");
        LCIDUtil.registerTag(5146, "bs-Latn-BA");
        LCIDUtil.registerTag(5179, "smj-SE");
        LCIDUtil.registerTag(6145, "ar-MA");
        LCIDUtil.registerTag(6153, "en-IE");
        LCIDUtil.registerTag(6154, "es-PA");
        LCIDUtil.registerTag(6156, "fr-MC");
        LCIDUtil.registerTag(6170, "sr-Latn-BA");
        LCIDUtil.registerTag(6203, "sma-NO");
        LCIDUtil.registerTag(7169, "ar-TN");
        LCIDUtil.registerTag(7177, "en-ZA");
        LCIDUtil.registerTag(7178, "es-DO");
        LCIDUtil.registerTag(7180, "fr-West-Indies");
        LCIDUtil.registerTag(7194, "sr-Cyrl-BA");
        LCIDUtil.registerTag(7227, "sma-SE");
        LCIDUtil.registerTag(8193, "ar-OM");
        LCIDUtil.registerTag(8201, "en-JM");
        LCIDUtil.registerTag(8202, "es-VE");
        LCIDUtil.registerTag(8204, "fr-RE");
        LCIDUtil.registerTag(8218, "bs-Cyrl-BA");
        LCIDUtil.registerTag(8251, "sms-FI");
        LCIDUtil.registerTag(9217, "ar-YE");
        LCIDUtil.registerTag(9225, "en-CB");
        LCIDUtil.registerTag(9226, "es-CO");
        LCIDUtil.registerTag(9228, "fr-CG");
        LCIDUtil.registerTag(9242, "sr-Latn-RS");
        LCIDUtil.registerTag(9275, "smn-FI");
        LCIDUtil.registerTag(10241, "ar-SY");
        LCIDUtil.registerTag(10249, "en-BZ");
        LCIDUtil.registerTag(10250, "es-PE");
        LCIDUtil.registerTag(10252, "fr-SN");
        LCIDUtil.registerTag(10266, "sr-Cyrl-RS");
        LCIDUtil.registerTag(11265, "ar-JO");
        LCIDUtil.registerTag(11273, "en-TT");
        LCIDUtil.registerTag(11274, "es-AR");
        LCIDUtil.registerTag(11276, "fr-CM");
        LCIDUtil.registerTag(11290, "sr-Latn-ME");
        LCIDUtil.registerTag(12289, "ar-LB");
        LCIDUtil.registerTag(12297, "en-ZW");
        LCIDUtil.registerTag(12298, "es-EC");
        LCIDUtil.registerTag(12300, "fr-CI");
        LCIDUtil.registerTag(12314, "sr-Cyrl-ME");
        LCIDUtil.registerTag(13313, "ar-KW");
        LCIDUtil.registerTag(13321, "en-PH");
        LCIDUtil.registerTag(13322, "es-CL");
        LCIDUtil.registerTag(13324, "fr-ML");
        LCIDUtil.registerTag(14337, "ar-AE");
        LCIDUtil.registerTag(14345, "en-ID");
        LCIDUtil.registerTag(14346, "es-UY");
        LCIDUtil.registerTag(14348, "fr-MA");
        LCIDUtil.registerTag(15361, "ar-BH");
        LCIDUtil.registerTag(15369, "en-HK");
        LCIDUtil.registerTag(15370, "es-PY");
        LCIDUtil.registerTag(15372, "fr-HT");
        LCIDUtil.registerTag(16385, "ar-QA");
        LCIDUtil.registerTag(16393, "en-IN");
        LCIDUtil.registerTag(16394, "es-BO");
        LCIDUtil.registerTag(17417, "en-MY");
        LCIDUtil.registerTag(17418, "es-SV");
        LCIDUtil.registerTag(18441, "en-SG");
        LCIDUtil.registerTag(18442, "es-HN");
        LCIDUtil.registerTag(19466, "es-NI");
        LCIDUtil.registerTag(20490, "es-PR");
        LCIDUtil.registerTag(21514, "es-US");
        LCIDUtil.registerTag(25626, "bs-Cyrl");
        LCIDUtil.registerTag(26650, "bs-Latn");
        LCIDUtil.registerTag(27674, "sr-Cyrl");
        LCIDUtil.registerTag(28698, "sr-Latn");
        LCIDUtil.registerTag(28731, "smn");
        LCIDUtil.registerTag(29740, "az-Cyrl");
        LCIDUtil.registerTag(29755, "sms");
        LCIDUtil.registerTag(30724, "zh");
        LCIDUtil.registerTag(30740, "nn");
        LCIDUtil.registerTag(30746, "bs");
        LCIDUtil.registerTag(30764, "az-Latn");
        LCIDUtil.registerTag(30779, "sma");
        LCIDUtil.registerTag(30787, "uz-Cyrl");
        LCIDUtil.registerTag(30800, "mn-Cyrl");
        LCIDUtil.registerTag(30813, "iu-Cans");
        LCIDUtil.registerTag(31764, "nb");
        LCIDUtil.registerTag(31770, "sr");
        LCIDUtil.registerTag(31784, "tg-Cyrl");
        LCIDUtil.registerTag(31790, "dsb");
        LCIDUtil.registerTag(31803, "smj");
        LCIDUtil.registerTag(31811, "uz-Latn");
        LCIDUtil.registerTag(31824, "mn-Mong");
        LCIDUtil.registerTag(31837, "iu-Latn");
        LCIDUtil.registerTag(31839, "tzm-Latn");
        LCIDUtil.registerTag(31848, "ha-Latn");
        LCIDUtil.registerTag(8200, "el-GR");
        LCIDUtil.registerTag(2087, "lt-LT");
        LCIDUtil.registerTag(48, "st");
        LCIDUtil.registerTag(1084, "gd");
        LCIDUtil.registerTag(89, "sd");
        LCIDUtil.registerTag(119, "so");
    }

    class LCIDDescr {
        String language;
        String region;
        int lcid;
        String tag;

        public LCIDDescr(String language, String region, int lcid, String tag) {
            this.language = language;
            this.region = region;
            this.lcid = lcid;
            this.tag = tag;
        }
    }
}

