/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.IEncoder;

public class XMLEncoder
implements IEncoder {
    public static final String ESCAPEGT = "escapeGT";
    public static final String ESCAPENBSP = "escapeNbsp";
    public static final String ESCAPELINEBREAK = "escapeLineBreak";
    public static final String QUOTEMODEDEFINED = "quoteModeDefined";
    public static final String QUOTEMODE = "quoteMode";
    private CharsetEncoder chsEnc;
    private String lineBreak;
    private boolean escapeGT = false;
    private boolean escapeNbsp = false;
    private boolean escapeLineBreak = false;
    private int quoteMode = 1;

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.lineBreak = lineBreak;
        this.chsEnc = "utf-8".equalsIgnoreCase(encoding) || "utf-16".equalsIgnoreCase(encoding) ? null : Charset.forName(encoding).newEncoder();
        if (params != null) {
            this.escapeGT = params.getBoolean(ESCAPEGT);
            this.escapeNbsp = params.getBoolean(ESCAPENBSP);
            this.escapeLineBreak = params.getBoolean(ESCAPELINEBREAK);
            if (params.getBoolean(QUOTEMODEDEFINED)) {
                this.quoteMode = params.getInteger(QUOTEMODE);
            }
        }
    }

    @Override
    public String encode(String text, int context) {
        if (text == null) {
            return "";
        }
        StringBuffer sbTmp = new StringBuffer(text.length());
        block14: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sbTmp.append("&lt;");
                    continue block14;
                }
                case '>': {
                    if (this.escapeGT) {
                        sbTmp.append("&gt;");
                        continue block14;
                    }
                    if (i > 0 && text.charAt(i - 1) == ']') {
                        sbTmp.append("&gt;");
                        continue block14;
                    }
                    sbTmp.append('>');
                    continue block14;
                }
                case '&': {
                    sbTmp.append("&amp;");
                    continue block14;
                }
                case '\"': {
                    if (this.quoteMode > 0) {
                        sbTmp.append("&quot;");
                        continue block14;
                    }
                    sbTmp.append('\"');
                    continue block14;
                }
                case '\'': {
                    switch (this.quoteMode) {
                        case 1: {
                            sbTmp.append("&apos;");
                            continue block14;
                        }
                        case 2: {
                            sbTmp.append("&#39;");
                            continue block14;
                        }
                    }
                    sbTmp.append(ch);
                    continue block14;
                }
                case '\r': {
                    sbTmp.append("&#13;");
                    continue block14;
                }
                case '\n': {
                    if (this.escapeLineBreak) {
                        sbTmp.append("&#10;");
                        continue block14;
                    }
                    sbTmp.append(this.lineBreak);
                    continue block14;
                }
                case '\u00a0': {
                    if (this.escapeNbsp) {
                        sbTmp.append("&#x00a0;");
                        continue block14;
                    }
                }
                default: {
                    if (ch > '\u007f') {
                        if (Character.isHighSurrogate(ch)) {
                            int cp = text.codePointAt(i++);
                            String tmp = new String(Character.toChars(cp));
                            if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                                sbTmp.append(String.format("&#x%x;", cp));
                                continue block14;
                            }
                            sbTmp.append(tmp);
                            continue block14;
                        }
                        if (this.chsEnc != null && !this.chsEnc.canEncode(ch)) {
                            sbTmp.append(String.format("&#x%04x;", ch));
                            continue block14;
                        }
                        sbTmp.append(String.valueOf(ch));
                        continue block14;
                    }
                    sbTmp.append(ch);
                }
            }
        }
        return sbTmp.toString();
    }

    @Override
    public String encode(char value, int context) {
        switch (value) {
            case '<': {
                return "&lt;";
            }
            case '\"': {
                if (this.quoteMode > 0) {
                    return "&quot;";
                }
                return "\"";
            }
            case '\'': {
                switch (this.quoteMode) {
                    case 1: {
                        return "&apos;";
                    }
                    case 2: {
                        return "&#39;";
                    }
                }
                return "'";
            }
            case '&': {
                return "&amp;";
            }
            case '>': {
                if (this.escapeGT) {
                    return "&gt;";
                }
                return ">";
            }
            case '\r': {
                return "&#13;";
            }
            case '\n': {
                if (this.escapeLineBreak) {
                    return "&#10;";
                }
                return this.lineBreak;
            }
            case '\u00a0': {
                if (!this.escapeNbsp) break;
                return "&#x00a0;";
            }
        }
        if (value > '\u007f') {
            if (this.chsEnc != null && !this.chsEnc.canEncode(value)) {
                return String.format("&#x%04x;", value);
            }
            return String.valueOf(value);
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, int context) {
        switch (value) {
            case 60: {
                return "&lt;";
            }
            case 34: {
                if (this.quoteMode > 0) {
                    return "&quot;";
                }
                return "\"";
            }
            case 39: {
                switch (this.quoteMode) {
                    case 1: {
                        return "&apos;";
                    }
                    case 2: {
                        return "&#39;";
                    }
                }
                return "'";
            }
            case 38: {
                return "&amp;";
            }
            case 62: {
                if (this.escapeGT) {
                    return "&gt;";
                }
                return ">";
            }
            case 13: {
                return "&#13;";
            }
            case 10: {
                if (this.escapeLineBreak) {
                    return "&#10;";
                }
                return this.lineBreak;
            }
            case 160: {
                if (!this.escapeNbsp) break;
                return "&#x00a0;";
            }
        }
        if (value > 127) {
            if (Character.isSupplementaryCodePoint(value)) {
                String tmp = new String(Character.toChars(value));
                if (this.chsEnc != null && !this.chsEnc.canEncode(tmp)) {
                    return String.format("&#x%x;", value);
                }
                return tmp;
            }
            if (this.chsEnc != null && !this.chsEnc.canEncode((char)value)) {
                return String.format("&#x%04x;", value);
            }
            return String.valueOf((char)value);
        }
        return String.valueOf((char)value);
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }
}

