/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.DummyFilter;
import net.sf.okapi.common.filterwriter.TMXFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TMXFilterWriterTest {
    private DummyFilter filter;
    private LocaleId locEN = LocaleId.fromString("en");
    private LocaleId locFR = LocaleId.fromString("fr");

    @Before
    public void setUp() {
        this.filter = new DummyFilter();
    }

    @Test
    public void testSimpleOutput() {
        String result = this.rewrite(this.getEvents("##def##", this.locEN, this.locFR), this.locFR);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><tmx version=\"1.4\"><header creationtool=\"unknown\" creationtoolversion=\"unknown\" segtype=\"paragraph\" o-tmf=\"unknown\" adminlang=\"en\" srclang=\"en\" datatype=\"text\"></header><body><tu tuid=\"autoID1\"><tuv xml:lang=\"en\"><seg>Source text</seg></tuv><tuv xml:lang=\"fr\"><seg>Target text</seg></tuv></tu><tu tuid=\"autoID2\"><tuv xml:lang=\"en\"><seg>Source text 2</seg></tuv></tu></body></tmx>";
        Assert.assertEquals((Object)expected, (Object)result.replaceAll("[\\r\\n]", ""));
    }

    @Test
    public void testSegmentedOutput() {
        String result = this.rewrite(this.getEvents("##seg##", this.locEN, this.locFR), this.locFR);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><tmx version=\"1.4\"><header creationtool=\"unknown\" creationtoolversion=\"unknown\" segtype=\"paragraph\" o-tmf=\"unknown\" adminlang=\"en\" srclang=\"en\" datatype=\"text\"></header><body><tu tuid=\"autoID1_0\"><tuv xml:lang=\"en\"><seg>First segment for SRC.</seg></tuv><tuv xml:lang=\"fr\"><seg>First segment for TRG.</seg></tuv></tu><tu tuid=\"autoID1_1\"><tuv xml:lang=\"en\"><seg>Second segment for SRC</seg></tuv><tuv xml:lang=\"fr\"><seg>Second segment for TRG</seg></tuv></tu></body></tmx>";
        Assert.assertEquals((Object)expected, (Object)result.replaceAll("[\\r\\n]", ""));
    }

    private ArrayList<Event> getEvents(String snippet, LocaleId srcLang, LocaleId trgLang) {
        ArrayList<Event> list = new ArrayList<Event>();
        this.filter.open(new RawDocument(snippet, srcLang, trgLang));
        while (this.filter.hasNext()) {
            Event event = this.filter.next();
            list.add(event);
        }
        this.filter.close();
        return list;
    }

    private String rewrite(ArrayList<Event> list, LocaleId trgLang) {
        TMXFilterWriter writer = new TMXFilterWriter();
        writer.setOptions(trgLang, null);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        writer.setOutput(output);
        for (Event event : list) {
            writer.handleEvent(event);
        }
        writer.close();
        return output.toString();
    }
}

