/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.threaded;

import java.util.concurrent.BlockingQueue;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.threaded.BaseThreadedPipelineStepAdaptor;
import net.sf.okapi.common.pipeline.threaded.IConsumer;
import net.sf.okapi.common.pipeline.threaded.IProducer;
import net.sf.okapi.common.pipeline.threaded.RuntimeInterruptedException;

class ProducerConsumerPipelineStepAdaptor
extends BaseThreadedPipelineStepAdaptor
implements IProducer,
IConsumer {
    private BlockingQueue<Event> producerQueue;
    private BlockingQueue<Event> consumerQueue;

    public ProducerConsumerPipelineStepAdaptor(IPipelineStep step) {
        super(step);
    }

    @Override
    public void setConsumerQueue(BlockingQueue<Event> consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    @Override
    public void setProducerQueue(BlockingQueue<Event> producerQueue) {
        this.producerQueue = producerQueue;
    }

    protected void addToQueue(Event event) {
        if (this.producerQueue == null) {
            throw new RuntimeException("This class is a consumer not a producer");
        }
        try {
            this.producerQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
    }

    protected Event takeFromQueue() {
        Event event;
        if (this.consumerQueue == null) {
            throw new RuntimeException("This class is a producer not a consumer");
        }
        try {
            event = this.consumerQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        return event;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    protected void processBlockingQueue() {
        Event e = this.takeFromQueue();
        this.getStep().handleEvent(e);
        this.addToQueue(e);
    }

    @Override
    protected void clearBlockingQueues() {
        this.producerQueue.clear();
        this.consumerQueue.clear();
    }
}

