/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;

public class RawDocument
implements IResource {
    private static final Logger LOGGER = Logger.getLogger(RawDocument.class.getName());
    public static final String UNKOWN_ENCODING = "null";
    private Annotations annotations;
    private String filterConfigId;
    private String id;
    private String encoding = "null";
    private LocaleId srcLoc;
    private List<LocaleId> trgLocs;
    private InputStream inputStream;
    private InputStream createdStream;
    private URI inputURI;
    private CharSequence inputCharSequence;
    private boolean hasReaderBeenCalled = false;
    private Reader reader;
    private URI outputURI;
    private File workFile;

    public RawDocument(CharSequence inputCharSequence, LocaleId sourceLocale) {
        this.create(inputCharSequence, sourceLocale, null);
    }

    public RawDocument(CharSequence inputCharSequence, LocaleId sourceLocale, LocaleId targetLocale) {
        this.create(inputCharSequence, sourceLocale, targetLocale);
    }

    public RawDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale) {
        this.create(inputURI, defaultEncoding, sourceLocale, null);
    }

    public RawDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.create(inputURI, defaultEncoding, sourceLocale, targetLocale);
    }

    public RawDocument(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale) {
        this.create(inputStream, defaultEncoding, sourceLocale, null);
    }

    public RawDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale, String filterConfigId) {
        this.create(inputURI, defaultEncoding, sourceLocale, targetLocale);
        this.setFilterConfigId(filterConfigId);
    }

    public RawDocument(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.create(inputStream, defaultEncoding, sourceLocale, targetLocale);
    }

    private void create(CharSequence inputCharSequence, LocaleId srcLoc, LocaleId trgLoc) {
        if (inputCharSequence == null) {
            throw new IllegalArgumentException("inputCharSequence cannot be null");
        }
        this.inputCharSequence = inputCharSequence;
        this.encoding = "UTF-16";
        this.srcLoc = srcLoc;
        this.trgLocs = new ArrayList<LocaleId>(1);
        if (trgLoc != null) {
            this.trgLocs.add(trgLoc);
        }
    }

    private void create(URI inputURI, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc) {
        if (inputURI == null) {
            throw new IllegalArgumentException("inputURI cannot be null");
        }
        this.inputURI = inputURI;
        this.encoding = defaultEncoding;
        this.srcLoc = srcLoc;
        this.trgLocs = new ArrayList<LocaleId>(1);
        if (trgLoc != null) {
            this.trgLocs.add(trgLoc);
        }
    }

    private void create(InputStream inputStream, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null");
        }
        this.inputStream = inputStream;
        this.encoding = defaultEncoding;
        this.srcLoc = srcLoc;
        this.trgLocs = new ArrayList<LocaleId>(1);
        if (trgLoc != null) {
            this.trgLocs.add(trgLoc);
        }
    }

    public Reader getReader() {
        if (this.getEncoding() == UNKOWN_ENCODING) {
            throw new OkapiUnsupportedEncodingException("Encoding has not been set");
        }
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing the reader created by RawDocument.", e);
            }
        }
        try {
            this.reader = new InputStreamReader(this.createStream(), this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.getEncoding()), e);
        }
        this.hasReaderBeenCalled = true;
        return this.reader;
    }

    private InputStream createStream() {
        if (this.createdStream != null) {
            try {
                this.createdStream.reset();
                this.inputStream = this.createdStream;
                return this.inputStream;
            }
            catch (IOException e) {
                try {
                    this.createdStream.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
        }
        if (this.getInputCharSequence() != null) {
            try {
                this.inputStream = new ByteArrayInputStream(((Object)this.inputCharSequence).toString().getBytes(this.getEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.getEncoding()), e);
            }
        } else if (this.getInputURI() != null) {
            URL url = null;
            try {
                url = this.getInputURI().toURL();
                this.inputStream = new BufferedInputStream(url.openStream());
            }
            catch (IllegalArgumentException e) {
                throw new OkapiIOException("Could not open the URI. The URI must be absolute: " + (url == null ? "URL is null" : url.toString()), e);
            }
            catch (MalformedURLException e) {
                throw new OkapiIOException("Could not open the URI. The URI may be malformed: " + (url == null ? "URL is null" : url.toString()), e);
            }
            catch (IOException e) {
                throw new OkapiIOException("Could not open the URL. The URL is OK but the input stream could not be opened.\n" + e.getMessage(), e);
            }
        } else if (this.createdStream == null) {
            this.inputStream = new BufferedInputStream(this.inputStream);
        } else {
            throw new OkapiIOException("Second call to getStream() with InputStream. Cannot reset stream.");
        }
        this.inputStream.mark(8192);
        return this.inputStream;
    }

    public InputStream getStream() {
        this.createdStream = this.createStream();
        return this.createdStream;
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ISkeleton getSkeleton() {
        throw new OkapiNotImplementedException("The RawDocument resource does not have skeketon");
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setSkeleton(ISkeleton skeleton) {
        throw new OkapiNotImplementedException("RawDcoument has no skeleton");
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public CharSequence getInputCharSequence() {
        return this.inputCharSequence;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public LocaleId getSourceLocale() {
        return this.srcLoc;
    }

    public void setSourceLocale(LocaleId locId) {
        this.srcLoc = locId;
    }

    public LocaleId getTargetLocale() {
        if (this.trgLocs.isEmpty()) {
            return null;
        }
        return this.trgLocs.get(0);
    }

    public void setTargetLocale(LocaleId locId) {
        this.trgLocs.clear();
        this.trgLocs.add(locId);
    }

    public List<LocaleId> getTargetLocales() {
        return this.trgLocs;
    }

    public void setTargetLocales(List<LocaleId> locIds) {
        this.trgLocs = locIds != null ? locIds : new ArrayList<LocaleId>(1);
    }

    public void setEncoding(String encoding) {
        if (this.inputCharSequence != null) {
            LOGGER.log(Level.FINE, "Cannot reset an encoding on a CharSequence input in RawDocument");
            return;
        }
        if (this.hasReaderBeenCalled) {
            LOGGER.log(Level.WARNING, "Setting an encoding after getReader() has been called is not recommened. Subsequent calls to getReader() may use the old encoding if the stream can be reset instead of recreated.");
        }
        this.encoding = encoding;
    }

    public void setFilterConfigId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public String getFilterConfigId() {
        return this.filterConfigId;
    }

    public void close() {
        if (this.createdStream != null) {
            try {
                this.createdStream.close();
                this.createdStream = null;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing the stream created by RawDocument.", e);
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing the inputStream created by RawDocument.", e);
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing the reader created by RawDocument.", e);
            }
        }
    }

    public Annotations getAnnotations() {
        return this.annotations == null ? new Annotations() : this.annotations;
    }

    public File createOutputFile(URI outputURI) {
        this.outputURI = outputURI;
        if (this.getInputURI() != null) {
            String dir = Util.getDirectoryName(outputURI.getPath());
            if (outputURI.getPath().equals(this.getInputURI().getPath())) {
                try {
                    this.workFile = File.createTempFile("work", null, new File(dir));
                }
                catch (IOException e) {
                    throw new OkapiIOException(String.format("Cannot create temporary file in '%s'.", dir));
                }
                return this.workFile;
            }
        }
        this.workFile = new File(outputURI);
        Util.createDirectories(this.workFile.getAbsolutePath());
        return this.workFile;
    }

    public void finalizeOutput() {
        if (this.workFile == null) {
            return;
        }
        if (this.workFile.toURI().equals(this.outputURI)) {
            return;
        }
        File outputFile = new File(this.outputURI);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new OkapiIOException(String.format("Cannot delete original input file '%s'. The output is still in the temporary file '%s'.", outputFile.getAbsolutePath(), this.workFile.getAbsolutePath()));
        }
        if (!this.workFile.renameTo(outputFile)) {
            throw new OkapiIOException(String.format("Cannot rename the temporary output file to '%s'. The output is still under the temporary name '%s'.", outputFile.getAbsolutePath(), this.workFile.getAbsolutePath()));
        }
    }
}

