/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.po;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.po.Parameters;
import net.sf.okapi.filters.po.PluralForms;

public class POWriter
implements IFilterWriter {
    public static final String CRUMBS_PREFIX = "okpCtx";
    public static final String SUBDOCUMENT_CRUMB = "sd=";
    public static final String GROUP_CRUMB = "gp=";
    public static final String TEXTUNIT_CRUMB = "tu=";
    private static final String ESCAPEABLE = "\\\"abfnrtv";
    private Parameters params = new Parameters();
    private OutputStream output;
    private String outputPath;
    private OutputStreamWriter writer;
    private File tempFile;
    private LocaleId language;
    private String encoding;
    private int group;
    private int pluralGroup;
    private String linebreak;
    private GenericContent fmt = new GenericContent();
    private ArrayList<ITextUnit> plurals = new ArrayList();
    private boolean forExtractMerge = false;
    private boolean makePOT = false;
    private boolean transFuzzy = true;
    private String crumbs;

    @Override
    public void cancel() {
    }

    public void setMode(boolean forExtractMerge, boolean makePOT, boolean transFuzzy) {
        this.forExtractMerge = forExtractMerge;
        this.makePOT = makePOT;
        this.transFuzzy = transFuzzy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            this.output.close();
            this.output = null;
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new RuntimeException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "POFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument();
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event);
                break;
            }
            case END_GROUP: {
                this.processEndGroup(event);
                break;
            }
            case TEXT_UNIT: {
                if (this.pluralGroup > -1) {
                    this.plurals.add(event.getTextUnit());
                    break;
                }
                this.processTextUnit(event);
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.language = language;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.outputPath = null;
        this.output = output;
    }

    @Override
    public void setParameters(IParameters params) {
        params = (Parameters)params;
    }

    private void processStartDocument(Event event) {
        try {
            StartDocument sd = (StartDocument)event.getResource();
            this.createWriter(sd);
            this.writer.write("# " + this.linebreak);
            if (this.forExtractMerge) {
                this.writer.write("# This file is intended to be merged back. " + this.linebreak);
                this.writer.write("# Please preserve the msgctxt lines and the order of the entries." + this.linebreak);
                this.writer.write("# " + this.linebreak);
            }
            this.writer.write("msgid \"\"" + this.linebreak);
            this.writer.write("msgstr \"\"" + this.linebreak);
            this.writer.write("\"Content-Type: text/plain; charset=" + this.encoding + "\\n\"" + this.linebreak);
            this.writer.write("\"Content-Transfer-Encoding: 8bit\\n\"" + this.linebreak);
            this.writer.write("\"Language: " + this.language.toPOSIXLocaleId() + "\\n\"" + this.linebreak);
            this.writer.write("\"Plural-Forms: " + PluralForms.getExpression(this.language));
            this.writer.write("\\n\"" + this.linebreak + this.linebreak);
            this.crumbs = CRUMBS_PREFIX;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing the header.", e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processStartSubDocument(Event event) {
        if (this.forExtractMerge) {
            StartSubDocument ssd = (StartSubDocument)event.getResource();
            this.pushCrumb(SUBDOCUMENT_CRUMB + ssd.getId());
        }
    }

    private void processEndSubDocument() {
        if (this.forExtractMerge) {
            this.popCrumb();
        }
    }

    private void processStartGroup(Event event) {
        ++this.group;
        StartGroup sg = (StartGroup)event.getResource();
        if (sg.getType() != null && sg.getType().equals("x-gettext-plurals")) {
            this.pluralGroup = this.group;
            this.plurals.clear();
        }
        if (this.forExtractMerge) {
            this.pushCrumb(GROUP_CRUMB + sg.getId());
        }
    }

    private void processEndGroup(Event event) {
        if (this.pluralGroup == this.group) {
            this.writePluralForms();
            this.pluralGroup = -1;
        }
        --this.group;
        if (this.forExtractMerge) {
            this.popCrumb();
        }
    }

    private void popCrumb() {
        int n = this.crumbs.lastIndexOf(58);
        this.crumbs = this.crumbs.substring(0, n);
    }

    private void pushCrumb(String crumb) {
        this.crumbs = this.crumbs + ":" + crumb;
    }

    private void writePluralForms() {
        try {
            Property prop;
            if (this.plurals.size() < 2) {
                throw new OkapiIOException("PO connot have less than two entries for a plural form.");
            }
            TextContainer tc = this.plurals.get(0).getTarget(this.language);
            if (tc != null && (prop = tc.getProperty("approved")) != null && !prop.getValue().equals("yes")) {
                this.writer.write("#, fuzzy" + this.linebreak);
            }
            this.writer.write("msgid ");
            this.writeQuotedContent(this.plurals.get(0).getSource());
            this.writer.write(this.linebreak);
            this.writer.write("msgid_plural ");
            this.writeQuotedContent(this.plurals.get(1).getSource());
            this.writer.write(this.linebreak);
            int count = 0;
            for (ITextUnit tu : this.plurals) {
                this.writer.write(String.format("msgstr[%d] ", count));
                if (tu.hasTarget(this.language) && !this.makePOT) {
                    this.writeQuotedContent(tu.getTarget(this.language));
                } else {
                    this.writer.write("\"\"");
                }
                this.writer.write(this.linebreak);
                ++count;
            }
            this.writer.write(this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a plural group.", e);
        }
    }

    private void processTextUnit(Event event) {
        try {
            ITextUnit tu = event.getTextUnit();
            if (tu.isEmpty()) {
                return;
            }
            TextContainer tc = tu.getTarget(this.language);
            Property prop = null;
            if (tc != null) {
                prop = tc.getProperty("approved");
            }
            if (!this.makePOT) {
                if (prop != null) {
                    if (!prop.getValue().equals("yes")) {
                        this.writer.write("#, fuzzy" + this.linebreak);
                    }
                } else if (this.forExtractMerge && tc != null && !tc.isEmpty() && this.transFuzzy) {
                    this.writer.write("#, fuzzy" + this.linebreak);
                }
            }
            if (this.forExtractMerge) {
                this.writer.write("msgctxt \"" + this.crumbs + ":" + TEXTUNIT_CRUMB + tu.getId() + "\"" + this.linebreak);
            }
            this.writer.write("msgid ");
            this.writeQuotedContent(tu.getSource());
            this.writer.write(this.linebreak);
            this.writer.write("msgstr ");
            if (tc != null && !this.makePOT) {
                this.writeQuotedContent(tc);
            } else {
                this.writer.write("\"\"");
            }
            this.writer.write(this.linebreak + this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a text unit.", e);
        }
    }

    private void writeQuotedContent(TextContainer tc) {
        try {
            String tmp;
            if (tc == null) {
                this.writer.write("\"\"");
                return;
            }
            if (this.forExtractMerge) {
                if (tc.contentIsOneSegment()) {
                    tmp = GenericContent.fromFragmentToLetterCoded(tc.getFirstContent(), true);
                } else {
                    boolean hasSomeText = false;
                    for (Segment seg : tc.getSegments()) {
                        if (!seg.text.hasText()) continue;
                        hasSomeText = true;
                        break;
                    }
                    tmp = hasSomeText ? GenericContent.fromFragmentToLetterCoded(tc.getUnSegmentedContentCopy(), true) : "";
                }
            } else {
                tmp = this.fmt.printSegmentedContent(tc, false, !this.params.getOutputGeneric());
            }
            tmp = this.escapeIfNeeded(tmp);
            if (!this.params.getWrapContent() || tmp.indexOf("\\n") == -1) {
                this.writer.write("\"");
                this.writer.write(tmp);
                this.writer.write("\"");
            } else {
                int n = 0;
                int start = 0;
                this.writer.write("\"\"");
                while ((n = tmp.indexOf("\\n", start)) > -1) {
                    this.writer.write(this.linebreak + "\"");
                    this.writer.write(tmp.substring(start, n += 2));
                    this.writer.write("\"");
                    start = n;
                }
                if (n == -1 && start < tmp.length()) {
                    this.writer.write(this.linebreak + "\"");
                    this.writer.write(tmp.substring(start));
                    this.writer.write("\"");
                }
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a quoted text.", e);
        }
    }

    private String escapeIfNeeded(String in) {
        int prev = 0;
        StringBuilder tmp = new StringBuilder(in.length());
        block5: for (int i = 0; i < in.length(); ++i) {
            switch (in.charAt(i)) {
                case '\\': {
                    if (i < in.length() - 1 && ESCAPEABLE.indexOf(in.charAt(i + 1)) != -1) {
                        tmp.append('\\');
                        tmp.append(in.charAt(i + 1));
                        ++i;
                    } else {
                        tmp.append("\\\\");
                    }
                    prev = 0;
                    continue block5;
                }
                case '\"': {
                    if (prev != 92) {
                        tmp.append('\\');
                    }
                    tmp.append(in.charAt(i));
                    break;
                }
                case '\n': {
                    tmp.append("\\n");
                    break;
                }
                default: {
                    tmp.append(in.charAt(i));
                }
            }
            prev = in.charAt(i);
        }
        return tmp.toString();
    }

    private void createWriter(StartDocument startDoc) {
        this.group = 0;
        this.pluralGroup = -1;
        this.linebreak = startDoc.getLineBreak();
        try {
            String originalEnc;
            this.tempFile = null;
            if (this.output == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("pofwTmp", null);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = startDoc.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.output, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = false;
            }
            Util.writeBOMIfNeeded(this.writer, useUTF8BOM, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }
}

