/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ttx;

import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;

public class TTXSkeletonWriter
extends GenericSkeletonWriter {
    private String srcLangCode;
    private String trgLangCode;

    public void setSourceLanguageCode(String langCode) {
        this.srcLangCode = langCode;
    }

    public void setTargetLanguageCode(String langCode) {
        this.trgLangCode = langCode;
    }

    @Override
    public String processTextUnit(ITextUnit tu) {
        TextContainer trgCont;
        TextContainer srcCont;
        if (tu == null) {
            return "";
        }
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(tu.getMimeType());
        }
        StringBuilder tmp = new StringBuilder();
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        if (skel != null && skel.getParts().size() > 1) {
            tmp.append(this.getString(skel.getParts().get(0), 1));
        }
        if (!(srcCont = tu.getSource()).hasBeenSegmented()) {
            srcCont = srcCont.clone();
            srcCont.setHasBeenSegmentedFlag(true);
        }
        if (tu.hasTarget(this.outputLoc)) {
            trgCont = tu.getTarget(this.outputLoc);
            if (!trgCont.hasBeenSegmented()) {
                trgCont = trgCont.clone();
                trgCont.setHasBeenSegmentedFlag(true);
            }
        } else {
            trgCont = srcCont;
        }
        for (TextPart part : trgCont) {
            if (part.isSegment()) {
                Segment trgSeg = (Segment)part;
                Segment srcSeg = srcCont.getSegments().get(trgSeg.id);
                if (srcSeg == null) {
                    srcSeg = trgSeg;
                }
                if (trgSeg.text.isEmpty() && !srcSeg.text.isEmpty()) {
                    trgSeg.text = srcSeg.text.clone();
                }
                if (trgCont.hasBeenSegmented()) {
                    AltTranslation altTrans = null;
                    AltTranslationsAnnotation ann = trgSeg.getAnnotation(AltTranslationsAnnotation.class);
                    if (ann != null) {
                        altTrans = ann.getFirst();
                    }
                    tmp.append(this.processSegment(srcSeg.text, trgSeg.text, altTrans));
                    continue;
                }
                tmp.append(this.processFragment(part.getContent(), 0));
                continue;
            }
            tmp.append(this.processFragment(part.getContent(), 1));
        }
        return tmp.toString();
    }

    private String processSegment(TextFragment srcFrag, TextFragment trgFrag, AltTranslation altTrans) {
        if (trgFrag == null) {
            trgFrag = srcFrag;
        }
        StringBuilder tmp = new StringBuilder();
        if (altTrans != null) {
            String origin = altTrans.getOrigin();
            if (origin != null && origin.equals("SourceDoc")) {
                origin = null;
            }
            if (!Util.isEmpty(origin)) {
                tmp.append("<Tu Origin=\"" + altTrans.getOrigin() + "\" ");
            } else {
                tmp.append("<Tu ");
            }
            tmp.append(String.format("MatchPercent=\"%d\">", altTrans.getCombinedScore()));
        } else {
            tmp.append("<Tu MatchPercent=\"0\">");
        }
        tmp.append(String.format("<Tuv Lang=\"%s\">", this.srcLangCode));
        tmp.append(this.processFragment(srcFrag, 1));
        tmp.append("</Tuv>");
        tmp.append(String.format("<Tuv Lang=\"%s\">", this.trgLangCode));
        if (this.layer != null) {
            if (altTrans != null) {
                tmp.append(this.layer.endCode());
                tmp.append(this.layer.startSegment());
                tmp.append(this.processFragment(srcFrag, 1));
                tmp.append(this.layer.midSegment(altTrans.getCombinedScore()));
                tmp.append(this.processFragment(trgFrag, 0));
                tmp.append(this.layer.endSegment());
                tmp.append(this.layer.startCode());
            } else {
                tmp.append(this.layer.endCode());
                tmp.append(this.processFragment(trgFrag, 0));
                tmp.append(this.layer.startCode());
            }
        } else {
            tmp.append(this.processFragment(trgFrag, 0));
        }
        tmp.append("</Tuv>");
        tmp.append("</Tu>");
        return tmp.toString();
    }

    protected void checkForFilterInternalUse(String lineBreak) {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-ttx+xml", "net.sf.okapi.common.encoder.XMLEncoder");
            this.encoderManager.setDefaultOptions(null, "US-ASCII", lineBreak);
            this.encoderManager.updateEncoder("application/x-ttx+xml");
        }
    }

    protected String processFragment(TextFragment frag, int context) {
        StringBuilder tmp = new StringBuilder();
        String text = frag.getCodedText();
        block3: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    tmp.append(this.expandCode(frag.getCode(text.charAt(++i)), context));
                    continue block3;
                }
                default: {
                    tmp.append(this.encoderManager.encode(ch, context));
                    continue block3;
                }
            }
        }
        return tmp.toString();
    }

    private String expandCode(Code code, int context) {
        if (this.layer != null) {
            if (context == 0) {
                return this.layer.startInline() + this.layer.encode(code.getOuterData(), 2) + this.layer.endInline();
            }
            return this.layer.encode(code.getOuterData(), 1);
        }
        return code.getOuterData();
    }
}

