/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final int SEGMENTATIONTYPE_ORIGINAL = 0;
    public static final int SEGMENTATIONTYPE_SEGMENTED = 1;
    public static final int SEGMENTATIONTYPE_NOTSEGMENTED = 2;
    public static final int SEGMENTATIONTYPE_ASNEEDED = 3;
    public static final int TARGETSTATEMODE_IGNORE = 0;
    public static final int TARGETSTATEMODE_EXTRACT = 1;
    public static final int TARGETSTATEMODE_DONOTEXTRACT = 2;
    public static final String ADDALTTRANS = "addAltTrans";
    public static final String ADDALTTRANSGMODE = "addAltTransGMode";
    private static final String USECUSTOMPARSER = "useCustomParser";
    private static final String FACTORYCLASS = "factoryClass";
    private static final String FALLBACKTOID = "fallbackToID";
    private static final String ADDTARGETLANGUAGE = "addTargetLanguage";
    private static final String OVERRIDETARGETLANGUAGE = "overrideTargetLanguage";
    private static final String OUTPUTSEGMENTATIONTYPE = "outputSegmentationType";
    private static final String IGNOREINPUTSEGMENTATION = "ignoreInputSegmentation";
    private static final String INCLUDEEXTENSIONS = "includeExtensions";
    private static final String TARGETSTATEMODE = "targetStateMode";
    private static final String TARGETSTATEVALUE = "targetStateValue";
    private boolean useCustomParser;
    private String factoryClass;
    private boolean fallbackToID;
    private boolean escapeGT;
    private boolean addTargetLanguage;
    private boolean overrideTargetLanguage;
    private int outputSegmentationType;
    private boolean ignoreInputSegmentation;
    private boolean addAltTrans;
    private boolean addAltTransGMode;
    private boolean includeExtensions;
    private int targetStateMode;
    private String targetStateValue;
    public boolean quoteModeDefined;
    public int quoteMode;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public boolean getUseCustomParser() {
        return this.useCustomParser;
    }

    public void setUseCustomParser(boolean useCustomParser) {
        this.useCustomParser = useCustomParser;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public boolean getEscapeGT() {
        return this.escapeGT;
    }

    public void setEscapeGT(boolean escapeGT) {
        this.escapeGT = escapeGT;
    }

    public boolean getFallbackToID() {
        return this.fallbackToID;
    }

    public void setFallbackToID(boolean fallbackToID) {
        this.fallbackToID = fallbackToID;
    }

    public boolean getAddTargetLanguage() {
        return this.addTargetLanguage;
    }

    public void setAddTargetLanguage(boolean addTargetLanguage) {
        this.addTargetLanguage = addTargetLanguage;
    }

    public boolean getOverrideTargetLanguage() {
        return this.overrideTargetLanguage;
    }

    public void setOverrideTargetLanguage(boolean overrideTargetLanguage) {
        this.overrideTargetLanguage = overrideTargetLanguage;
    }

    public int getOutputSegmentationType() {
        return this.outputSegmentationType;
    }

    public void setOutputSegmentationType(int segmentationType) {
        this.outputSegmentationType = segmentationType;
    }

    public boolean getIgnoreInputSegmentation() {
        return this.ignoreInputSegmentation;
    }

    public void setIgnoreInputSegmentation(boolean ignoreInputSegmentation) {
        this.ignoreInputSegmentation = ignoreInputSegmentation;
    }

    public boolean getAddAltTrans() {
        return this.addAltTrans;
    }

    public void setAddAltTrans(boolean addAltTrans) {
        this.addAltTrans = addAltTrans;
    }

    public boolean getAddAltTransGMode() {
        return this.addAltTransGMode;
    }

    public void setAddAltTransGMode(boolean addAltTransGMode) {
        this.addAltTransGMode = addAltTransGMode;
    }

    public boolean getIncludeExtensions() {
        return this.includeExtensions;
    }

    public void setIncludeExtensions(boolean includeExtensions) {
        this.includeExtensions = includeExtensions;
    }

    public int getTargetStateMode() {
        return this.targetStateMode;
    }

    public void setTargetStateMode(int targetStateMode) {
        this.targetStateMode = targetStateMode;
    }

    public String getTargetStateValue() {
        return this.targetStateValue;
    }

    public void setTargetStateValue(String targetStateValue) {
        this.targetStateValue = targetStateValue;
    }

    public boolean getQuoteModeDefined() {
        return this.quoteModeDefined;
    }

    public int getQuoteMode() {
        return this.quoteMode;
    }

    @Override
    public void reset() {
        this.useCustomParser = false;
        this.factoryClass = "com.ctc.wstx.stax.WstxInputFactory";
        this.fallbackToID = false;
        this.escapeGT = false;
        this.addTargetLanguage = true;
        this.overrideTargetLanguage = false;
        this.outputSegmentationType = 0;
        this.ignoreInputSegmentation = false;
        this.addAltTrans = false;
        this.addAltTransGMode = true;
        this.includeExtensions = true;
        this.targetStateMode = 0;
        this.targetStateValue = "needs-translation";
        this.quoteModeDefined = true;
        this.quoteMode = 0;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.useCustomParser = this.buffer.getBoolean(USECUSTOMPARSER, this.useCustomParser);
        this.factoryClass = this.buffer.getString(FACTORYCLASS, this.factoryClass);
        this.fallbackToID = this.buffer.getBoolean(FALLBACKTOID, this.fallbackToID);
        this.escapeGT = this.buffer.getBoolean("escapeGT", this.escapeGT);
        this.addTargetLanguage = this.buffer.getBoolean(ADDTARGETLANGUAGE, this.addTargetLanguage);
        this.overrideTargetLanguage = this.buffer.getBoolean(OVERRIDETARGETLANGUAGE, this.overrideTargetLanguage);
        this.outputSegmentationType = this.buffer.getInteger(OUTPUTSEGMENTATIONTYPE, this.outputSegmentationType);
        this.ignoreInputSegmentation = this.buffer.getBoolean(IGNOREINPUTSEGMENTATION, this.ignoreInputSegmentation);
        this.addAltTrans = this.buffer.getBoolean(ADDALTTRANS, this.addAltTrans);
        this.addAltTransGMode = this.buffer.getBoolean(ADDALTTRANSGMODE, this.addAltTransGMode);
        this.includeExtensions = this.buffer.getBoolean(INCLUDEEXTENSIONS, this.includeExtensions);
        this.targetStateMode = this.buffer.getInteger(TARGETSTATEMODE, this.targetStateMode);
        this.targetStateValue = this.buffer.getString(TARGETSTATEVALUE, this.targetStateValue);
        this.quoteModeDefined = this.buffer.getBoolean("quoteModeDefined", this.quoteModeDefined);
        this.quoteMode = this.buffer.getInteger("quoteMode", this.quoteMode);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(USECUSTOMPARSER, this.useCustomParser);
        this.buffer.setString(FACTORYCLASS, this.factoryClass);
        this.buffer.setBoolean(FALLBACKTOID, this.fallbackToID);
        this.buffer.setBoolean("escapeGT", this.escapeGT);
        this.buffer.setBoolean(ADDTARGETLANGUAGE, this.addTargetLanguage);
        this.buffer.setBoolean(OVERRIDETARGETLANGUAGE, this.overrideTargetLanguage);
        this.buffer.setInteger(OUTPUTSEGMENTATIONTYPE, this.outputSegmentationType);
        this.buffer.setBoolean(IGNOREINPUTSEGMENTATION, this.ignoreInputSegmentation);
        this.buffer.setBoolean(ADDALTTRANS, this.addAltTrans);
        this.buffer.setBoolean(ADDALTTRANSGMODE, this.addAltTransGMode);
        this.buffer.setBoolean(INCLUDEEXTENSIONS, this.includeExtensions);
        this.buffer.setInteger(TARGETSTATEMODE, this.targetStateMode);
        this.buffer.setString(TARGETSTATEVALUE, this.targetStateValue);
        this.buffer.setBoolean("quoteModeDefined", this.quoteModeDefined);
        this.buffer.setInteger("quoteMode", this.quoteMode);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USECUSTOMPARSER, "Use a custom XML stream parser", null);
        desc.add(FACTORYCLASS, "Factory class for the custom XML stream parser", null);
        desc.add(FALLBACKTOID, "Use the trans-unit id attribute for the text unit name if there is no resname", null);
        desc.add(IGNOREINPUTSEGMENTATION, "Ignore the segmentation information in the input", null);
        desc.add("escapeGT", "Escape the greater-than characters", null);
        desc.add(ADDTARGETLANGUAGE, "Add the target-language attribute if not present", null);
        desc.add(OVERRIDETARGETLANGUAGE, "Override the target language of the XLIFF document", null);
        desc.add(OUTPUTSEGMENTATIONTYPE, "Type of output segmentation", "Indicates wether to segment or not the text content in output");
        desc.add(ADDALTTRANS, "Allow addition of new <alt-trans> elements", "Indicates wether or not to adding new <alt-trans> elements is allowed");
        desc.add(ADDALTTRANSGMODE, "Use the <g> notation in new <alt-trans> elements", "Indicates wether or not to use the <g> notation in new <alt-trans> elements");
        desc.add(INCLUDEEXTENSIONS, "Include extra information", "If set: non-standard information are included in the added <alt-trans>");
        desc.add(TARGETSTATEMODE, "Action to do when the value of the state attribute matches the specified pattern", null);
        desc.add(TARGETSTATEVALUE, "Pattern for the state attribute value", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("XLIFF Filter Parameters", true, false);
        desc.addCheckboxPart(paramDesc.get(FALLBACKTOID));
        desc.addCheckboxPart(paramDesc.get(IGNOREINPUTSEGMENTATION));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramDesc.get("escapeGT"));
        desc.addCheckboxPart(paramDesc.get(ADDTARGETLANGUAGE));
        desc.addCheckboxPart(paramDesc.get(OVERRIDETARGETLANGUAGE));
        String[] values2 = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2), String.valueOf(3)};
        String[] labels2 = new String[]{"Show segments only if the input text unit is segmented", "Always show segments (even if the input text unit is not segmented)", "Never show segments (even if the input text unit is segmented)", "Show segments only if the entry is segmented and regardless how the input was"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(OUTPUTSEGMENTATIONTYPE), values2);
        lsp.setChoicesLabels(labels2);
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(ADDALTTRANS));
        desc.addCheckboxPart(paramDesc.get(INCLUDEEXTENSIONS)).setMasterPart(cbp, true);
        desc.addCheckboxPart(paramDesc.get(ADDALTTRANSGMODE)).setMasterPart(cbp, true);
        desc.addSeparatorPart();
        cbp = desc.addCheckboxPart(paramDesc.get(USECUSTOMPARSER));
        desc.addTextInputPart(paramDesc.get(FACTORYCLASS)).setMasterPart(cbp, true);
        return desc;
    }
}

