/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.terminology.simpletb.SimpleTB;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.IssueType;
import net.sf.okapi.lib.verification.LanguageToolConnector;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.PatternItem;
import net.sf.okapi.lib.verification.TermChecker;

class QualityChecker {
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private List<PatternItem> patterns;
    private LanguageToolConnector ltConn;
    private TermChecker termChecker;
    private Parameters params;
    private List<Issue> issues;
    private URI currentDocId;
    private List<String> sigList;
    private Pattern patDoubledWords;
    private String doubledWordExceptions;
    private CharsetEncoder encoder1;
    private CharsetEncoder encoder2;
    private Pattern extraCharsAllowed;
    private Pattern corruption;
    private static final Pattern WORDCHARS = Pattern.compile("[\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}\\p{Nd}]");

    QualityChecker() {
    }

    void startProcess(LocaleId sourceLocale, LocaleId targetLocale, Parameters params, List<Issue> issues) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.params = params;
        this.issues = issues;
        this.patterns = params.getPatterns();
        for (PatternItem item : this.patterns) {
            if (!item.enabled) continue;
            item.compile();
        }
        this.ltConn = null;
        if (params.getCheckWithLT()) {
            this.ltConn = new LanguageToolConnector();
            this.ltConn.initialize(targetLocale, sourceLocale, params.getServerURL(), params.translateLTMsg, params.ltBilingualMode, params.ltTranslationSource, params.ltTranslationTarget, params.ltTranslationServiceKey);
        }
        this.patDoubledWords = null;
        if (params.getDoubledWord()) {
            this.patDoubledWords = Pattern.compile("\\b([\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}\\p{Nd}]+)[\\t\\n\\f\\r\\p{Z}]+\\1\\b", 2);
            this.doubledWordExceptions = ";" + params.getDoubledWordExceptions().toLowerCase() + ";";
        }
        this.corruption = null;
        if (params.getCorruptedCharacters()) {
            this.corruption = Pattern.compile("\\u00C3[\\u00A4-\\u00B6]|\\u00C3\\u201E|\\u00C3\\u2026|\\u00C3\\u2013");
        }
        this.encoder1 = null;
        this.extraCharsAllowed = null;
        if (params.getCheckCharacters()) {
            String charsetName = params.charset;
            if (!Util.isEmpty(charsetName)) {
                this.encoder1 = Charset.forName(charsetName).newEncoder();
            }
            if (!params.getExtraCharsAllowed().isEmpty()) {
                this.extraCharsAllowed = Pattern.compile(params.getExtraCharsAllowed());
            }
        }
        this.termChecker = null;
        if (params.getCheckTerms()) {
            this.termChecker = new TermChecker();
            SimpleTB ta = new SimpleTB(this.srcLoc, this.trgLoc);
            ta.guessAndImport(new File(params.getTermsPath()));
            this.termChecker.initialize(ta, this.srcLoc, this.trgLoc, params.getStringMode(), params.getBetweenCodes());
        }
    }

    void processStartDocument(StartDocument sd, List<String> sigList) {
        this.currentDocId = new File(sd.getName()).toURI();
        this.sigList = sigList;
    }

    private boolean hasMeaningfullText(TextFragment frag) {
        return WORDCHARS.matcher(frag.getCodedText()).find();
    }

    void processTextUnit(ITextUnit tu) {
        Property prop;
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        if (this.params.getCheckStorageSize()) {
            this.checkStorageSize(tu, srcCont, true);
        }
        if (trgCont == null) {
            this.reportIssue(IssueType.MISSING_TARGETTU, tu, null, "Missing translation.", 0, -1, 0, -1, 2, srcCont.toString(), "", null);
            return;
        }
        if (this.params.getCheckStorageSize()) {
            this.checkStorageSize(tu, trgCont, false);
        }
        if (this.params.getScope() != 0 && ((prop = trgCont.getProperty("approved")) != null && prop.getValue().equals("yes") ? this.params.getScope() == 2 : this.params.getScope() == 1)) {
            return;
        }
        ISegments srcSegs = srcCont.getSegments();
        ISegments trgSegs = trgCont.getSegments();
        Property prop2 = trgCont.getProperty("hashiddentext");
        if (prop2 != null) {
            Scanner scan = new Scanner(prop2.getValue()).useDelimiter(";");
            TextFragment tf = trgCont.getUnSegmentedContentCopy();
            int start = QualityChecker.fromFragmentToString(tf, scan.nextInt());
            int end = QualityChecker.fromFragmentToString(tf, scan.nextInt());
            this.reportIssue(IssueType.SUSPECT_PATTERN, tu, null, "Target content has at least one hidden part.", 0, -1, start, end, 2, srcCont.toString(), trgCont.toString(), null);
        }
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = trgSegs.get(srcSeg.getId());
            if (trgSeg == null) {
                this.reportIssue(IssueType.MISSING_TARGETSEG, tu, srcSeg.getId(), "The source segment has no corresponding target segment.", 0, -1, 0, -1, 2, srcSeg.toString(), "", null);
                continue;
            }
            if (this.params.getEmptyTarget() && trgSeg.text.isEmpty() && !srcSeg.text.isEmpty()) {
                this.reportIssue(IssueType.EMPTY_TARGETSEG, tu, srcSeg.getId(), "The target segment is empty, but its source is not empty.", 0, -1, 0, -1, 2, srcSeg.toString(), "", null);
                continue;
            }
            if (this.params.getEmptySource() && srcSeg.text.isEmpty() && !trgSeg.text.isEmpty()) {
                this.reportIssue(IssueType.EMPTY_SOURCESEG, tu, srcSeg.getId(), "The target segment is not empty, but its source is empty.", 0, -1, 0, -1, 2, srcSeg.toString(), "", null);
                continue;
            }
            if (this.params.getCodeDifference()) {
                this.checkInlineCodes(srcSeg, trgSeg, tu);
            }
            if (this.params.getTargetSameAsSource() && (this.params.getTargetSameAsSourceForSameLanguage() || !this.srcLoc.sameLanguageAs(this.trgLoc)) && this.hasMeaningfullText(srcSeg.text) && srcSeg.text.compareTo(trgSeg.text, this.params.getTargetSameAsSourceWithCodes()) == 0) {
                boolean warn = true;
                if (this.patterns != null) {
                    for (PatternItem item : this.patterns) {
                        Matcher m;
                        String ctext = srcSeg.text.getCodedText();
                        if (!item.enabled || !item.target.equals("<same>") || !(m = item.getSourcePattern().matcher(ctext)).find()) continue;
                        warn = !ctext.equals(m.group());
                        break;
                    }
                }
                if (warn) {
                    this.reportIssue(IssueType.TARGET_SAME_AS_SOURCE, tu, srcSeg.getId(), "Translation is the same as the source.", 0, -1, 0, -1, 1, srcSeg.toString(), trgSeg.toString(), null);
                }
            }
            if (this.params.getCheckPatterns()) {
                this.checkPatterns(srcSeg, trgSeg, tu);
            }
            if (this.termChecker != null && this.termChecker.verify(this.currentDocId, tu, srcSeg, trgSeg) > 0) {
                for (Issue issue : this.termChecker.getIssues()) {
                    this.reportIssue(issue.issueType, tu, issue.segId, issue.message, issue.srcStart, issue.srcEnd, issue.trgStart, issue.trgEnd, issue.severity, srcSeg.toString(), trgSeg.toString(), null);
                }
            }
            if (this.params.getCheckMaxCharLength() || this.params.getCheckMinCharLength() || this.params.getCheckAbsoluteMaxCharLength()) {
                this.checkLengths(srcSeg, trgSeg, tu);
            }
            this.checkSuspectPatterns(srcSeg, trgSeg, tu);
            if (this.ltConn == null || this.ltConn.checkSegment(this.currentDocId, srcSeg, trgSeg, tu) <= 0) continue;
            for (Issue issue : this.ltConn.getIssues()) {
                this.reportIssue(issue.issueType, tu, issue.segId, issue.message, issue.srcStart, issue.srcEnd, issue.trgStart, issue.trgEnd, issue.severity, srcSeg.toString(), trgSeg.toString(), null);
                if (issue.srcEnd != -99) continue;
                this.ltConn = null;
            }
        }
        for (Segment trgSeg : trgSegs) {
            Segment srcSeg = srcSegs.get(trgSeg.getId());
            if (srcSeg != null) continue;
            this.reportIssue(IssueType.EXTRA_TARGETSEG, tu, trgSeg.getId(), String.format("Extra target segment (id=%s).", trgSeg.getId()), 0, -1, 0, -1, 2, "", trgSeg.toString(), null);
        }
        String srcOri = null;
        srcOri = srcCont.contentIsOneSegment() ? srcCont.toString() : srcCont.getUnSegmentedContentCopy().toText();
        String trgOri = null;
        trgOri = trgCont.contentIsOneSegment() ? trgCont.toString() : trgCont.getUnSegmentedContentCopy().toText();
        if (this.params.getCorruptedCharacters()) {
            this.checkCorruptedCharacters(srcOri, trgOri, tu);
        }
        this.checkWhiteSpaces(srcOri, trgOri, tu);
        if (this.params.getCheckCharacters()) {
            this.checkCharacters(srcOri, trgOri, tu);
        }
    }

    private void checkCharacters(String srcOri, String trgOri, ITextUnit tu) {
        StringBuilder badChars = new StringBuilder();
        int pos = -1;
        int badChar = 0;
        int count = 0;
        for (int i = 0; i < trgOri.length(); ++i) {
            Matcher m;
            char ch = trgOri.charAt(i);
            if (this.encoder1 == null ? this.extraCharsAllowed != null && (m = this.extraCharsAllowed.matcher(trgOri.subSequence(i, i + 1))).find() : this.encoder1.canEncode(ch) || this.extraCharsAllowed != null && (m = this.extraCharsAllowed.matcher(trgOri.subSequence(i, i + 1))).find()) continue;
            if (++count > 1) {
                if (badChars.indexOf(String.valueOf(ch)) != -1) continue;
                badChars.append(ch);
                continue;
            }
            pos = i;
            badChar = ch;
        }
        if (pos > -1) {
            if (count > 1) {
                this.reportIssue(IssueType.ALLOWED_CHARACTERS, tu, null, String.format("The character '%c' (U+%04X) is not allowed in the target text. Other forbidden characters found: ", badChar, badChar) + badChars.toString(), 0, -1, pos, pos + 1, 1, srcOri, trgOri, null);
            } else {
                this.reportIssue(IssueType.ALLOWED_CHARACTERS, tu, null, String.format("The character '%c' (U+%04X) is not allowed in the target text.", badChar, badChar), 0, -1, pos, pos + 1, 1, srcOri, trgOri, null);
            }
        }
    }

    private ArrayList<Code> stripNoiseCodes(Segment seg) {
        ArrayList<Code> list = new ArrayList<Code>(seg.text.getCodes());
        Iterator<Code> iter = list.iterator();
        while (iter.hasNext()) {
            Code code = iter.next();
            if (this.params.getTypesToIgnore().indexOf(code.getType() + ";") == -1) continue;
            iter.remove();
        }
        return list;
    }

    private String buildCodeList(List<Code> list) {
        StringBuilder tmp = new StringBuilder();
        for (Code code : list) {
            if (tmp.length() > 0) {
                tmp.append(", ");
            }
            if (code.getData().isEmpty()) {
                tmp.append(code.getOuterData().replaceAll("></x>", "/>"));
                continue;
            }
            tmp.append("\"" + code.getData() + "\"");
        }
        return tmp.toString();
    }

    private void checkInlineCodes(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        Iterator<Code> iter;
        ArrayList<Code> srcList = this.stripNoiseCodes(srcSeg);
        ArrayList<Code> trgList = this.stripNoiseCodes(trgSeg);
        if (srcList.size() == 0 && trgList.size() == 0) {
            return;
        }
        String srcOC = this.buildOpenCloseSequence(srcList);
        String trgOC = this.buildOpenCloseSequence(trgList);
        boolean checkOC = true;
        Iterator<Code> srcIter = srcList.iterator();
        block0: while (srcIter.hasNext()) {
            Code srcCode = srcIter.next();
            Iterator<Code> trgIter = trgList.iterator();
            while (trgIter.hasNext()) {
                Code trgCode = trgIter.next();
                if (trgCode.getData().isEmpty() && srcCode.getData().isEmpty()) {
                    if (trgCode.getId() != srcCode.getId() || !trgCode.getType().equals(srcCode.getType())) continue;
                    trgIter.remove();
                    srcIter.remove();
                    continue block0;
                }
                if (!trgCode.getData().equals(srcCode.getData())) continue;
                trgIter.remove();
                srcIter.remove();
                continue block0;
            }
        }
        if (!srcList.isEmpty()) {
            iter = srcList.iterator();
            while (iter.hasNext()) {
                if (!this.params.missingCodesAllowed.contains(iter.next().getData())) continue;
                iter.remove();
            }
        }
        if (!srcList.isEmpty()) {
            this.reportIssue(IssueType.MISSING_CODE, tu, srcSeg.getId(), "Missing codes in the target: " + this.buildCodeList(srcList), 0, -1, 0, -1, 1, srcSeg.toString(), trgSeg.toString(), srcList);
            checkOC = false;
        }
        if (!trgList.isEmpty()) {
            iter = trgList.iterator();
            while (iter.hasNext()) {
                if (!this.params.extraCodesAllowed.contains(iter.next().getData())) continue;
                iter.remove();
            }
        }
        if (!trgList.isEmpty()) {
            this.reportIssue(IssueType.EXTRA_CODE, tu, srcSeg.getId(), "Extra codes in the target: " + this.buildCodeList(trgList), 0, -1, 0, -1, 1, srcSeg.toString(), trgSeg.toString(), trgList);
            checkOC = false;
        }
        if (checkOC) {
            int j = 0;
            boolean done = false;
            for (int i = 0; i < srcOC.length(); ++i) {
                block16: {
                    if (srcOC.charAt(i) == 'p') continue;
                    while (true) {
                        if (trgOC.length() <= j) {
                            this.reportIssue(IssueType.SUSPECT_CODE, tu, srcSeg.getId(), "Suspect sequence of opening and closing target codes.", 0, -1, 0, -1, 1, srcSeg.toString(), trgSeg.toString(), trgList);
                            done = true;
                            break block16;
                        }
                        if (trgOC.charAt(j) != 'p') break;
                        ++j;
                    }
                    if (trgOC.charAt(j) != srcOC.charAt(i)) {
                        this.reportIssue(IssueType.SUSPECT_CODE, tu, srcSeg.getId(), String.format("Suspect sequence of opening and closing codes in the target (code %d).", i + 1), 0, -1, 0, -1, 1, srcSeg.toString(), trgSeg.toString(), trgList);
                        done = true;
                    } else {
                        ++j;
                    }
                }
                if (done) break;
            }
        }
    }

    private String buildOpenCloseSequence(ArrayList<Code> list) {
        StringBuilder sb = new StringBuilder();
        for (Code code : list) {
            switch (code.getTagType()) {
                case OPENING: {
                    sb.append("o");
                    break;
                }
                case CLOSING: {
                    sb.append("c");
                    break;
                }
                case PLACEHOLDER: {
                    String tmp = code.getData();
                    int ch = 112;
                    if (!Util.isEmpty(tmp) && this.params.getGuessOpenClose()) {
                        if (tmp.startsWith("</")) {
                            ch = 99;
                        } else if (tmp.startsWith("<")) {
                            ch = 111;
                        }
                        if (tmp.endsWith("/>")) {
                            ch = 112;
                        }
                    }
                    sb.append((char)ch);
                }
            }
        }
        return sb.toString();
    }

    private void checkCorruptedCharacters(String srcOri, String trgOri, ITextUnit tu) {
        Matcher m = this.corruption.matcher(trgOri);
        if (m.find()) {
            this.reportIssue(IssueType.SUSPECT_PATTERN, tu, null, String.format("Possible corrupted characters in the target (for example: \"%s\").", m.group()), 0, -1, m.start(), m.end(), 2, srcOri, trgOri, null);
        }
    }

    private boolean isSpaceWeCareAbout(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    private void checkWhiteSpaces(String srcOri, String trgOri, ITextUnit tu) {
        if (this.params.getLeadingWS()) {
            int i;
            for (i = 0; i < srcOri.length() && this.isSpaceWeCareAbout(srcOri.charAt(i)); ++i) {
                if (srcOri.length() > i) {
                    if (trgOri.charAt(i) == srcOri.charAt(i)) continue;
                    this.reportIssue(IssueType.MISSINGORDIFF_LEADINGWS, tu, null, String.format("Missing or different leading white space at position %d.", i), i, i + 1, 0, -1, 0, srcOri, trgOri, null);
                    break;
                }
                this.reportIssue(IssueType.MISSING_LEADINGWS, tu, null, String.format("Missing leading white space at position %d.", i), i, i + 1, 0, -1, 0, srcOri, trgOri, null);
            }
            for (i = 0; i < trgOri.length() && this.isSpaceWeCareAbout(trgOri.charAt(i)); ++i) {
                if (srcOri.length() > i) {
                    if (srcOri.charAt(i) == trgOri.charAt(i)) continue;
                    this.reportIssue(IssueType.EXTRAORDIFF_LEADINGWS, tu, null, String.format("Extra or different leading white space at position %d.", i), 0, -1, i, i + 1, 0, srcOri, trgOri, null);
                    break;
                }
                this.reportIssue(IssueType.EXTRA_LEADINGWS, tu, null, String.format("Extra leading white space at position %d.", i), 0, -1, i, i + 1, 0, srcOri, trgOri, null);
            }
        }
        if (this.params.getTrailingWS()) {
            int i;
            int j = trgOri.length() - 1;
            for (i = srcOri.length() - 1; i >= 0 && this.isSpaceWeCareAbout(srcOri.charAt(i)); --i) {
                if (j >= 0) {
                    if (trgOri.charAt(j) != srcOri.charAt(i)) {
                        this.reportIssue(IssueType.MISSINGORDIFF_TRAILINGWS, tu, null, String.format("Missing or different trailing white space at position %d", i), i, i + 1, 0, -1, 0, srcOri, trgOri, null);
                        break;
                    }
                } else {
                    this.reportIssue(IssueType.MISSING_TRAILINGWS, tu, null, String.format("Missing trailing white space at position %d.", i), i, i + 1, 0, -1, 0, srcOri, trgOri, null);
                }
                --j;
            }
            j = srcOri.length() - 1;
            for (i = trgOri.length() - 1; i >= 0 && this.isSpaceWeCareAbout(trgOri.charAt(i)); --i) {
                if (j >= 0) {
                    if (srcOri.charAt(j) != trgOri.charAt(i)) {
                        this.reportIssue(IssueType.EXTRAORDIFF_TRAILINGWS, tu, null, String.format("Extra or different trailing white space at position %d.", i), 0, -1, i, i + 1, 0, srcOri, trgOri, null);
                        break;
                    }
                } else {
                    this.reportIssue(IssueType.EXTRA_TRAILINGWS, tu, null, String.format("Extra white trailing space at position %d.", i), 0, -1, i, i + 1, 0, srcOri, trgOri, null);
                }
                --j;
            }
        }
    }

    private void checkLengths(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        double d;
        int n;
        int srcLen = TextUnitUtil.getText(srcSeg.text, null).length();
        int trgLen = TextUnitUtil.getText(trgSeg.text, null).length();
        if (this.params.getCheckAbsoluteMaxCharLength() && trgLen > this.params.getAbsoluteMaxCharLength()) {
            n = trgLen - this.params.getAbsoluteMaxCharLength();
            this.reportIssue(IssueType.TARGET_LENGTH, tu, srcSeg.getId(), String.format("The target is longer than %d (by %d).", this.params.getAbsoluteMaxCharLength(), n), 0, -1, this.params.getAbsoluteMaxCharLength(), trgLen, 2, srcSeg.toString(), trgSeg.toString(), null);
        }
        if (this.params.getCheckMaxCharLength()) {
            if (srcLen <= this.params.getMaxCharLengthBreak()) {
                n = srcLen == 0 ? 0 : srcLen * this.params.getMaxCharLengthBelow() / 100;
            } else {
                int n2 = n = srcLen == 0 ? 0 : srcLen * this.params.getMaxCharLengthAbove() / 100;
            }
            if (trgLen > n) {
                d = (double)trgLen / (srcLen == 0 ? 1.0 : (double)srcLen) * 100.0;
                this.reportIssue(IssueType.TARGET_LENGTH, tu, srcSeg.getId(), String.format("The target is suspiciously longer than its source (%.2f%% of the source).", d), 0, -1, 0, -1, 0, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
        if (this.params.getCheckMinCharLength()) {
            if (srcLen <= this.params.getMinCharLengthBreak()) {
                n = srcLen == 0 ? 0 : srcLen * this.params.getMinCharLengthBelow() / 100;
            } else {
                int n3 = n = srcLen == 0 ? 0 : srcLen * this.params.getMinCharLengthAbove() / 100;
            }
            if (trgSeg.text.getCodedText().length() < n) {
                d = (double)trgLen / (srcLen == 0 ? 1.0 : (double)srcLen) * 100.0;
                this.reportIssue(IssueType.TARGET_LENGTH, tu, srcSeg.getId(), String.format("The target is suspiciously shorter than its source (%.2f%% of the source).", d), 0, -1, 0, -1, 0, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
    }

    private void checkStorageSize(ITextUnit tu, TextContainer tc, boolean isSource) {
        if (tc == null) {
            return;
        }
        if (tu.hasProperty("its-storageSize")) {
            try {
                TextFragment tf;
                String tmp;
                ByteBuffer buf;
                int len;
                String[] values = tu.getProperty("its-storageSize").getValue().split("\t", -1);
                if (values[0].isEmpty()) {
                    return;
                }
                int max = Integer.parseInt(values[0]);
                if (this.encoder2 == null || !this.encoder2.charset().name().equals(values[1])) {
                    this.encoder2 = Charset.forName(values[1]).newEncoder();
                }
                if ((len = (buf = this.encoder2.encode(CharBuffer.wrap(tmp = TextUnitUtil.getText(tf = tc.contentIsOneSegment() ? tc.getFirstContent() : tc.getUnSegmentedContentCopy())))).limit()) > max) {
                    this.reportIssue(isSource ? IssueType.SOURCE_LENGTH : IssueType.TARGET_LENGTH, tu, null, String.format("Number of bytes in the %s (using %s) is: %d. Number allowed: %d.", isSource ? "source" : "target", values[1], len, max), 0, -1, 0, -1, 2, isSource ? tc.toString() : "N/A", isSource ? "N/A" : tc.toString(), null);
                }
            }
            catch (Throwable e) {
                this.reportIssue(isSource ? IssueType.SOURCE_LENGTH : IssueType.TARGET_LENGTH, tu, null, "Problem when trying use use ITS storage size property: " + e.getMessage(), 0, -1, 0, -1, 2, isSource ? tc.toString() : "N/A", isSource ? "N/A" : tc.toString(), null);
            }
        }
    }

    private void checkSuspectPatterns(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        String trgCText = trgSeg.text.getCodedText();
        if (this.params.getDoubledWord()) {
            Matcher m = this.patDoubledWords.matcher(trgCText);
            while (m.find()) {
                if (this.doubledWordExceptions.indexOf(";" + m.group(1).toLowerCase() + ";") != -1) continue;
                this.reportIssue(IssueType.SUSPECT_PATTERN, tu, srcSeg.getId(), String.format("Double word: \"%s\" found in the target.", m.group()), 0, -1, QualityChecker.fromFragmentToString(trgSeg.text, m.start()), QualityChecker.fromFragmentToString(trgSeg.text, m.end()), 2, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
    }

    private void checkPatterns(Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        String msg;
        boolean expectSame;
        boolean found;
        int end;
        int start;
        String srcCText = srcSeg.text.getCodedText();
        for (PatternItem item : this.patterns) {
            if (!item.enabled || !item.fromSource) continue;
            Matcher srcM = item.getSourcePattern().matcher(srcCText);
            StringBuilder trgCTextCopy = new StringBuilder(trgSeg.text.getCodedText());
            int from = 0;
            while (srcM.find(from)) {
                String srcPart = srcCText.substring(srcM.start(), srcM.end());
                start = 0;
                end = 0;
                found = false;
                expectSame = item.target.equals("<same>");
                if (expectSame) {
                    start = trgCTextCopy.indexOf(srcPart);
                    found = start != -1;
                    end = start + srcPart.length();
                } else {
                    Matcher trgM = item.getTargetPattern().matcher(trgCTextCopy);
                    found = trgM.find();
                    if (found) {
                        start = trgM.start();
                        end = trgM.end();
                    }
                }
                if (found) {
                    trgCTextCopy.delete(start, end);
                } else {
                    msg = expectSame ? String.format("The source part \"%s\" is not in the target", srcPart) : String.format("The source part \"%s\" has no correspondance in the target", srcPart);
                    if (!Util.isEmpty(item.description)) {
                        msg = msg + " (from rule: " + item.description + ").";
                    }
                    this.reportIssue(IssueType.UNEXPECTED_PATTERN, tu, srcSeg.getId(), msg, QualityChecker.fromFragmentToString(srcSeg.text, srcM.start()), QualityChecker.fromFragmentToString(srcSeg.text, srcM.end()), 0, -1, item.severity, srcSeg.toString(), trgSeg.toString(), null);
                }
                from = srcM.end();
            }
        }
        String trgCText = trgSeg.text.getCodedText();
        for (PatternItem item : this.patterns) {
            if (!item.enabled || item.fromSource) continue;
            Matcher trgM = item.getTargetPattern().matcher(trgCText);
            StringBuilder srcCTextCopy = new StringBuilder(srcSeg.text.getCodedText());
            while (trgM.find()) {
                String trgPart = trgCText.substring(trgM.start(), trgM.end());
                found = false;
                expectSame = item.source.equals("<same>");
                if (expectSame) {
                    start = srcCTextCopy.indexOf(trgPart);
                    found = start != -1;
                    end = start + trgPart.length();
                } else {
                    Matcher srcM = item.getSourcePattern().matcher(srcCTextCopy);
                    found = srcM.find();
                    start = srcM.start();
                    end = srcM.end();
                }
                if (found) {
                    srcCTextCopy.delete(start, end);
                    continue;
                }
                msg = expectSame ? String.format("The target part \"%s\" is not in the source.", trgPart) : String.format("The target part \"%s\" has no correspondance in the source.", trgPart);
                this.reportIssue(IssueType.UNEXPECTED_PATTERN, tu, srcSeg.getId(), msg, 0, -1, QualityChecker.fromFragmentToString(trgSeg.text, trgM.start()), QualityChecker.fromFragmentToString(trgSeg.text, trgM.end()), item.severity, srcSeg.toString(), trgSeg.toString(), null);
            }
        }
    }

    private void reportIssue(IssueType issueType, ITextUnit tu, String segId, String message, int srcStart, int srcEnd, int trgStart, int trgEnd, int severity, String srcOri, String trgOri, Object extra) {
        Issue issue = new Issue(this.currentDocId, issueType, tu.getId(), segId, message, srcStart, srcEnd, trgStart, trgEnd, severity, tu.getName());
        issue.extra = extra;
        this.issues.add(issue);
        issue.enabled = true;
        issue.oriSource = srcOri;
        issue.oriTarget = trgOri;
        if (this.sigList != null) {
            issue.enabled = !this.sigList.contains(issue.getSignature());
        }
    }

    public static int fromFragmentToString(TextFragment frag, int pos) {
        if (!frag.hasCode()) {
            return pos;
        }
        int len = 0;
        String text = frag.getCodedText();
        for (int i = 0; i < text.length(); ++i) {
            if (i >= pos) {
                return len;
            }
            if (TextFragment.isMarker(text.charAt(i))) {
                Code code = frag.getCode(text.charAt(++i));
                len += code.getData().length();
                continue;
            }
            ++len;
        }
        return len;
    }
}

