/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff.Res;
import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.IAMarker;
import org.oasisopen.xliff.v2.IMarker;
import org.oasisopen.xliff.v2.MarkerType;

public class AMarker
implements IAMarker {
    private static final long serialVersionUID = 64L;
    public static final String TYPE_GENERIC = "generic";
    private MarkerType markerType;
    private String internalId;
    private String id;
    private String type;
    private String value;
    private String ref;
    private String translate;

    public AMarker(String id, boolean opening, String type) {
        if (id == null) {
            throw new RuntimeException(Res.t("idCantBeNull"));
        }
        this.id = id;
        this.markerType = opening ? MarkerType.OPENING : MarkerType.CLOSING;
        this.setType(type);
    }

    public AMarker(String id, boolean opening, String type, String value) {
        if (id == null) {
            throw new RuntimeException(Res.t("idCantBeNull"));
        }
        this.id = id;
        this.markerType = opening ? MarkerType.OPENING : MarkerType.CLOSING;
        this.setType(type);
        this.setValue(value);
    }

    @Override
    public AMarker deepCopy() {
        AMarker copy = new AMarker(this.id, this.markerType == MarkerType.OPENING, this.type, this.value);
        copy.setRef(this.ref);
        copy.setTranslate(this.translate);
        copy.internalId = this.internalId;
        return copy;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type == null ? TYPE_GENERIC : type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInternalId() {
        return this.internalId;
    }

    @Override
    public MarkerType getMarkerType() {
        return this.markerType;
    }

    @Override
    public void setMarkerType(MarkerType markerType) {
        if (markerType == MarkerType.PLACEHOLDER) {
            throw new InvalidParameterException("The marker type of an annotation cannot ba place-holder.");
        }
        this.markerType = markerType;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getTranslate() {
        return this.translate;
    }

    @Override
    public void setTranslate(String translate) {
        if (translate != null && !translate.equals("yes") && !translate.equals("no")) {
            throw new InvalidParameterException(String.format("Invalid value '%s' (must be 'yes' or 'no')", translate));
        }
        this.translate = translate;
    }

    @Override
    public boolean equals(IMarker marker) {
        if (marker == null) {
            throw new NullPointerException("The parameter of Code.equals() must not be null.");
        }
        if (this == marker) {
            return true;
        }
        if (!(marker instanceof IAMarker)) {
            return false;
        }
        IAMarker anno = (IAMarker)marker;
        if (Util.compareAllowingNull(this.type, anno.getType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.id, anno.getId()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.ref, anno.getRef()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.value, anno.getValue()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.internalId, anno.getInternalId()) != 0) {
            return false;
        }
        return this.translate == anno.getTranslate();
    }

    @Override
    public boolean isAnnotation() {
        return true;
    }

    @Override
    public boolean isCode() {
        return false;
    }

    @Override
    public String getPrefixInType() {
        int p = this.type.indexOf(58);
        if (p == -1) {
            return "";
        }
        return this.type.substring(0, p);
    }

    @Override
    public String getValueInType() {
        int p = this.type.indexOf(58);
        if (p == -1) {
            return this.type;
        }
        return this.type.substring(p + 1);
    }
}

