/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff.DocumentData;
import net.sf.okapi.lib.xliff.GroupData;
import net.sf.okapi.lib.xliff.NSContext;
import net.sf.okapi.lib.xliff.Res;
import net.sf.okapi.lib.xliff.SectionData;
import net.sf.okapi.lib.xliff.SkeletonData;
import net.sf.okapi.lib.xliff.Util;
import net.sf.okapi.lib.xliff.XLIFFEvent;
import net.sf.okapi.lib.xliff.XLIFFWriterException;
import org.oasisopen.xliff.v2.Directionality;
import org.oasisopen.xliff.v2.ICandidate;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IExtendedAttribute;
import org.oasisopen.xliff.v2.IExtendedAttributes;
import org.oasisopen.xliff.v2.IExtendedChild;
import org.oasisopen.xliff.v2.IExtendedContent;
import org.oasisopen.xliff.v2.IExtendedElement;
import org.oasisopen.xliff.v2.IFragment;
import org.oasisopen.xliff.v2.IGlossEntry;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IPart;
import org.oasisopen.xliff.v2.ISegment;
import org.oasisopen.xliff.v2.IUnit;
import org.oasisopen.xliff.v2.IWithCandidates;
import org.oasisopen.xliff.v2.IWithCustomProperties;
import org.oasisopen.xliff.v2.IWithExtendedElements;
import org.oasisopen.xliff.v2.IWithGlossary;
import org.oasisopen.xliff.v2.IWithNotes;
import org.oasisopen.xliff.v2.OriginalDataStyle;

public class XLIFFWriter {
    private PrintWriter writer = null;
    private String lb = System.getProperty("line.separator");
    private boolean useIndentation = false;
    private boolean useInsignificantParts = false;
    private boolean indentNonUnit = this.useIndentation && !this.useInsignificantParts;
    private String indent;
    private String nonUnitLb;
    private boolean inDocument;
    private boolean inFile;
    private SectionData fileData;
    private OriginalDataStyle style = OriginalDataStyle.OUTSIDE;
    private String sourceLang;
    private String targetLang;
    private Stack<NSContext> nsStack;

    public void create(File file, String sourceLang, String targetLang) {
        try {
            String path = file.getCanonicalPath();
            int n = path.lastIndexOf(92);
            if (n == -1) {
                path.lastIndexOf(47);
            }
            if (n > -1) {
                File dir = new File(path.substring(0, n));
                dir.mkdirs();
            }
            this.create(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"), sourceLang, targetLang);
        }
        catch (FileNotFoundException e) {
            throw new XLIFFWriterException(Res.t("cantCreateDocument"), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XLIFFWriterException("Unsupported encoding.", e);
        }
        catch (IOException e) {
            throw new XLIFFWriterException(Res.t("cantCreateDocument"), e);
        }
    }

    public void create(File file, String sourceLang) {
        this.create(file, sourceLang, null);
    }

    public void create(Writer output, String sourceLang, String targetLang) {
        this.sourceLang = sourceLang;
        this.targetLang = targetLang;
        this.writer = new PrintWriter(output);
        this.indent = "";
        this.nonUnitLb = this.useInsignificantParts ? "" : this.lb;
        this.inFile = false;
        this.inDocument = false;
        this.nsStack = new Stack();
        NSContext ctx = new NSContext();
        ctx.put("xlf", "urn:oasis:names:tc:xliff:document:2.0");
        this.nsStack.push(ctx);
    }

    public void create(Writer output, String sourceLang) {
        this.create(output, sourceLang, null);
    }

    public void setInlineStyle(OriginalDataStyle style) {
        this.style = style;
    }

    public OriginalDataStyle getInlineStyle() {
        return this.style;
    }

    public void setLineBreak(String lineBreak) {
        this.lb = lineBreak;
        this.nonUnitLb = this.useInsignificantParts ? "" : this.lb;
    }

    public String getLineBreak() {
        return this.lb;
    }

    public void setUseIndentation(boolean useIndentation) {
        this.useIndentation = useIndentation;
        this.indentNonUnit = useIndentation && !this.useInsignificantParts;
        this.nonUnitLb = this.useInsignificantParts ? "" : this.lb;
    }

    public void setUseInsignificantParts(boolean useInsignificantParts) {
        this.useInsignificantParts = useInsignificantParts;
        this.indentNonUnit = this.useIndentation && !useInsignificantParts;
        this.nonUnitLb = useInsignificantParts ? "" : this.lb;
    }

    public void close() {
        if (this.writer != null) {
            if (this.inDocument) {
                this.writeEndDocument();
            }
            this.writer.close();
            this.writer = null;
        }
    }

    public void writeEvent(XLIFFEvent event) {
        switch (event.getType()) {
            case START_XLIFF: {
                DocumentData dd = event.getDocumentData();
                this.sourceLang = dd.getSourceLanguage();
                this.targetLang = dd.getTargetLanguage();
                this.writeStartDocument(dd, null);
                break;
            }
            case START_SECTION: {
                this.writeStartFile(event.getSectionData());
                break;
            }
            case SKELETON: {
                this.writeSkeleton(event.getSkeletonData());
                break;
            }
            case START_GROUP: {
                this.writeStartGroup(event.getGroupData());
                break;
            }
            case TEXT_UNIT: {
                this.writeUnit(event.getUnit());
                break;
            }
            case END_GROUP: {
                this.writeEndGroup();
                break;
            }
            case END_SECTION: {
                this.writeEndFile();
                break;
            }
            case END_XLIFF: {
                this.writeEndDocument();
                break;
            }
            case INSIGNIFICANT_PART: {
                if (!this.useInsignificantParts) break;
                this.writeText(event.getInsingnificantPartData().getData());
            }
        }
    }

    private void writeText(String text) {
        this.writer.print(text.replace("\n", this.lb));
    }

    public void writeUnit(IUnit unit) {
        if (unit.getPartCount() == 0) {
            return;
        }
        if (!this.inFile) {
            this.writeStartFile(null);
        }
        this.writer.print(this.indent + String.format("<unit id=\"%s\"", Util.toXML(unit.getId(), true)));
        this.writeDirectionality("srcDir", unit.getSourceDir(true), this.fileData.getSourceDir());
        this.writeDirectionality("trgDir", unit.getTargetDir(true), this.fileData.getTargetDir());
        this.writeExtendedAttributes(unit.getExtendedAttributes());
        this.writer.print(">" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (IPart part : unit) {
            ISegment seg = null;
            if (part.isSegment()) {
                seg = (ISegment)part;
                this.writer.print(this.indent + "<" + "segment");
                if (seg.getId() != null) {
                    this.writer.print(" id=\"" + seg.getId() + "\"");
                }
                if (!seg.getTranslate()) {
                    this.writer.print(" translate=\"no\"");
                }
                if (seg.getApproved()) {
                    this.writer.print(" approved=\"yes\"");
                }
            } else {
                this.writer.print(this.indent + "<" + "ignorable");
            }
            this.writeExtendedAttributes(part.getExtendedAttributes());
            this.writer.print(">" + this.lb);
            if (this.useIndentation) {
                this.indent = this.indent + " ";
            }
            this.writeFragment("source", part.getSource(), 0, unit.getSourceDir(true));
            if (part.hasTarget()) {
                this.writeFragment("target", part.getTarget(true), part.getTargetOrder(), unit.getTargetDir(true));
            }
            if (seg != null) {
                this.writeNotes(seg);
                this.writeCandidates(seg);
            }
            this.writeCustomProperties(part, true);
            if (this.useIndentation) {
                this.indent = this.indent.substring(1);
            }
            if (seg != null) {
                this.writer.print(this.indent + "</segment>" + this.lb);
                continue;
            }
            this.writer.print(this.indent + "</ignorable>" + this.lb);
        }
        this.writeNotes(unit);
        this.writeCandidates(unit);
        if (this.style == OriginalDataStyle.OUTSIDE) {
            this.writeOriginalData(unit.getDataStore());
        }
        this.writeGlossary(unit);
        this.writeCustomProperties(unit, true);
        this.writeExtendedElements(unit);
        if (this.indentNonUnit) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</unit>" + this.nonUnitLb);
    }

    private void writeExtendedAttributes(IExtendedAttributes attributes) {
        if (attributes == null) {
            return;
        }
        for (String namespaceURI : attributes.getNamespaces()) {
            this.writer.print(" xmlns:" + attributes.getNamespacePrefix(namespaceURI) + "=\"" + namespaceURI + "\"");
        }
        for (IExtendedAttribute att : attributes) {
            this.writer.print(" " + att.getPrefix() + ":" + att.getLocalPart() + "=\"" + Util.toXML(att.getValue(), true) + "\"");
        }
    }

    private void writeCandidates(IWithCandidates parent) {
        if (parent.getCandidates().size() == 0) {
            return;
        }
        this.writer.print(this.indent + "<" + "m:" + "matches>" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (ICandidate alt : parent.getCandidates()) {
            this.writer.print(this.indent + "<" + "m:" + "match");
            if (alt.getSimilarity() > -1) {
                this.writer.print(String.format(" similarity=\"%d\"", alt.getSimilarity()));
            }
            if (alt.getQuality() > -1) {
                this.writer.print(String.format(" quality=\"%d\"", alt.getQuality()));
            }
            this.writer.print(">" + this.lb);
            if (this.useIndentation) {
                this.indent = this.indent + " ";
            }
            this.writeFragment("source", alt.getSource(), -1, alt.getDataStore().getSourceDir());
            this.writeFragment("target", alt.getTarget(), -1, alt.getDataStore().getTargetDir());
            if (this.style == OriginalDataStyle.OUTSIDE) {
                this.writeOriginalData(alt.getDataStore());
            }
            if (this.useIndentation) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print(this.indent + "</" + "m:" + "match>" + this.lb);
        }
        if (this.useIndentation) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "m:" + "matches>" + this.lb);
    }

    private void writeGlossary(IWithGlossary parent) {
        if (!parent.hasGlossary()) {
            return;
        }
        boolean doIndent = parent instanceof IUnit ? this.useIndentation : this.indentNonUnit;
        String localLb = parent instanceof IUnit ? this.lb : this.nonUnitLb;
        this.writer.print(this.indent + "<" + "g:" + "glossary xmlns:" + "g" + "=\"" + "urn:oasis:names:tc:xliff:glossary:2.0" + "\">" + localLb);
        if (doIndent) {
            this.indent = this.indent + " ";
        }
        for (IGlossEntry entry : parent.getGlossaryEntries()) {
            if (Util.isNullOrEmpty(entry.getTerm()) || Util.isNullOrEmpty(entry.getTranslation()) && Util.isNullOrEmpty(entry.getDefinition())) continue;
            this.writer.print(this.indent + "<" + "g:" + "glossEntry>" + localLb);
            if (doIndent) {
                this.indent = this.indent + " ";
            }
            this.writer.print(this.indent + "<" + "g:" + "term>" + Util.toXML(entry.getTerm(), false) + "</" + "g:" + "term>" + localLb);
            if (!Util.isNullOrEmpty(entry.getTranslation())) {
                this.writer.print(this.indent + "<" + "g:" + "translation>" + Util.toXML(entry.getTranslation(), false) + "</" + "g:" + "translation>" + localLb);
            }
            if (!Util.isNullOrEmpty(entry.getDefinition())) {
                this.writer.print(this.indent + "<" + "g:" + "definition>" + Util.toXML(entry.getDefinition(), false) + "</" + "g:" + "definition>" + localLb);
            }
            if (doIndent) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print(this.indent + "</" + "g:" + "glossEntry>" + localLb);
        }
        if (doIndent) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "g:" + "glossary>" + localLb);
    }

    private void writeCustomProperties(IWithCustomProperties parent, boolean inOrIsUnit) {
        if (!parent.hasCustomProperties()) {
            return;
        }
        boolean doIndent = inOrIsUnit ? this.useIndentation : this.indentNonUnit;
        String localLb = inOrIsUnit ? this.lb : this.nonUnitLb;
        this.writer.print(this.indent + "<" + "p:" + "metadata xmlns:" + "p" + "=\"" + "urn:oasis:names:tc:xliff:metadata:2.0" + "\">" + localLb);
        if (doIndent) {
            this.indent = this.indent + " ";
        }
        for (Map.Entry<String, String> entry : parent.getCustomProperties().entrySet()) {
            this.writer.print(this.indent + "<" + "p:" + "meta type=\"" + Util.toXML(entry.getKey(), true) + "\">");
            this.writer.print(Util.toXML(entry.getValue(), false));
            this.writer.print(this.indent + "</" + "p:" + "meta>" + localLb);
        }
        if (doIndent) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "p:" + "metadata>" + localLb);
    }

    private void writeNotes(IWithNotes parent) {
        if (parent.getNoteCount() == 0) {
            return;
        }
        this.writer.print(this.indent + "<notes>" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (INote note : parent.getNotes()) {
            this.writer.print(this.indent + "<note");
            if (!Util.isNullOrEmpty(note.getId())) {
                this.writer.print(" id=\"" + Util.toXML(note.getId(), true) + "\"");
            }
            switch (note.getAppliesTo()) {
                case SOURCE: {
                    this.writer.print(" appliesTo=\"source\"");
                    break;
                }
                case TARGET: {
                    this.writer.print(" appliesTo=\"target\"");
                    break;
                }
            }
            this.writer.print(">" + Util.toXML(note.getText(), false));
            this.writer.print("</note>" + this.lb);
        }
        if (this.useIndentation) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</notes>" + this.lb);
    }

    private void writeExtendedElements(IWithExtendedElements parent) {
        if (!parent.hasExtendedElements()) {
            return;
        }
        for (IExtendedElement elem : parent.getExtendedElements()) {
            this.writeExtendedElement(elem);
        }
    }

    private void writeExtendedElement(IExtendedElement element) {
        QName qn = element.getQName();
        this.writer.print("<" + qn.getPrefix() + ":" + qn.getLocalPart());
        this.writeExtendedAttributes(element.getAttributes());
        this.writer.print(">");
        for (IExtendedChild child : element.getChildren()) {
            switch (child.getType()) {
                case ELEMENT: {
                    this.writeExtendedElement((IExtendedElement)child);
                    break;
                }
                case TEXT: {
                    this.writer.print(Util.toXML(((IExtendedContent)child).getText(), false));
                    break;
                }
                case CDATA: {
                    this.writer.print("<![CDATA[" + ((IExtendedContent)child).getText() + "]]>");
                }
            }
        }
        this.writer.print("</" + qn.getPrefix() + ":" + qn.getLocalPart() + ">");
    }

    public void writeStartDocument(DocumentData docData, String comment) {
        if (docData == null) {
            docData = new DocumentData("2.0");
        }
        this.writer.print("<?xml version=\"1.0\"?>" + this.lb);
        this.writer.print("<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"" + docData.getVersion() + "\"");
        this.writer.print(" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\"");
        this.writer.print(String.format(" %s=\"%s\"", "srcLang", this.sourceLang));
        if (!Util.isNullOrEmpty(this.targetLang)) {
            this.writer.print(String.format(" %s=\"%s\"", "tgtLang", this.targetLang));
        }
        this.writeExtendedAttributes(docData.getExtendedAttributes());
        this.writer.print(">" + this.nonUnitLb);
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
        this.inDocument = true;
        if (!Util.isNullOrEmpty(comment)) {
            this.writer.print(this.indent + "<!-- " + Util.toXML(comment, false) + "-->" + this.nonUnitLb);
        }
    }

    public void writeEndDocument() {
        if (this.inFile) {
            this.writeEndFile();
        }
        if (this.inDocument) {
            if (this.indentNonUnit) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print("</xliff>" + this.nonUnitLb);
            this.inDocument = false;
        }
    }

    public void writeStartFile(SectionData secData) {
        if (!this.inDocument) {
            this.writeStartDocument(null, null);
        }
        this.fileData = secData == null ? new SectionData("secData") : secData;
        this.writer.print(this.indent + String.format("<%s", "file"));
        if (!Util.isNullOrEmpty(this.fileData.getSkeleton())) {
            this.writer.print(" skeleton=\"" + Util.toXML(this.fileData.getSkeleton(), true) + "\"");
        }
        this.writeDirectionality("srcDir", this.fileData.getSourceDir(), Directionality.LTR);
        this.writeDirectionality("trgDir", this.fileData.getTargetDir(), Directionality.LTR);
        this.writeExtendedAttributes(this.fileData.getExtendedAttributes());
        this.writer.print(">" + this.nonUnitLb);
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
        this.inFile = true;
    }

    public void writeSkeleton(SkeletonData skelData) {
        if (!this.inFile) {
            this.writeStartFile(null);
        }
        if (skelData.getChildren().isEmpty() && !skelData.hasExtendedAttribute()) {
            return;
        }
        if (!Util.isNullOrEmpty(this.fileData.getSkeleton())) {
            throw new XLIFFWriterException("Cannot write <skeleton> element: There is already a skeleton attribute.");
        }
        this.writer.print(this.indent + "<" + "skeleton" + ">");
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
        for (IExtendedChild child : skelData.getChildren()) {
            switch (child.getType()) {
                case ELEMENT: {
                    this.writeExtendedElement((IExtendedElement)child);
                    break;
                }
                case TEXT: {
                    this.writer.print(Util.toXML(((IExtendedContent)child).getText(), false));
                    break;
                }
                case CDATA: {
                    this.writer.print("<![CDATA[" + ((IExtendedContent)child).getText() + "]]>");
                }
            }
        }
        if (this.indentNonUnit) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "skeleton" + ">" + this.nonUnitLb);
    }

    public void writeEndFile() {
        if (this.inFile) {
            if (this.indentNonUnit) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print(this.indent + "</file>" + this.nonUnitLb);
            this.inFile = false;
        }
    }

    public void writeStartGroup(GroupData groupData) {
        if (!this.inFile) {
            this.writeStartFile(null);
        }
        this.writer.print(this.indent + "<" + "group");
        if (groupData != null) {
            this.writer.print(String.format(" %s=\"%s\"", "id", groupData.getId()));
        }
        this.writer.print(">" + this.nonUnitLb);
        if (this.indentNonUnit) {
            this.indent = this.indent + " ";
        }
    }

    public void writeEndGroup() {
        if (this.indentNonUnit) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "group" + ">" + this.nonUnitLb);
    }

    private void writeFragment(String name, IFragment fragment, int order, Directionality inheritedDir) {
        if (order > 0) {
            this.writer.print(this.indent + String.format("<%s order=\"%d\"", name, order));
        } else {
            this.writer.print(this.indent + "<" + name);
        }
        this.writeDirectionality("dir", fragment.getDir(true), inheritedDir);
        this.writer.print(">" + fragment.toXLIFF(this.style));
        this.writer.print("</" + name + ">" + this.lb);
    }

    private void writeOriginalData(IDataStore store) {
        if (!store.hasCodeWithOriginalData()) {
            return;
        }
        Map<String, String> map = store.getOutsideRepresentationMap();
        this.writer.print(this.indent + "<" + "originalData" + ">" + this.lb);
        if (this.useIndentation) {
            this.indent = this.indent + " ";
        }
        for (String originalData : map.keySet()) {
            String id = map.get(originalData);
            this.writer.print(this.indent + String.format("<%s %s=\"%s\">", "data", "id", id));
            this.writer.print(Util.toSafeXML(originalData));
            this.writer.print("</data>" + this.lb);
        }
        if (this.useIndentation) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "originalData" + ">" + this.lb);
        store.setOutsideRepresentationMap(map);
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsStack.peek();
    }

    private void writeDirectionality(String name, Directionality value, Directionality context) {
        if (value == context) {
            return;
        }
        this.writer.print(String.format(" %s=\"%s\"", name, value == Directionality.LTR ? "ltr" : "rtl"));
    }
}

