/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.util.Iterator;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextUnitUtil;

public class ConvertSegmentsToTextUnitsStep
extends BasePipelineStep {
    @Override
    public String getName() {
        return "Segments to TextUnits Converter";
    }

    @Override
    public String getDescription() {
        return "Convert each aligned segment pair (for all target locales) to its own complete TextUnit";
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu == null || tu.isEmpty() || !TextUnitUtil.isStandalone(tu)) {
            return event;
        }
        LinkedList<Event> textUnitEvents = new LinkedList<Event>();
        IAlignedSegments alignedSegments = tu.getAlignedSegments();
        for (LocaleId variantTrgLoc : tu.getTargetLocales()) {
            Iterator<Segment> variantSegments = alignedSegments.iterator(variantTrgLoc);
            while (variantSegments.hasNext()) {
                int segCount = 0;
                Segment srcSeg = variantSegments.next();
                for (LocaleId l : tu.getTargetLocales()) {
                    Segment trgSeg = alignedSegments.getCorrespondingTarget(srcSeg, l);
                    if (trgSeg == null) continue;
                    ITextUnit segmentTu = tu.clone();
                    segmentTu.setId(segmentTu.getId() + ":" + Integer.toString(++segCount));
                    segmentTu.setSourceContent(srcSeg.text);
                    segmentTu.setTargetContent(l, trgSeg.text);
                    textUnitEvents.add(new Event(EventType.TEXT_UNIT, segmentTu));
                }
            }
        }
        return new Event(EventType.MULTI_EVENT, new MultiEvent(textUnitEvents));
    }
}

