/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String REMOVE_LEADING_TRAILING_CODES = "removeLeadingTrailingCodes";
    private boolean removeLeadingTrailingCodes;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.removeLeadingTrailingCodes = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.removeLeadingTrailingCodes = this.buffer.getBoolean(REMOVE_LEADING_TRAILING_CODES, this.removeLeadingTrailingCodes);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(REMOVE_LEADING_TRAILING_CODES, this.removeLeadingTrailingCodes);
        return this.buffer.toString();
    }

    public void setRemoveLeadingTrailingCodes(boolean removeLeadingTrailingCodes) {
        this.removeLeadingTrailingCodes = removeLeadingTrailingCodes;
    }

    public boolean getRemoveLeadingTrailingCodes() {
        return this.removeLeadingTrailingCodes;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(REMOVE_LEADING_TRAILING_CODES, "Remove leading and trailing codes", "Removes leading and trailing codes from the source and place them in the skeleton.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Inline Codes Simplifier", true, false);
        desc.addCheckboxPart(paramsDesc.get(REMOVE_LEADING_TRAILING_CODES));
        return desc;
    }
}

