/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.msbatchtranslation;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SeparatorPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import net.sf.okapi.common.uidescription.TextLabelPart;

@EditorFor(value=SubmissionParameters.class)
public class SubmissionParameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String CLIENTID = "clientId";
    private static final String SECRET = "secret";
    private static final String CATEGORY = "category";
    private static final String BATCHSIZE = "batchSize";
    private static final String RATING = "rating";
    private String clientId;
    private String secret;
    private String category;
    private int batchSize;
    private int rating;

    public SubmissionParameters() {
        this.reset();
        this.toString();
    }

    public SubmissionParameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.clientId = this.buffer.getEncodedString(CLIENTID, this.clientId);
        this.secret = this.buffer.getEncodedString(SECRET, this.secret);
        this.category = this.buffer.getEncodedString(CATEGORY, this.category);
        this.batchSize = this.buffer.getInteger(BATCHSIZE, this.batchSize);
        this.rating = this.buffer.getInteger(RATING, this.rating);
    }

    @Override
    public void reset() {
        this.clientId = "";
        this.secret = "";
        this.category = "";
        this.batchSize = 80;
        this.rating = 4;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setEncodedString(CLIENTID, this.clientId);
        this.buffer.setEncodedString(SECRET, this.secret);
        this.buffer.setEncodedString(CATEGORY, this.category);
        this.buffer.setInteger(BATCHSIZE, this.batchSize);
        this.buffer.setInteger(RATING, this.rating);
        return this.buffer.toString();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getCategory() {
        return this.category;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CLIENTID, "Client ID", "Client ID in Microsoft Azure Marketplace");
        desc.add(SECRET, "Client Secret", "Client Secret from Microsoft Azure Marketplace");
        desc.add(CATEGORY, "Category", "Category code if accessing a trained system");
        desc.add(BATCHSIZE, "Batch size", "Number of segments to send in each batch");
        desc.add(RATING, "Default rating", "Default rating to use for if one is not provided with the translated segment");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft Batch Submission Settings");
        TextLabelPart tlp = desc.addTextLabelPart("Powered by Microsoft\u00ae Translator");
        tlp.setVertical(true);
        SeparatorPart sp = desc.addSeparatorPart();
        sp.setVertical(true);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(CLIENTID));
        tip.setPassword(false);
        tip = desc.addTextInputPart(paramsDesc.get(SECRET));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        tip.setPassword(false);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(RATING));
        sip.setRange(-10, 10);
        sip = desc.addSpinInputPart(paramsDesc.get(BATCHSIZE));
        sip.setRange(1, 100);
        return desc;
    }
}

