/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.common;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.DefaultFilenameFilter;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.IPackageWriter;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;

public abstract class BasePackageWriter
implements IPackageWriter {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected Parameters params;
    protected Manifest manifest;
    protected int docId;
    protected String extractionType;
    protected ISkeletonWriter skelWriter;
    protected boolean supporstOneOutputPerInput = true;
    protected String inputRootDir;
    protected String rootDir;
    protected TMXWriter tmxWriterApproved;
    protected String tmxPathApproved;
    protected String tempTmxPathApproved;
    protected TMXWriter tmxWriterUnApproved;
    protected String tmxPathUnApproved;
    protected String tempTmxPathUnApproved;
    protected TMXWriter tmxWriterAlternates;
    protected String tmxPathAlternates;
    protected String tempTmxPathAlternates;
    protected TMXWriter tmxWriterLeverage;
    protected String tmxPathLeverage;
    protected String tempTmxPathLeverage;
    protected boolean copiedTargetsLikeApproved = false;
    protected boolean useLetterCodes = false;
    protected boolean zeroBasedLetterCodes = true;

    public BasePackageWriter(String extractionType) {
        this.extractionType = extractionType;
        this.manifest = new Manifest();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setBatchInformation(String packageRoot, LocaleId srcLoc, LocaleId trgLoc, String inputRootDir, String rootDir, String packageId, String projectId, String creatorParams, String tempPackageRoot) {
        this.inputRootDir = inputRootDir;
        this.rootDir = rootDir;
        this.manifest.setInformation(packageRoot, srcLoc, trgLoc, inputRootDir, packageId, projectId, creatorParams, tempPackageRoot);
    }

    public String getMainOutputPath() {
        return this.manifest.getPath();
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.processStartBatch();
                break;
            }
            case END_BATCH: {
                this.processEndBatch();
                break;
            }
            case START_BATCH_ITEM: {
                this.processStartBatchItem();
                break;
            }
            case RAW_DOCUMENT: {
                this.processRawDocument(event);
                break;
            }
            case END_BATCH_ITEM: {
                this.processEndBatchItem();
                break;
            }
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                event = this.processEndDocument(event);
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument(event);
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event);
                break;
            }
            case END_GROUP: {
                this.processEndGroup(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
            }
        }
        if (this.supporstOneOutputPerInput && this.params.getSendOutput()) {
            switch (event.getEventType()) {
                case START_DOCUMENT: 
                case START_SUBDOCUMENT: 
                case END_SUBDOCUMENT: 
                case START_GROUP: 
                case END_GROUP: 
                case TEXT_UNIT: 
                case DOCUMENT_PART: {
                    return Event.NOOP_EVENT;
                }
                case END_DOCUMENT: {
                    return event;
                }
            }
            return event;
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        throw new UnsupportedOperationException("Use setDocumentInformation instead.");
    }

    @Override
    public void setOutput(String path) {
        throw new UnsupportedOperationException("Use setDocumentInformation instead.");
    }

    @Override
    public void setOutput(OutputStream output) {
        throw new UnsupportedOperationException("Output to stream not supported for now");
    }

    protected void processStartBatch() {
        this.docId = 0;
        this.initializeTMXWriters();
        this.copySupportMaterial();
    }

    protected void setTMXInfo(boolean generate, String pathApproved, boolean useLetterCodes, boolean zerobasedletterCodes) {
        this.useLetterCodes = useLetterCodes;
        this.zeroBasedLetterCodes = zerobasedletterCodes;
        if (!generate) {
            this.tmxPathApproved = null;
            this.tmxPathUnApproved = null;
            this.tmxPathAlternates = null;
            this.tmxPathLeverage = null;
            return;
        }
        if (pathApproved == null) {
            if (this.tmxPathApproved == null) {
                this.tmxPathApproved = this.manifest.getTempTmDirectory() + "approved.tmx";
                this.tempTmxPathApproved = this.manifest.getTempTmDirectory() + "approved.tmx";
            }
        } else {
            this.tmxPathApproved = pathApproved;
            this.tempTmxPathApproved = pathApproved;
        }
        if (this.tmxPathUnApproved == null) {
            this.tmxPathUnApproved = this.manifest.getTempTmDirectory() + "unapproved.tmx";
            this.tempTmxPathUnApproved = this.manifest.getTempTmDirectory() + "unapproved.tmx";
        }
        if (this.tmxPathAlternates == null) {
            this.tmxPathAlternates = this.manifest.getTempTmDirectory() + "alternates.tmx";
            this.tempTmxPathAlternates = this.manifest.getTempTmDirectory() + "alternates.tmx";
        }
        if (this.tmxPathLeverage == null) {
            this.tmxPathLeverage = this.manifest.getTempTmDirectory() + "leverage.tmx";
            this.tempTmxPathLeverage = this.manifest.getTempTmDirectory() + "leverage.tmx";
        }
    }

    protected void initializeTMXWriters() {
        if (this.tmxPathApproved != null) {
            this.tmxWriterApproved = new TMXWriter(this.tempTmxPathApproved);
            this.tmxWriterApproved.setLetterCodedMode(this.useLetterCodes, this.zeroBasedLetterCodes);
            this.tmxWriterApproved.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
        if (this.tmxPathUnApproved != null) {
            this.tmxWriterUnApproved = new TMXWriter(this.tempTmxPathUnApproved);
            this.tmxWriterUnApproved.setLetterCodedMode(this.useLetterCodes, this.zeroBasedLetterCodes);
            this.tmxWriterUnApproved.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
        if (this.tmxPathAlternates != null) {
            this.tmxWriterAlternates = new TMXWriter(this.tempTmxPathAlternates);
            this.tmxWriterAlternates.setLetterCodedMode(this.useLetterCodes, this.zeroBasedLetterCodes);
            this.tmxWriterAlternates.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
        if (this.tmxPathLeverage != null) {
            this.tmxWriterLeverage = new TMXWriter(this.tempTmxPathLeverage);
            this.tmxWriterLeverage.setLetterCodedMode(this.useLetterCodes, this.zeroBasedLetterCodes);
            this.tmxWriterLeverage.writeStartDocument(this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), this.getClass().getName(), null, null, null, null);
        }
    }

    protected void processEndBatch() {
        File file;
        if (this.params.getOutputManifest()) {
            this.manifest.save(this.manifest.getTempPackageRoot());
        }
        if (this.tmxWriterApproved != null) {
            this.tmxWriterApproved.writeEndDocument();
            this.tmxWriterApproved.close();
            if (this.tmxWriterApproved.getItemCount() == 0) {
                file = new File(this.tempTmxPathApproved);
                file.delete();
            }
        }
        if (this.tmxWriterUnApproved != null) {
            this.tmxWriterUnApproved.writeEndDocument();
            this.tmxWriterUnApproved.close();
            if (this.tmxWriterUnApproved.getItemCount() == 0) {
                file = new File(this.tempTmxPathUnApproved);
                file.delete();
            }
        }
        if (this.tmxWriterAlternates != null) {
            this.tmxWriterAlternates.writeEndDocument();
            this.tmxWriterAlternates.close();
            if (this.tmxWriterAlternates.getItemCount() == 0) {
                file = new File(this.tempTmxPathAlternates);
                file.delete();
            }
        }
        if (this.tmxWriterLeverage != null) {
            this.tmxWriterLeverage.writeEndDocument();
            this.tmxWriterLeverage.close();
            if (this.tmxWriterLeverage.getItemCount() == 0) {
                file = new File(this.tempTmxPathLeverage);
                file.delete();
            }
        }
    }

    protected void processStartBatchItem() {
    }

    protected void processEndBatchItem() {
    }

    protected void processRawDocument(Event event) {
        String ori = this.manifest.getTempOriginalDirectory();
        if (Util.isEmpty(ori)) {
            return;
        }
        MergingInfo info = this.manifest.getItem(this.docId);
        String inputPath = this.manifest.getInputRoot() + info.getRelativeInputPath();
        String outputPath = ori + info.getRelativeInputPath();
        Util.copyFile(inputPath, outputPath, false);
    }

    @Override
    public void setDocumentInformation(String relativeInputPath, String filterConfigId, String filterParameters, String inputEncoding, String relativeTargetPath, String targetEncoding, ISkeletonWriter skelWriter) {
        if (Util.isEmpty(filterConfigId)) {
            this.manifest.addDocument(++this.docId, "none", relativeInputPath, "", filterParameters, inputEncoding, relativeTargetPath, targetEncoding);
        } else {
            this.skelWriter = skelWriter;
            String[] res = FilterConfigurationMapper.splitFilterFromConfiguration(filterConfigId);
            this.manifest.addDocument(++this.docId, this.extractionType, relativeInputPath, res[0], filterParameters, inputEncoding, relativeTargetPath, targetEncoding);
        }
    }

    protected void processStartDocument(Event event) {
        String ori = this.manifest.getTempOriginalDirectory();
        if (Util.isEmpty(ori)) {
            return;
        }
        MergingInfo info = this.manifest.getItem(this.docId);
        String inputPath = this.manifest.getInputRoot() + info.getRelativeInputPath();
        String outputPath = ori + info.getRelativeInputPath();
        Util.copyFile(inputPath, outputPath, false);
    }

    protected abstract Event processEndDocument(Event var1);

    protected void processStartSubDocument(Event event) {
    }

    protected void processEndSubDocument(Event event) {
    }

    protected void processStartGroup(Event event) {
    }

    protected void processEndGroup(Event event) {
    }

    protected void processDocumentPart(Event event) {
    }

    protected abstract void processTextUnit(Event var1);

    protected void writeTMXEntries(ITextUnit tu) {
        LocaleId trgLoc = this.manifest.getTargetLocale();
        TextContainer tc = tu.getTarget(trgLoc);
        if (tc == null) {
            return;
        }
        if (!tu.getSource().hasText(false)) {
            return;
        }
        boolean done = false;
        if (!tc.isEmpty()) {
            if (tu.hasTargetProperty(trgLoc, "approved") && tu.getTargetProperty(trgLoc, "approved").getValue().equals("yes") && this.tmxWriterApproved != null) {
                this.tmxWriterApproved.writeItem(tu, null);
                done = true;
            }
            if (!done && tu.getSource().compareTo(tc, true) != 0 && this.tmxWriterUnApproved != null) {
                this.tmxWriterUnApproved.writeItem(tu, null);
                done = true;
            }
        }
        ISegments srcSegs = tu.getSource().getSegments();
        for (Segment seg : tc.getSegments()) {
            Segment srcSeg = srcSegs.get(seg.id);
            if (srcSeg == null) continue;
            this.writeAltTranslations(seg.getAnnotation(AltTranslationsAnnotation.class), srcSeg.text);
        }
        TextFragment srcOriginal = tu.getSource().contentIsOneSegment() ? tu.getSource().getFirstContent() : tu.getSource().getUnSegmentedContentCopy();
        this.writeAltTranslations(tc.getAnnotation(AltTranslationsAnnotation.class), srcOriginal);
    }

    private void writeAltTranslations(AltTranslationsAnnotation ann, TextFragment srcOriginal) {
        if (ann == null) {
            return;
        }
        for (AltTranslation alt : ann) {
            if (alt.getFromOriginal()) {
                if (this.tmxWriterAlternates == null) continue;
                this.tmxWriterAlternates.writeAlternate(alt, srcOriginal);
                continue;
            }
            if (this.tmxWriterLeverage == null) continue;
            this.tmxWriterLeverage.writeAlternate(alt, srcOriginal);
        }
    }

    @Override
    public void setSupporstOneOutputPerInput(boolean supporstOneOutputPerInput) {
        this.supporstOneOutputPerInput = supporstOneOutputPerInput;
    }

    protected Event creatRawDocumentEventSet(String inputPath, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc) {
        RawDocument rawDoc = new RawDocument(new File(inputPath).toURI(), defaultEncoding, srcLoc, trgLoc);
        ArrayList<Event> list = new ArrayList<Event>();
        PipelineParameters pp = new PipelineParameters();
        pp.setOutputURI(rawDoc.getInputURI());
        pp.setSourceLocale(rawDoc.getSourceLocale());
        pp.setTargetLocale(rawDoc.getTargetLocale());
        pp.setOutputEncoding(rawDoc.getEncoding());
        pp.setInputRawDocument(rawDoc);
        list.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
        list.add(new Event(EventType.RAW_DOCUMENT, rawDoc));
        return new Event(EventType.MULTI_EVENT, new MultiEvent(list));
    }

    protected void copySupportMaterial() {
        String data = this.params.getSupportFiles();
        if (Util.isEmpty(data)) {
            return;
        }
        List<String> list = this.params.convertSupportFilesToList(data);
        for (String item : list) {
            String origin;
            int n = item.indexOf(Parameters.SUPPORTFILEDEST_SEP);
            String destination = "";
            if (n == -1) {
                origin = item;
            } else {
                origin = item.substring(0, n);
                destination = item.substring(n + 1);
            }
            if (destination.isEmpty()) {
                destination = "/" + Parameters.SUPPORTFILE_SAMENAME;
            }
            destination = LocaleId.replaceVariables(destination, this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
            origin = Util.fillRootDirectoryVariable(origin, this.rootDir);
            origin = Util.fillInputRootDirectoryVariable(origin, this.inputRootDir);
            origin = LocaleId.replaceVariables(origin, this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
            String pattern = Util.getFilename(origin, true);
            String origDir = Util.getDirectoryName(origin);
            File dir = new File(Util.getDirectoryName(origin));
            File[] files = dir.listFiles(new DefaultFilenameFilter(pattern, false));
            if (files == null) {
                this.logger.warning(String.format("Invalid list of files for '%s'", origin));
                continue;
            }
            for (File file : files) {
                String origFn = Util.getFilename(file.getAbsolutePath(), true);
                String destFn = Util.getFilename(destination, true);
                if (destFn.equalsIgnoreCase(Parameters.SUPPORTFILE_SAMENAME)) {
                    destFn = origFn;
                }
                String destDir = Util.getDirectoryName(destination);
                String destPath = this.manifest.getTempPackageRoot() + (destDir.isEmpty() ? "" : destDir + "/") + destFn;
                Util.copyFile(origDir + "/" + origFn, destPath, false);
            }
        }
    }
}

