/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xmlanalysis;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static String OUTPUTPATH = "outputPath";
    private static String AUTOOPEN = "autoOpen";
    private String outputPath;
    private boolean autoOpen;

    public Parameters() {
        this.reset();
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean getAutoOpen() {
        return this.autoOpen;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    @Override
    public void reset() {
        this.outputPath = "analysis.html";
        this.autoOpen = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.outputPath = this.buffer.getString(OUTPUTPATH, this.outputPath);
        this.autoOpen = this.buffer.getBoolean(AUTOOPEN, this.autoOpen);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(OUTPUTPATH, this.outputPath);
        this.buffer.setParameter(AUTOOPEN, this.autoOpen);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(OUTPUTPATH, "Path of the result file", "Full path of the result file.");
        desc.add(AUTOOPEN, "Open the result file after completion", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("XML Analysis", true, false);
        PathInputPart part = desc.addPathInputPart(paramDesc.get(OUTPUTPATH), "Result File", true);
        part.setBrowseFilters("Text Files (*.txt)\tAll Files (*.*)", "*.txt\t*.*");
        desc.addCheckboxPart(paramDesc.get(AUTOOPEN));
        return desc;
    }
}

