/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializers;
import org.codehaus.jackson.map.deser.CollectionDeserializer;
import org.codehaus.jackson.map.deser.CreatorContainer;
import org.codehaus.jackson.map.deser.EnumDeserializer;
import org.codehaus.jackson.map.deser.EnumMapDeserializer;
import org.codehaus.jackson.map.deser.EnumResolver;
import org.codehaus.jackson.map.deser.EnumSetDeserializer;
import org.codehaus.jackson.map.deser.JsonNodeDeserializer;
import org.codehaus.jackson.map.deser.MapDeserializer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.StdDeserializers;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicDeserializerFactory
extends DeserializerFactory {
    static final JavaType TYPE_STRING = TypeFactory.type(String.class);
    static final HashMap<JavaType, JsonDeserializer<Object>> _simpleDeserializers = StdDeserializers.constructAll();
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    static final HashMap<JavaType, JsonDeserializer<Object>> _arrayDeserializers;

    protected BasicDeserializerFactory() {
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationConfig config, ArrayType type, DeserializerProvider p) throws JsonMappingException {
        JavaType elemType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)elemType.getHandler();
        if (contentDeser == null) {
            JsonDeserializer<Object> deser = _arrayDeserializers.get(elemType);
            if (deser != null) {
                return deser;
            }
            if (elemType.isPrimitive()) {
                throw new IllegalArgumentException("Internal error: primitive type (" + type + ") passed, no array deserializer found");
            }
            contentDeser = p.findValueDeserializer(config, elemType, type, null);
        }
        return new ArrayDeserializer(type, contentDeser);
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationConfig config, CollectionType type, DeserializerProvider p) throws JsonMappingException {
        Class<Object> collectionClass = type.getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectClassAnnotations(collectionClass);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config, beanDesc.getClassInfo());
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type);
        JavaType contentType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)contentType.getHandler();
        if (contentDeser == null) {
            if (EnumSet.class.isAssignableFrom(collectionClass)) {
                return new EnumSetDeserializer(EnumResolver.constructUnsafe(contentType.getRawClass(), config.getAnnotationIntrospector()));
            }
            contentDeser = p.findValueDeserializer(config, contentType, type, null);
        }
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type);
            }
            collectionClass = fallback;
        }
        return new CollectionDeserializer(collectionClass, contentDeser);
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationConfig config, MapType type, DeserializerProvider p) throws JsonMappingException {
        Class<Object> mapClass = type.getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectForCreation(mapClass);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config, beanDesc.getClassInfo());
        if (deser != null) {
            return deser;
        }
        type = this.modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type);
        JavaType keyType = type.getKeyType();
        JavaType contentType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer<Object>)contentType.getHandler();
        if (contentDeser == null) {
            contentDeser = p.findValueDeserializer(config, contentType, type, null);
        }
        if (EnumMap.class.isAssignableFrom(mapClass)) {
            return new EnumMapDeserializer(EnumResolver.constructUnsafe(keyType.getRawClass(), config.getAnnotationIntrospector()), contentDeser);
        }
        KeyDeserializer keyDes = (KeyDeserializer)keyType.getHandler();
        if (keyDes == null) {
            KeyDeserializer keyDeserializer = keyDes = TYPE_STRING.equals(keyType) ? null : p.findKeyDeserializer(config, keyType);
        }
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Map> fallback = _mapFallbacks.get(mapClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + type);
            }
            mapClass = fallback;
            beanDesc = (BasicBeanDescription)config.introspectForCreation(mapClass);
        }
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        Constructor<Map<Object, Object>> defaultCtor = beanDesc.findDefaultConstructor();
        if (defaultCtor != null && fixAccess) {
            ClassUtil.checkAndFixAccess(defaultCtor);
        }
        MapDeserializer md = new MapDeserializer(type, defaultCtor, keyDes, contentDeser);
        md.setIgnorableProperties(config.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()));
        md.setCreators(this.findMapCreators(config, beanDesc));
        md.validateCreators();
        return md;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationConfig config, Class<?> enumClass, DeserializerProvider p) throws JsonMappingException {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectClassAnnotations(enumClass);
        JsonDeserializer<Object> des = this.findDeserializerFromAnnotation(config, beanDesc.getClassInfo());
        if (des != null) {
            return des;
        }
        EnumDeserializer d2 = new EnumDeserializer(EnumResolver.constructUnsafe(enumClass, config.getAnnotationIntrospector()));
        return d2;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig config, Class<? extends JsonNode> nodeClass, DeserializerProvider p) throws JsonMappingException {
        return JsonNodeDeserializer.getDeserializer(nodeClass);
    }

    @Override
    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config, JavaType type, DeserializerProvider p) throws JsonMappingException {
        return _simpleDeserializers.get(type);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationConfig config, Annotated a) {
        Object deserDef = config.getAnnotationIntrospector().findDeserializer(a);
        if (deserDef != null) {
            return this._constructDeserializer(config, deserDef);
        }
        return null;
    }

    JsonDeserializer<Object> _constructDeserializer(DeserializationConfig config, Object deserDef) {
        if (deserDef instanceof JsonDeserializer) {
            return (JsonDeserializer)deserDef;
        }
        if (!(deserDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
        }
        Class cls = (Class)deserDef;
        if (!JsonDeserializer.class.isAssignableFrom(cls)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + cls.getName() + "; expected Class<JsonDeserializer>");
        }
        return (JsonDeserializer)ClassUtil.createInstance(cls, config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS));
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(DeserializationConfig config, Annotated a, T type) throws JsonMappingException {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        Class<?> subclass = intr.findDeserializationType(a);
        if (subclass != null) {
            try {
                type = type.narrowBy(subclass);
            }
            catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type + " with concrete-type annotation (value " + subclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage(), null, iae);
            }
        }
        if (type.isContainerType()) {
            Class<?> cc;
            Class<?> keyClass = intr.findDeserializationKeyType(a);
            if (keyClass != null) {
                if (!(type instanceof MapType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + type + " is not a Map type");
                }
                try {
                    type = ((MapType)type).narrowKey(keyClass);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
            if ((cc = intr.findDeserializationContentType(a)) != null) {
                try {
                    type = type.narrowContentsBy(cc);
                }
                catch (IllegalArgumentException iae) {
                    throw new JsonMappingException("Failed to narrow content type " + type + " with content-type annotation (" + cc.getName() + "): " + iae.getMessage(), null, iae);
                }
            }
        }
        return type;
    }

    protected JavaType resolveType(DeserializationConfig config, BasicBeanDescription beanDesc, Type rawType, Annotated a) {
        JavaType type = TypeFactory.type(rawType, beanDesc.getType());
        if (type.isContainerType()) {
            Class<? extends JsonDeserializer<?>> cdClass;
            Class<? extends KeyDeserializer> kdClass;
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            boolean canForceAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
            JavaType keyType = type.getKeyType();
            if (keyType != null && (kdClass = intr.findKeyDeserializer(a)) != null && kdClass != KeyDeserializer.None.class) {
                KeyDeserializer kd = ClassUtil.createInstance(kdClass, canForceAccess);
                keyType.setHandler(kd);
            }
            if ((cdClass = intr.findContentDeserializer(a)) != null && cdClass != JsonDeserializer.None.class) {
                JsonDeserializer<?> cd = ClassUtil.createInstance(cdClass, canForceAccess);
                type.getContentType().setHandler(cd);
            }
        }
        return type;
    }

    CreatorContainer findMapCreators(DeserializationConfig config, BasicBeanDescription beanDesc) throws JsonMappingException {
        String name;
        AnnotatedParameter param;
        int i;
        int nameCount;
        SettableBeanProperty[] properties;
        int argCount;
        Class<?> mapClass = beanDesc.getBeanClass();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        CreatorContainer creators = new CreatorContainer(mapClass, fixAccess);
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            argCount = ctor.getParameterCount();
            if (argCount < 1 || !intr.hasCreatorAnnotation(ctor)) continue;
            properties = new SettableBeanProperty[argCount];
            nameCount = 0;
            for (i = 0; i < argCount; ++i) {
                param = ctor.getParameter(i);
                String string = name = param == null ? null : intr.findPropertyNameForParam(param);
                if (name == null || name.length() == 0) {
                    throw new IllegalArgumentException("Parameter #" + i + " of constructor " + ctor + " has no property name annotation: must have for @JsonCreator for a Map type");
                }
                ++nameCount;
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param);
            }
            creators.addPropertyConstructor(ctor, properties);
        }
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            argCount = factory.getParameterCount();
            if (argCount < 1 || !intr.hasCreatorAnnotation(factory)) continue;
            properties = new SettableBeanProperty[argCount];
            nameCount = 0;
            for (i = 0; i < argCount; ++i) {
                param = factory.getParameter(i);
                String string = name = param == null ? null : intr.findPropertyNameForParam(param);
                if (name == null || name.length() == 0) {
                    throw new IllegalArgumentException("Parameter #" + i + " of factory method " + factory + " has no property name annotation: must have for @JsonCreator for a Map type");
                }
                ++nameCount;
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param);
            }
            creators.addPropertyFactory(factory, properties);
        }
        return creators;
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, int index, AnnotatedParameter param) throws JsonMappingException {
        JavaType type = this.resolveType(config, beanDesc, param.getParameterType(), param);
        JsonDeserializer<Object> deser = this.findDeserializerFromAnnotation(config, param);
        if (deser != null) {
            SettableBeanProperty.CreatorProperty prop = new SettableBeanProperty.CreatorProperty(name, type, beanDesc.getBeanClass(), index);
            prop.setValueDeserializer(deser);
            return prop;
        }
        type = this.modifyTypeByAnnotation(config, param, type);
        return new SettableBeanProperty.CreatorProperty(name, type, beanDesc.getBeanClass(), index);
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> value;
            Class<?> key = Class.forName("java.util.ConcurrentNavigableMap");
            Class<?> mapValue = value = Class.forName("java.util.ConcurrentSkipListMap");
            _mapFallbacks.put(key.getName(), mapValue);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
        _arrayDeserializers = ArrayDeserializers.getAll();
    }
}

