/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionType
extends JavaType {
    final JavaType _elementType;

    private CollectionType(Class<?> collT, JavaType elemT) {
        super(collT);
        this._elementType = elemT;
        this._hashCode += elemT.hashCode();
    }

    @Override
    protected JavaType _narrow(Class<?> subclass) {
        return new CollectionType(subclass, this._elementType);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> contentClass) {
        if (contentClass == this._elementType.getRawClass()) {
            return this;
        }
        JavaType newElementType = this._elementType.narrowBy(contentClass);
        return new CollectionType(this._class, newElementType);
    }

    public static CollectionType construct(Class<?> rawType, JavaType elemT) {
        return new CollectionType(rawType, elemT);
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public String toString() {
        return "[collection type; class " + this._class.getName() + ", contains " + this._elementType + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CollectionType other = (CollectionType)o;
        return this._class == other._class && this._elementType.equals(other._elementType);
    }
}

