/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.its.IProcessor;
import org.w3c.its.ITSException;
import org.w3c.its.ITSRule;
import org.w3c.its.ITSTrace;
import org.w3c.its.ITraversal;
import org.w3c.its.NSContextManager;
import org.w3c.its.VariableResolver;
import org.xml.sax.SAXException;

public class ITSEngine
implements IProcessor,
ITraversal {
    public static final String ITS_VERSION1 = "1.0";
    public static final String ITS_VERSION2 = "2.0";
    public static final String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_NS_PREFIX = "xml";
    public static final String ITS_NS_URI = "http://www.w3.org/2005/11/its";
    public static final String ITS_NS_PREFIX = "its";
    public static final String ITSX_NS_URI = "http://www.w3.org/2008/12/its-extensions";
    public static final String ITSX_NS_PREFIX = "itsx";
    public static final String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    public static final String XLINK_NS_PREFIX = "xlink";
    private static final String FLAGNAME = "\u00ff";
    private static final String FLAGSEP = "\u001c";
    private static final String FLAGDEFAULTDATA = "????????????\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c";
    private static final int FP_TRANSLATE = 0;
    private static final int FP_DIRECTIONALITY = 1;
    private static final int FP_WITHINTEXT = 2;
    private static final int FP_TERMINOLOGY = 3;
    private static final int FP_LOCNOTE = 4;
    private static final int FP_PRESERVEWS = 5;
    private static final int FP_LANGINFO = 6;
    private static final int FP_DOMAIN = 7;
    private static final int FP_EXTERNALRES = 8;
    private static final int FP_LOCFILTER = 9;
    private static final int FP_LQISSUE = 10;
    private static final int FP_STORAGESIZE = 11;
    private static final int FP_TERMINOLOGY_DATA = 0;
    private static final int FP_LOCNOTE_DATA = 1;
    private static final int FP_LANGINFO_DATA = 2;
    private static final int FP_TARGETPOINTER_DATA = 3;
    private static final int FP_IDVALUE_DATA = 4;
    private static final int FP_DOMAIN_DATA = 5;
    private static final int FP_EXTERNALRES_DATA = 6;
    private static final int FP_LOCFILTER_DATA = 7;
    private static final int FP_LQISSUE_DATA = 8;
    private static final int FP_STORAGESIZE_DATA = 9;
    private static final int TERMINFOTYPE_POINTER = 1;
    private static final int TERMINFOTYPE_REF = 2;
    private static final int TERMINFOTYPE_REFPOINTER = 3;
    private static final int LOCNOTETYPE_TEXT = 1;
    private static final int LOCNOTETYPE_POINTER = 2;
    private static final int LOCNOTETYPE_REF = 3;
    private static final int LOCNOTETYPE_REFPOINTER = 4;
    private DocumentBuilderFactory fact;
    private Document doc;
    private URI docURI;
    private NSContextManager nsContext;
    private VariableResolver varResolver;
    private XPathFactory xpFact;
    private XPath xpath;
    private ArrayList<ITSRule> rules;
    private Node node;
    private boolean startTraversal;
    private Stack<ITSTrace> trace;
    private boolean backTracking;
    private boolean translatableAttributeRuleTriggered;
    private boolean targetPointerRuleTriggered;
    private String version;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ITSEngine(Document doc, URI docURI) {
        this.doc = doc;
        this.docURI = docURI;
        this.node = null;
        this.rules = new ArrayList();
        this.nsContext = new NSContextManager();
        this.nsContext.addNamespace(ITS_NS_PREFIX, ITS_NS_URI);
        this.varResolver = new VariableResolver();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.xpFact = XPathFactory.newInstance();
        this.xpath = this.xpFact.newXPath();
        this.xpath.setNamespaceContext(this.nsContext);
        this.xpath.setXPathVariableResolver(this.varResolver);
    }

    public boolean getTranslatableAttributeRuleTriggered() {
        return this.translatableAttributeRuleTriggered;
    }

    public boolean getTargetPointerRuleTriggered() {
        return this.targetPointerRuleTriggered;
    }

    public XPath getXPath() {
        return this.xpath;
    }

    @Override
    public void addExternalRules(URI docURI) {
        try {
            if (this.fact == null) {
                this.fact = DocumentBuilderFactory.newInstance();
                this.fact.setNamespaceAware(true);
                this.fact.setValidating(false);
            }
            Document rulesDoc = this.fact.newDocumentBuilder().parse(docURI.toString());
            this.addExternalRules(rulesDoc, docURI);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addExternalRules(Document rulesDoc, URI docURI) {
        this.compileRules(rulesDoc, docURI, false);
    }

    private void compileRules(Document rulesDoc, URI docURI, boolean isInternal) {
        try {
            XPathExpression expr = this.xpath.compile("//*[@selector]//namespace::*");
            NodeList nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                String prefix = nl.item(i).getLocalName();
                if (XML_NS_PREFIX.equals(prefix)) continue;
                String uri = nl.item(i).getNodeValue();
                this.nsContext.addNamespace(prefix, uri);
            }
            expr = this.xpath.compile("//its:rules");
            nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            if (nl.getLength() == 0) {
                return;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                NodeList nl2;
                Element rulesElem = (Element)nl.item(i);
                this.version = rulesElem.getAttributeNS(null, "version");
                if (!this.version.equals(ITS_VERSION1) && !this.version.equals(ITS_VERSION2)) {
                    throw new ITSException(String.format("Invalid or missing ITS version (\"%s\")", this.version));
                }
                String href = rulesElem.getAttributeNS(XLINK_NS_URI, "href");
                if (href.length() > 0) {
                    int n = href.lastIndexOf(35);
                    if (n > -1) {
                        href = href.substring(0, n);
                    }
                    String baseFolder = "";
                    if (docURI != null) {
                        baseFolder = this.getPartBeforeFile(docURI);
                    }
                    for (Node node = rulesElem; node != null; node = node.getParentNode()) {
                        String xmlBase;
                        if (node.getNodeType() != 1 || (xmlBase = node.getAttribute("xml:base")).length() <= 0) continue;
                        if (xmlBase.endsWith("/")) {
                            xmlBase = xmlBase.substring(0, xmlBase.length() - 1);
                        }
                        baseFolder = !baseFolder.startsWith("/") ? xmlBase + "/" + baseFolder : xmlBase + baseFolder;
                    }
                    if (baseFolder.length() > 0) {
                        if (baseFolder.endsWith("/")) {
                            baseFolder = baseFolder.substring(0, baseFolder.length() - 1);
                        }
                        href = !href.startsWith("/") ? baseFolder + "/" + href : baseFolder + href;
                    }
                    URI linkedDoc = new URI(href);
                    this.loadLinkedRules(linkedDoc, isInternal);
                }
                if ((nl2 = (NodeList)(expr = this.xpath.compile("//its:*")).evaluate(rulesElem, XPathConstants.NODESET)).getLength() != 0) {
                    for (int j = 0; j < nl2.getLength(); ++j) {
                        Element ruleElem = (Element)nl2.item(j);
                        String locName = ruleElem.getLocalName();
                        if ("translateRule".equals(locName)) {
                            this.compileTranslateRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("withinTextRule".equals(locName)) {
                            this.compileWithinTextRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("langRule".equals(locName)) {
                            this.compileLangRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("dirRule".equals(locName)) {
                            this.compileDirRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("locNoteRule".equals(locName)) {
                            this.compileLocNoteRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("termRule".equals(locName)) {
                            this.compileTermRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("idValueRule".equals(locName)) {
                            this.compileIdValueRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("domainRule".equals(locName)) {
                            this.compileDomainRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("targetPointerRule".equals(locName)) {
                            this.compileTargetPointerRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("localeFilterRule".equals(locName)) {
                            this.compileLocaleFilterRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("preserveSpaceRule".equals(locName)) {
                            this.compilePrserveSpaceRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("externalResourceRefRule".equals(locName)) {
                            this.compileExternalResourceRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("locQualityIssueRule".equals(locName)) {
                            this.compileLocQualityIssueRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("storageSizeRule".equals(locName)) {
                            this.compileStorageSizeRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("param".equals(locName)) {
                            this.processParam(ruleElem);
                            continue;
                        }
                        if ("rules".equals(locName) || "span".equals(locName) || "locQualityIssues".equals(locName) || "locQualityIssue".equals(locName)) continue;
                        this.logger.warning(String.format("Unknown element '%s'.", ruleElem.getNodeName()));
                    }
                    continue;
                }
                break;
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void processParam(Element elem) {
        String value = elem.getTextContent();
        String name = elem.getAttribute("name");
        if (name.isEmpty()) {
            throw new ITSException("Invalid value for 'name' in param.");
        }
        this.varResolver.add(new QName(name), value);
    }

    private String getPartBeforeFile(URI uri) {
        String tmp = uri.toString();
        int n = tmp.lastIndexOf(47);
        if (n == -1) {
            return uri.toString();
        }
        return tmp.substring(0, n + 1);
    }

    private void loadLinkedRules(URI docURI, boolean isInternal) {
        try {
            if (this.fact == null) {
                this.fact = DocumentBuilderFactory.newInstance();
                this.fact.setNamespaceAware(true);
                this.fact.setValidating(false);
            }
            Document rulesDoc = this.fact.newDocumentBuilder().parse(docURI.toString());
            this.compileRules(rulesDoc, docURI, isInternal);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void compileTranslateRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(2);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("translate");
        if ("yes".equals(value)) {
            rule.flag = true;
        } else if ("no".equals(value)) {
            rule.flag = false;
        } else {
            throw new ITSException("Invalid value for 'translate'.");
        }
        value = elem.getAttributeNS(ITSX_NS_URI, "idValue");
        if (!value.isEmpty()) {
            if (this.version.equals(ITS_VERSION2)) {
                this.logger.warning(String.format("This document uses the %s:idValue extension instead of the ITS 2.0 Id Value data category.", ITSX_NS_URI));
            }
            rule.idValue = value;
        }
        if (!(value = elem.getAttributeNS(ITSX_NS_URI, "whiteSpaces")).isEmpty()) {
            if (this.version.equals(ITS_VERSION2)) {
                this.logger.warning(String.format("This document uses the %s:whiteSpaces extension instead of the ITS 2.0 Preserve Space data category.", ITSX_NS_URI));
            }
            if ("preserve".equals(value)) {
                rule.preserveWS = true;
            } else if ("default".equals(value)) {
                rule.preserveWS = false;
            } else {
                throw new ITSException("Invalid value for 'whiteSpaces'.");
            }
        }
        this.rules.add(rule);
    }

    private void compileDirRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(32);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("dir");
        if ("ltr".equals(value)) {
            rule.value = 1;
        } else if ("rtl".equals(value)) {
            rule.value = 0;
        } else if ("lro".equals(value)) {
            rule.value = 3;
        } else if ("rlo".equals(value)) {
            rule.value = 2;
        } else {
            throw new ITSException("Invalid value for 'dir'.");
        }
        this.rules.add(rule);
    }

    private void compileWithinTextRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(4);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("withinText");
        if ("yes".equals(value)) {
            rule.value = 1;
        } else if ("no".equals(value)) {
            rule.value = 0;
        } else if ("nested".equals(value)) {
            rule.value = 2;
        } else {
            throw new ITSException("Invalid value for 'withinText'.");
        }
        this.rules.add(rule);
    }

    private void compileIdValueRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(128);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("idValue");
        if (value.isEmpty()) {
            throw new ITSException("Invalid value for 'idValue'.");
        }
        rule.idValue = value;
        this.rules.add(rule);
    }

    private void compileDomainRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(256);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("domainPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'domainPointer'.");
        }
        rule.info = pointer;
        rule.map = this.fromStringToMap(elem.getAttribute("domainMapping"));
        this.rules.add(rule);
    }

    private void compileExternalResourceRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(1024);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("externalResourceRefPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'externalResourceRefPointer'.");
        }
        rule.info = pointer;
        this.rules.add(rule);
    }

    private void compileStorageSizeRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(16384);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveStorageSizeData(elem, false);
        String storageSizeP = null;
        if (elem.hasAttribute("storageSizePointer")) {
            storageSizeP = elem.getAttribute("storageSizePointer");
        }
        String storageSizeEncodingP = null;
        if (elem.hasAttribute("storageSizeEncodingPointer")) {
            storageSizeEncodingP = elem.getAttribute("storageSizeEncodingPointer");
        }
        if (Util.isEmpty(np[0]) && Util.isEmpty(storageSizeP)) {
            throw new ITSException("You must have at least an attribute storageSize or storageSizePointer.");
        }
        rule.map = new HashMap<String, String>();
        if (!Util.isEmpty(np[0])) {
            if (!Util.isEmpty(storageSizeP)) {
                throw new ITSException("Cannot have both storageSize and storageSizePointer.");
            }
            rule.map.put("size", np[0]);
        } else {
            rule.map.put("sizePointer", storageSizeP);
        }
        if (!Util.isEmpty(np[1])) {
            if (!Util.isEmpty(storageSizeEncodingP)) {
                throw new ITSException("Cannot have both storageSizeEncoding and storageSizeEncodingPointer.");
            }
            rule.map.put("encoding", np[1]);
        } else {
            rule.map.put("encodingPointer", storageSizeEncodingP);
        }
        this.rules.add(rule);
    }

    private void compileLocQualityIssueRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(8192);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveLocQualityIssueData(elem, false);
        String issuesRefP = null;
        if (elem.hasAttribute("locQualityIssuesRefPointer")) {
            issuesRefP = elem.getAttribute("locQualityIssuesRefPointer");
        }
        String typeP = null;
        if (elem.hasAttribute("locQualityIssueTypePointer")) {
            typeP = elem.getAttribute("locQualityIssueTypePointer");
        }
        String commentP = null;
        if (elem.hasAttribute("locQualityIssueCommentPointer")) {
            commentP = elem.getAttribute("locQualityIssueCommentPointer");
        }
        if (Util.isEmpty(np[0]) && Util.isEmpty(issuesRefP) && Util.isEmpty(np[1]) && Util.isEmpty(typeP) && Util.isEmpty(np[2]) && Util.isEmpty(commentP)) {
            throw new ITSException("You must have at least a type or a comment or isses reference ainformation defined.");
        }
        rule.map = new HashMap<String, String>();
        if (!Util.isEmpty(np[0])) {
            if (!Util.isEmpty(issuesRefP)) {
                throw new ITSException("Cannot have both locQualityIssuesRef and locQualityIssuesRefPointer.");
            }
            rule.map.put("issuesRef", np[0]);
        } else {
            rule.map.put("issuesRefPointer", issuesRefP);
        }
        if (!Util.isEmpty(np[1])) {
            if (!Util.isEmpty(typeP)) {
                throw new ITSException("Cannot have both locQualityIssueType and locQualityIssueTypePointer.");
            }
            rule.map.put("type", np[1]);
        } else {
            rule.map.put("typePointer", typeP);
        }
        if (!Util.isEmpty(np[2])) {
            if (!Util.isEmpty(commentP)) {
                throw new ITSException("Cannot have both locQualityIssueComment and locQualityIssueCommentPointer.");
            }
            rule.map.put("comment", np[2]);
        } else {
            rule.map.put("commentPointer", commentP);
        }
        String scoreP = null;
        if (elem.hasAttribute("locQualityIssueScorePointer")) {
            scoreP = elem.getAttribute("locQualityIssueScorePointer");
        }
        if (!Util.isEmpty(np[3])) {
            if (!Util.isEmpty(scoreP)) {
                throw new ITSException("Cannot have both locQualityIssueScore and locQualityIssueScorePointer.");
            }
            rule.map.put("score", np[3]);
        } else {
            rule.map.put("scorePointer", scoreP);
        }
        String profileRefP = null;
        if (elem.hasAttribute("locQualityIssueProfileRefPointer")) {
            profileRefP = elem.getAttribute("locQualityIssueProfileRefPointer");
        }
        if (!Util.isEmpty(np[4])) {
            if (!Util.isEmpty(profileRefP)) {
                throw new ITSException("Cannot have both locQualityIssueProfileRef and locQualityIssueProfileRefPointer.");
            }
            rule.map.put("profileRef", np[4]);
        } else {
            rule.map.put("profileRefPointer", profileRefP);
        }
        this.rules.add(rule);
    }

    private void compileLocaleFilterRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(2048);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveLocaleFilterList(elem, false);
        this.rules.add(rule);
    }

    private void compilePrserveSpaceRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(4096);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("space");
        if (!"preserve".equals(value) && !"default".equals(value)) {
            throw new ITSException("Invalid value for 'space'.");
        }
        rule.preserveWS = "preserve".equals(value);
        this.rules.add(rule);
    }

    private void compileTargetPointerRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(512);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("targetPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'targetPointer'.");
        }
        rule.info = pointer;
        this.rules.add(rule);
    }

    private Map<String, String> fromStringToMap(String mapping) {
        if (mapping.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> map = null;
        if (!mapping.isEmpty()) {
            String[] pairs = mapping.split(",", 0);
            char endQuote = '\u0000';
            boolean state = false;
            for (String pair : pairs) {
                pair = pair.trim();
                StringBuilder left = new StringBuilder();
                StringBuilder right = new StringBuilder();
                StringBuilder str = left;
                block6: for (int i = 0; i < pair.length(); ++i) {
                    char ch = pair.charAt(i);
                    switch (ch) {
                        case '\"': {
                            if (!state) {
                                endQuote = ch;
                                state = true;
                                continue block6;
                            }
                            if (ch == endQuote) {
                                state = false;
                                continue block6;
                            }
                            str.append(ch);
                            continue block6;
                        }
                        case '\'': {
                            if (!state) {
                                endQuote = ch;
                                state = true;
                                continue block6;
                            }
                            if (ch == endQuote) {
                                state = false;
                                continue block6;
                            }
                            str.append(ch);
                            continue block6;
                        }
                        case ' ': {
                            if (state) {
                                str.append(' ');
                                continue block6;
                            }
                            str = right;
                            continue block6;
                        }
                        default: {
                            str.append(pair.charAt(i));
                        }
                    }
                }
                if (left.length() == 0 || right.length() == 0) {
                    throw new ITSException("Invalid pair in mapping value.");
                }
                if (map == null) {
                    map = new LinkedHashMap<String, String>();
                }
                map.put(left.toString(), right.toString());
            }
        }
        return map;
    }

    private void compileTermRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(16);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("term");
        if ("yes".equals(value)) {
            rule.flag = true;
        } else if ("no".equals(value)) {
            rule.flag = false;
        } else {
            throw new ITSException("Invalid value for 'term'.");
        }
        value = elem.getAttribute("termInfoPointer");
        String value2 = elem.getAttribute("termInfoRef");
        String value3 = elem.getAttribute("termInfoRefPointer");
        if (value.length() > 0) {
            rule.infoType = 1;
            rule.info = value;
            if (value2.length() > 0 || value3.length() > 0) {
                throw new ITSException("Too many termInfo attributes specified");
            }
        } else if (value2.length() > 0) {
            rule.infoType = 2;
            rule.info = value2;
            if (value3.length() > 0) {
                throw new ITSException("Too many termInfo attributes specified");
            }
        } else if (value3.length() > 0) {
            rule.infoType = 3;
            rule.info = value3;
        }
        this.rules.add(rule);
    }

    private void compileLocNoteRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(8);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String type = elem.getAttribute("locNoteType");
        if (type.length() == 0) {
            throw new ITSException("locNoteType attribute missing.");
        }
        String value1 = "";
        NodeList list = elem.getElementsByTagNameNS(ITS_NS_URI, "locNote");
        if (list.getLength() > 0) {
            value1 = ITSEngine.getTextContent(list.item(0));
        }
        String value2 = elem.getAttribute("locNotePointer");
        String value3 = elem.getAttribute("locNoteRef");
        String value4 = elem.getAttribute("locNoteRefPointer");
        if (value1.length() > 0) {
            rule.infoType = 1;
            rule.info = value1;
            if (value2.length() > 0 || value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value2.length() > 0) {
            rule.infoType = 2;
            rule.info = value2;
            if (value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value3.length() > 0) {
            rule.infoType = 3;
            rule.info = value3;
            if (value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value4.length() > 0) {
            rule.infoType = 4;
            rule.info = value4;
        }
        this.rules.add(rule);
    }

    private void compileLangRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(1);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = elem.getAttribute("langPointer");
        if (rule.info.isEmpty()) {
            throw new ITSException("langPointer attribute missing.");
        }
        this.rules.add(rule);
    }

    @Override
    public void applyRules(int dataCategories) {
        this.translatableAttributeRuleTriggered = false;
        this.targetPointerRuleTriggered = false;
        this.version = "0";
        this.processGlobalRules(dataCategories);
        this.processLocalRules(dataCategories);
    }

    private void removeFlag(Node node) {
        if (node == null) {
            return;
        }
        node.setUserData(FLAGNAME, null, null);
        if (node.hasChildNodes()) {
            this.removeFlag(node.getFirstChild());
        }
        if (node.getNextSibling() != null) {
            this.removeFlag(node.getNextSibling());
        }
    }

    @Override
    public void disapplyRules() {
        this.removeFlag(this.doc.getDocumentElement());
        this.translatableAttributeRuleTriggered = false;
        this.targetPointerRuleTriggered = false;
    }

    @Override
    public boolean backTracking() {
        return this.backTracking;
    }

    @Override
    public Node nextNode() {
        if (this.startTraversal) {
            this.startTraversal = false;
            ITSTrace startTrace = new ITSTrace();
            this.backTracking = false;
            startTrace.translate = true;
            startTrace.isChildDone = true;
            this.trace.push(startTrace);
            this.node = this.doc.getFirstChild();
            this.trace.push(new ITSTrace(this.trace.peek(), false));
            this.updateTraceData(this.node);
            return this.node;
        }
        if (this.node != null) {
            this.backTracking = false;
            if (!this.trace.peek().isChildDone && this.node.hasChildNodes()) {
                ITSTrace tmp = new ITSTrace(this.trace.peek(), true);
                this.trace.pop();
                this.trace.push(tmp);
                this.node = this.node.getFirstChild();
                this.trace.push(new ITSTrace(this.trace.peek(), false));
            } else {
                Node TmpNode = this.node.getNextSibling();
                if (TmpNode == null) {
                    this.node = this.node.getParentNode();
                    this.trace.pop();
                    this.backTracking = true;
                } else {
                    this.node = TmpNode;
                    this.trace.pop();
                    this.trace.push(new ITSTrace(this.trace.peek(), false));
                }
            }
        }
        this.updateTraceData(this.node);
        return this.node;
    }

    private void updateTraceData(Node newNode) {
        String[] values;
        String value;
        if (newNode == null) {
            return;
        }
        String data = (String)newNode.getUserData(FLAGNAME);
        if (data == null) {
            return;
        }
        if (data.charAt(0) != '?') {
            boolean bl = this.trace.peek().translate = data.charAt(0) == 'y';
        }
        if (!(value = this.getFlagData(data, 4)).isEmpty()) {
            this.trace.peek().idValue = value;
        }
        if (data.charAt(7) != '?') {
            this.trace.peek().domains = this.getFlagData(data, 5);
        }
        if (data.charAt(8) != '?') {
            this.trace.peek().externalRes = this.getFlagData(data, 6);
        }
        if (data.charAt(9) != '?') {
            this.trace.peek().localeFilter = this.getFlagData(data, 7);
        }
        if (data.charAt(10) != '?') {
            values = this.fromSingleString(this.getFlagData(data, 8));
            if (values[0] != null) {
                this.trace.peek().lqIssuesRef = values[0];
            }
            if (values[1] != null) {
                this.trace.peek().lqIssueType = values[1];
            }
            if (values[2] != null) {
                this.trace.peek().lqIssueComment = values[2];
            }
            if (values[3] != null) {
                this.trace.peek().lqIssueScore = values[3];
            }
            if (values[4] != null) {
                this.trace.peek().lqIssueProfileRef = values[4];
            }
        }
        if (data.charAt(11) != '?') {
            values = this.fromSingleString(this.getFlagData(data, 9));
            this.trace.peek().storeSize = values[0];
            this.trace.peek().storeSizeEncoding = values[1];
        }
        this.trace.peek().targetPointer = this.getFlagData(data, 3);
        if (data.charAt(1) != '?') {
            switch (data.charAt(1)) {
                case '0': {
                    this.trace.peek().dir = 1;
                    break;
                }
                case '1': {
                    this.trace.peek().dir = 0;
                    break;
                }
                case '2': {
                    this.trace.peek().dir = 3;
                    break;
                }
                case '3': {
                    this.trace.peek().dir = 3;
                }
            }
        }
        if (data.charAt(2) != '?') {
            switch (data.charAt(2)) {
                case '0': {
                    this.trace.peek().withinText = 0;
                    break;
                }
                case '1': {
                    this.trace.peek().withinText = 1;
                    break;
                }
                case '2': {
                    this.trace.peek().withinText = 2;
                }
            }
        }
        if (data.charAt(3) != '?') {
            this.trace.peek().term = data.charAt(3) == 'y';
            this.trace.peek().termInfo = this.getFlagData(data, 0);
        }
        if (data.charAt(4) != '?') {
            this.trace.peek().locNote = this.getFlagData(data, 1);
        }
        if (data.charAt(5) != '?') {
            boolean bl = this.trace.peek().preserveWS = data.charAt(5) == 'y';
        }
        if (data.charAt(6) != '?') {
            this.trace.peek().language = this.getFlagData(data, 2);
        }
    }

    @Override
    public void startTraversal() {
        this.node = null;
        this.trace = new Stack();
        this.startTraversal = true;
    }

    private void clearInternalGlobalRules() {
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!this.rules.get((int)i).isInternal) continue;
            this.rules.remove(i);
            --i;
        }
    }

    private void processGlobalRules(int dataCategories) {
        try {
            this.clearInternalGlobalRules();
            this.compileRules(this.doc, this.docURI, true);
            for (ITSRule rule : this.rules) {
                if ((dataCategories & rule.ruleType) == 0) continue;
                XPathExpression expr = this.xpath.compile(rule.selector);
                NodeList NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                block30: for (int i = 0; i < NL.getLength(); ++i) {
                    switch (rule.ruleType) {
                        case 2: {
                            this.setFlag(NL.item(i), 0, rule.flag ? (char)'y' : 'n', true);
                            if (NL.item(i).getNodeType() == 2 && rule.flag) {
                                this.translatableAttributeRuleTriggered = true;
                            }
                            if (rule.idValue != null) {
                                this.setFlag(NL.item(i), 4, this.resolveExpressionAsString(NL.item(i), rule.idValue), true);
                            }
                            this.setFlag(NL.item(i), 5, rule.preserveWS ? (char)'y' : '?', true);
                            continue block30;
                        }
                        case 32: {
                            this.setFlag(NL.item(i), 1, String.valueOf(rule.value).charAt(0), true);
                            continue block30;
                        }
                        case 4: {
                            this.setFlag(NL.item(i), 2, String.valueOf(rule.value).charAt(0), true);
                            continue block30;
                        }
                        case 16: {
                            this.setFlag(NL.item(i), 3, rule.flag ? (char)'y' : 'n', true);
                            switch (rule.infoType) {
                                case 1: {
                                    this.setFlag(NL.item(i), 0, this.resolvePointer(NL.item(i), rule.info), true);
                                    break;
                                }
                                case 2: {
                                    this.setFlag(NL.item(i), 0, "REF:" + rule.info, true);
                                    break;
                                }
                                case 3: {
                                    this.setFlag(NL.item(i), 0, "REF:" + this.resolvePointer(NL.item(i), rule.info), true);
                                }
                            }
                            continue block30;
                        }
                        case 8: {
                            this.setFlag(NL.item(i), 4, 'y', true);
                            switch (rule.infoType) {
                                case 1: {
                                    this.setFlag(NL.item(i), 1, rule.info, true);
                                    break;
                                }
                                case 2: {
                                    this.setFlag(NL.item(i), 1, this.resolvePointer(NL.item(i), rule.info), true);
                                    break;
                                }
                                case 3: {
                                    this.setFlag(NL.item(i), 1, "REF:" + rule.info, true);
                                    break;
                                }
                                case 4: {
                                    this.setFlag(NL.item(i), 1, "REF:" + this.resolvePointer(NL.item(i), rule.info), true);
                                }
                            }
                            continue block30;
                        }
                        case 1: {
                            this.setFlag(NL.item(i), 6, 'y', true);
                            this.setFlag(NL.item(i), 2, this.resolvePointer(NL.item(i), rule.info), true);
                            continue block30;
                        }
                        case 1024: {
                            this.setFlag(NL.item(i), 8, 'y', true);
                            this.setFlag(NL.item(i), 6, this.resolvePointer(NL.item(i), rule.info), true);
                            continue block30;
                        }
                        case 2048: {
                            this.setFlag(NL.item(i), 9, 'y', true);
                            this.setFlag(NL.item(i), 7, rule.info, true);
                            continue block30;
                        }
                        case 4096: {
                            this.setFlag(NL.item(i), 5, rule.preserveWS ? (char)'y' : '?', true);
                            continue block30;
                        }
                        case 128: {
                            if (rule.idValue == null) continue block30;
                            this.setFlag(NL.item(i), 4, this.resolveExpressionAsString(NL.item(i), rule.idValue), true);
                            continue block30;
                        }
                        case 256: {
                            List<String> list = this.resolveExpressionAsList(NL.item(i), rule.info);
                            StringBuilder tmp = new StringBuilder();
                            for (String value : list) {
                                if (rule.map != null && rule.map.containsKey(value)) {
                                    value = rule.map.get(value);
                                }
                                if (tmp.length() > 0) {
                                    tmp.append("\t");
                                }
                                tmp.append(value);
                            }
                            this.setFlag(NL.item(i), 7, 'y', true);
                            this.setFlag(NL.item(i), 5, tmp.toString(), true);
                            continue block30;
                        }
                        case 512: {
                            this.targetPointerRuleTriggered = true;
                            this.setFlag(NL.item(i), 3, rule.info, true);
                            continue block30;
                        }
                        case 8192: {
                            String data5;
                            String data4;
                            String data3;
                            String data2;
                            String data1 = rule.map.get("issuesRef");
                            if (data1 == null && !Util.isEmpty(data1 = rule.map.get("issuesRefPointer"))) {
                                data1 = this.resolvePointer(NL.item(i), data1);
                            }
                            if ((data2 = rule.map.get("type")) == null && !Util.isEmpty(data2 = rule.map.get("typePointer"))) {
                                data2 = this.resolvePointer(NL.item(i), data2);
                            }
                            if ((data3 = rule.map.get("comment")) == null && !Util.isEmpty(data3 = rule.map.get("commentPointer"))) {
                                data3 = this.resolvePointer(NL.item(i), data3);
                            }
                            if ((data4 = rule.map.get("score")) == null && !Util.isEmpty(data4 = rule.map.get("scorePointer"))) {
                                data4 = this.resolvePointer(NL.item(i), data4);
                            }
                            if ((data5 = rule.map.get("profileRef")) == null && !Util.isEmpty(data5 = rule.map.get("profileRefPointer"))) {
                                data5 = this.resolvePointer(NL.item(i), data5);
                            }
                            this.setFlag(NL.item(i), 10, 'y', true);
                            this.setFlag(NL.item(i), 8, this.toSingleString(data1, data2, data3, data4, data5), true);
                            continue block30;
                        }
                        case 16384: {
                            String data2;
                            String data1 = rule.map.get("size");
                            if (data1 == null && !Util.isEmpty(data1 = rule.map.get("sizePointer"))) {
                                data1 = this.resolvePointer(NL.item(i), data1);
                            }
                            if ((data2 = rule.map.get("encoding")) == null && !Util.isEmpty(data2 = rule.map.get("encodingPointer"))) {
                                data2 = this.resolvePointer(NL.item(i), data2);
                            }
                            this.setFlag(NL.item(i), 11, 'y', true);
                            this.setFlag(NL.item(i), 9, this.toSingleString(data1, data2), true);
                        }
                    }
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private String toSingleString(String ... values) {
        StringBuilder data = new StringBuilder();
        for (String value : values) {
            if (value == null) {
                data.append("\u001a");
            }
            if (value != null) {
                data.append(value);
            }
            data.append("\u001d");
        }
        return data.toString();
    }

    private String[] fromSingleString(String data) {
        String[] values = data.split("\u001d", -1);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals("\u001a")) continue;
            values[i] = null;
        }
        return values;
    }

    private void processLocalRules(int dataCategories) {
        try {
            String[] ori;
            String oriData;
            String[] values;
            Attr attr;
            int i;
            NodeList NL;
            XPathExpression expr;
            if ((dataCategories & 2) > 0) {
                expr = this.xpath.compile("//*/@its:translate|//its:span/@translate");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "translateRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    String value = attr.getValue();
                    if (!"yes".equals(value) && !"no".equals(value)) {
                        throw new ITSException("Invalid value for 'translate'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 0, value.charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x20) > 0) {
                expr = this.xpath.compile("//*/@its:dir|//its:span/@dir");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "dirRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    int n = 1;
                    if ("rtl".equals(attr.getValue())) {
                        n = 1;
                    } else if ("ltr".equals(attr.getValue())) {
                        n = 0;
                    } else if ("rlo".equals(attr.getValue())) {
                        n = 2;
                    } else if ("lro".equals(attr.getValue())) {
                        n = 3;
                    } else {
                        throw new ITSException("Invalid value for 'dir'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 1, String.format("%d", n).charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x10) > 0) {
                expr = this.xpath.compile("//*/@its:term|//its:span/@term|//*/@its:termInfoRef|//its:span/@termInfoRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i2 = 0; i2 < NL.getLength(); ++i2) {
                    attr = (Attr)NL.item(i2);
                    String localName = attr.getLocalName();
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "termRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    if (localName.equals("term")) {
                        String value = attr.getValue();
                        if (!"yes".equals(value) && !"no".equals(value)) {
                            throw new ITSException("Invalid value for 'term'.");
                        }
                        this.setFlag((Node)attr.getOwnerElement(), 3, value.charAt(0), attr.getSpecified());
                        continue;
                    }
                    if (!localName.equals("termInfoPointer")) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 0, "REF:" + this.resolvePointer(attr.getOwnerElement(), attr.getValue()), attr.getSpecified());
                }
            }
            if ((dataCategories & 8) > 0) {
                expr = this.xpath.compile("//*/@its:locNote|//its:span/@locNote|//*/@its:locNoteRef|//its:span/@locNoteRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i3 = 0; i3 < NL.getLength(); ++i3) {
                    attr = (Attr)NL.item(i3);
                    String localName = attr.getLocalName();
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "locNoteRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 4, 'y', attr.getSpecified());
                    if (localName.equals("locNote")) {
                        this.setFlag((Node)attr.getOwnerElement(), 1, attr.getValue(), attr.getSpecified());
                        continue;
                    }
                    if (!localName.equals("termInfoPointer")) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 1, "REF:" + this.resolvePointer(attr.getOwnerElement(), attr.getValue()), attr.getSpecified());
                }
            }
            if ((dataCategories & 1) > 0) {
                expr = this.xpath.compile("//*/@xml:lang");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    this.setFlag((Node)attr.getOwnerElement(), 6, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 2, attr.getValue(), attr.getSpecified());
                }
            }
            if ((dataCategories & 4) > 0 && this.isVersion2()) {
                expr = this.xpath.compile("//*/@its:withinText");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    char ch;
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "withinTextRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    String value = attr.getValue();
                    if ("no".equals(value)) {
                        ch = '0';
                    } else if ("yes".equals(value)) {
                        ch = '1';
                    } else if ("nested".equals(value)) {
                        ch = '2';
                    } else {
                        throw new ITSException("Invalid value for 'withinText'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 2, ch, attr.getSpecified());
                }
            }
            expr = this.xpath.compile("//*/@xml:space");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value = attr.getValue();
                if (!"preserve".equals(value) && !"default".equals(value)) {
                    throw new ITSException("Invalid value for 'xml:space'.");
                }
                this.setFlag((Node)attr.getOwnerElement(), 5, "preserve".equals(value) ? (char)'y' : '?', attr.getSpecified());
            }
            if ((dataCategories & 0x800) > 0 && this.isVersion2()) {
                expr = this.xpath.compile("//*/@its:localeFilterList|//its:span/@localeFilterList");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "localeFilterRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    String value = this.retrieveLocaleFilterList(attr.getOwnerElement(), qualified);
                    this.setFlag((Node)attr.getOwnerElement(), 9, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 7, value, attr.getSpecified());
                }
            }
            expr = this.xpath.compile("//*/@xml:id");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value = attr.getValue();
                if (value == null || value.length() <= 0) continue;
                this.setFlag((Node)attr.getOwnerElement(), 4, value, attr.getSpecified());
            }
            if ((dataCategories & 0x2000) > 0 && this.isVersion2()) {
                expr = this.xpath.compile("//*/@its:locQualityIssueType|//its:span/@locQualityIssueType|//*/@its:locQualityIssueComment|//its:span/@locQualityIssueComment|//*/@its:locQualityIssuesRef|//its:span/@locQualityIssuesRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "locQualityIssueRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    values = this.retrieveLocQualityIssueData(attr.getOwnerElement(), qualified);
                    oriData = (String)attr.getOwnerElement().getUserData(FLAGNAME);
                    if (oriData != null) {
                        ori = this.fromSingleString(this.getFlagData(oriData, 8));
                        if (values[0] == null) {
                            values[0] = ori[0];
                        }
                        if (values[1] == null) {
                            values[1] = ori[1];
                        }
                        if (values[2] == null) {
                            values[2] = ori[2];
                        }
                        if (values[3] == null) {
                            values[3] = ori[3];
                        }
                        if (values[4] == null) {
                            values[4] = ori[4];
                        }
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 10, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 8, this.toSingleString(values[0], values[1], values[2], values[3], values[4]), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x4000) > 0 && this.isVersion2()) {
                expr = this.xpath.compile("//*/@its:storageSize|//its:span/@storageSize");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "storageSizeRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals(ITS_NS_URI);
                    }
                    values = this.retrieveStorageSizeData(attr.getOwnerElement(), qualified);
                    oriData = (String)attr.getOwnerElement().getUserData(FLAGNAME);
                    if (oriData != null) {
                        ori = this.fromSingleString(this.getFlagData(oriData, 9));
                        if (values[0] == null) {
                            values[0] = ori[0];
                        }
                        if (values[1] == null) {
                            values[1] = ori[1];
                        }
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 11, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 9, this.toSingleString(values[0], values[1]), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x200) > 0 && this.isVersion2()) {
                expr = this.xpath.compile("//*/@its:targetPointer");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    String value;
                    attr = (Attr)NL.item(i);
                    if (ITS_NS_URI.equals(attr.getOwnerElement().getNamespaceURI()) && "targetPointerRule".equals(attr.getOwnerElement().getLocalName()) || (value = attr.getValue()) == null) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 3, value, attr.getSpecified());
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private String retrieveLocaleFilterList(Element elem, boolean qualified) {
        if (qualified) {
            return elem.getAttributeNS(ITS_NS_URI, "localeFilterList").trim();
        }
        return elem.getAttribute("localeFilterList").trim();
    }

    private String[] retrieveStorageSizeData(Element elem, boolean qualified) {
        String[] data = new String[2];
        if (qualified) {
            if (elem.hasAttributeNS(ITS_NS_URI, "storageSize")) {
                data[0] = elem.getAttributeNS(ITS_NS_URI, "storageSize");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "storageSizeEncoding")) {
                data[1] = elem.getAttributeNS(ITS_NS_URI, "storageSizeEncoding");
            }
        } else {
            if (elem.hasAttribute("storageSize")) {
                data[0] = elem.getAttribute("storageSize");
            }
            if (elem.hasAttribute("storageSizeEncoding")) {
                data[1] = elem.getAttribute("storageSizeEncoding");
            }
        }
        return data;
    }

    private String[] retrieveLocQualityIssueData(Element elem, boolean qualified) {
        String[] data = new String[5];
        if (qualified) {
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssuesRef")) {
                data[0] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssuesRef");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueType")) {
                data[1] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueType");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueComment")) {
                data[2] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueComment");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueScore")) {
                data[3] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueScore");
            }
            if (elem.hasAttributeNS(ITS_NS_URI, "locQualityIssueProfileRef")) {
                data[4] = elem.getAttributeNS(ITS_NS_URI, "locQualityIssueProfileRef");
            }
        } else {
            if (elem.hasAttribute("locQualityIssuesRef")) {
                data[0] = elem.getAttribute("locQualityIssuesRef");
            }
            if (elem.hasAttribute("locQualityIssueType")) {
                data[1] = elem.getAttribute("locQualityIssueType");
            }
            if (elem.hasAttribute("locQualityIssueComment")) {
                data[2] = elem.getAttribute("locQualityIssueComment");
            }
            if (elem.hasAttribute("locQualityIssueScore")) {
                data[3] = elem.getAttribute("locQualityIssueScore");
            }
            if (elem.hasAttribute("locQualityIssueProfileRef")) {
                data[4] = elem.getAttribute("locQualityIssueProfileRef");
            }
        }
        return data;
    }

    private boolean isVersion2() throws XPathExpressionException {
        if (this.version.equals("0")) {
            XPathExpression expr = this.xpath.compile("//*/@its:version|//its:span/@version");
            NodeList NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            if (NL == null || NL.getLength() == 0) {
                this.version = ITS_VERSION2;
            } else {
                if (NL.getLength() > 0) {
                    this.version = ((Attr)NL.item(0)).getValue();
                    if (!this.version.equals(ITS_VERSION1) && !this.version.equals(ITS_VERSION2)) {
                        throw new ITSException(String.format("Invalid or missing ITS version (\"%s\")", this.version));
                    }
                }
                if (NL.getLength() > 1) {
                    throw new ITSException("More than one ITS version is defined in this document.");
                }
            }
        }
        return this.version.equals(ITS_VERSION2);
    }

    public static String getTextContent(Node node) {
        Node tmp = node.getFirstChild();
        while (tmp != null) {
            if (tmp.getNodeType() == 3) {
                return tmp.getNodeValue();
            }
            tmp = tmp.getNextSibling();
        }
        return "";
    }

    private String resolvePointer(Node node, String pointer) {
        try {
            XPathExpression expr = this.xpath.compile(pointer);
            NodeList list = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            if (list == null || list.getLength() == 0) {
                return "";
            }
            switch (list.item(0).getNodeType()) {
                case 1: {
                    return ITSEngine.getTextContent(list.item(0));
                }
                case 2: {
                    return list.item(0).getNodeValue();
                }
            }
        }
        catch (XPathExpressionException e) {
            return "Bad XPath expression in pointer \"" + pointer + "\".";
        }
        return "pointer(" + pointer + ")";
    }

    private String resolveExpressionAsString(Node node, String expression) {
        try {
            XPathExpression expr = this.xpath.compile(expression);
            return (String)expr.evaluate(node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            return "Bab XPath expression \"" + expression + "\".";
        }
    }

    private List<String> resolveExpressionAsList(Node node, String expression) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            XPathExpression expr = this.xpath.compile(expression);
            NodeList nl = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node tmpNode = nl.item(i);
                if (tmpNode.getNodeType() == 1) {
                    list.add(tmpNode.getTextContent());
                    continue;
                }
                list.add(tmpNode.getNodeValue());
            }
        }
        catch (XPathExpressionException e) {
            list.add("Bab XPath expression \"" + expression + "\".");
        }
        return list;
    }

    private void setFlag(Node node, int position, char value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        if (override || data.charAt(position) != '?') {
            data.setCharAt(position, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private void setFlag(Node node, int position, String value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (override || n2 > n1 + 1) {
            data.replace(n1 + 1, n2, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private String getFlagData(String data, int position) {
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (n2 > n1 + 1) {
            return data.substring(n1 + 1, n2);
        }
        return "";
    }

    @Override
    public boolean getTranslate(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().translate;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return false;
        }
        return tmp.charAt(0) == 'y';
    }

    @Override
    public String getTargetPointer() {
        return this.trace.peek().targetPointer;
    }

    @Override
    public String getIdValue(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().idValue;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        return this.getFlagData(tmp, 4);
    }

    @Override
    public int getDirectionality() {
        return this.trace.peek().dir;
    }

    @Override
    public int getDirectionality(Attr attribute) {
        if (attribute == null) {
            return 1;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return 1;
        }
        return tmp.charAt(1);
    }

    @Override
    public int getWithinText() {
        return this.trace.peek().withinText;
    }

    @Override
    public boolean getTerm(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().term;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return false;
        }
        return tmp.charAt(3) == 'y';
    }

    @Override
    public String getTermInfo(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().termInfo;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(3) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 0);
    }

    @Override
    public String getLocNote() {
        return this.trace.peek().locNote;
    }

    @Override
    public String getLocNote(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(4) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 1);
    }

    @Override
    public String getLocNoteType() {
        return "TODO";
    }

    @Override
    public String getLocNoteType(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        return "TODO";
    }

    @Override
    public String getDomains() {
        return this.trace.peek().domains;
    }

    @Override
    public String getDomains(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(7) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 5);
    }

    @Override
    public boolean preserveWS() {
        return this.trace.peek().preserveWS;
    }

    @Override
    public String getLanguage() {
        return this.trace.peek().language;
    }

    @Override
    public String getExternalResourceRef() {
        return this.trace.peek().externalRes;
    }

    @Override
    public String getExternalResourceRef(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(8) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 6);
    }

    @Override
    public String getLocaleFilter() {
        return this.trace.peek().localeFilter;
    }

    @Override
    public String getLocQualityIssuesRef() {
        return this.trace.peek().lqIssuesRef;
    }

    @Override
    public String getLocQualityIssueType() {
        return this.trace.peek().lqIssueType;
    }

    @Override
    public String getLocQualityIssueComment() {
        return this.trace.peek().lqIssueComment;
    }

    @Override
    public String getLocQualityIssueScore() {
        return this.trace.peek().lqIssueScore;
    }

    @Override
    public String getLocQualityIssueProfileRef() {
        return this.trace.peek().lqIssueProfileRef;
    }

    @Override
    public String getStorageSize() {
        return this.trace.peek().storeSize;
    }

    @Override
    public String getStorageSize(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(11) != 'y') {
            return null;
        }
        String[] values = this.fromSingleString(this.getFlagData(tmp, 9));
        return values[0];
    }

    @Override
    public String getStorageSizeEncoding() {
        String tmp = this.trace.peek().storeSizeEncoding;
        if (tmp == null) {
            return "UTF-8";
        }
        return tmp;
    }

    @Override
    public String getStorageSizeEncoding(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(11) != 'y') {
            return null;
        }
        String[] values = this.fromSingleString(this.getFlagData(tmp, 9));
        if (values[1] == null) {
            return "UTF-8";
        }
        return values[1];
    }
}

