/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.okapi.common.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.its.ITSEngine;
import org.w3c.its.ITraversal;

public class Main {
    public static final String DC_TRANSLATE = "translate";
    public static final String DC_LOCALIZATIONNOTE = "locnote";
    public static final String DC_TERMINOLOGY = "terminology";
    public static final String DC_DIRECTIONALITY = "dir";
    public static final String DC_LANGUAGEINFORMATION = "lang";
    public static final String DC_WITHINTEXT = "withintext";
    public static final String DC_IDVALUE = "idvalue";
    public static final String DC_DOMAIN = "domain";
    public static final String DC_LOCALEFILTER = "localefilter";
    public static final String DC_LOCQUALITYISSUE = "locqualityissue";
    public static final String DC_EXTERNALRESOURCE = "externalresource";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintWriter writer = null;
        try {
            Node node;
            System.out.println("ITSTest - Test File Geneator for ITS");
            File inputFile = null;
            File outputFile = null;
            File rulesFile = null;
            String dc = DC_TRANSLATE;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-r")) {
                    rulesFile = new File(args[++i]);
                    continue;
                }
                if (arg.equals("-dc")) {
                    dc = args[++i].toLowerCase();
                    continue;
                }
                if (arg.equals("-?")) {
                    Main.showUsage();
                    return;
                }
                if (arg.equals("-l")) {
                    System.out.println("dir\ndomain\nexternalresource\nidvalue\nlang\nlocalefilter\nlocnote\nlocqualityissue\nterminology\ntranslate\nwithintext");
                    continue;
                }
                if (inputFile == null) {
                    inputFile = new File(args[i]);
                    continue;
                }
                outputFile = new File(args[i]);
            }
            if (inputFile == null) {
                Main.showUsage();
                return;
            }
            if (outputFile == null) {
                String name = inputFile.getAbsolutePath();
                int n = name.lastIndexOf(46);
                if (n > -1) {
                    name = name.substring(0, n);
                }
                name = name + "output";
                name = name + ".txt";
                outputFile = new File(name);
            }
            System.out.println("   input: " + inputFile.getAbsolutePath());
            System.out.println("  output: " + outputFile.getAbsolutePath());
            if (rulesFile != null) {
                System.out.print("   rules: " + rulesFile.getAbsolutePath());
            }
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            fact.setValidating(false);
            Util.createDirectories(outputFile.getAbsolutePath());
            writer = new PrintWriter(outputFile.getAbsolutePath(), "UTF-8");
            Document doc = fact.newDocumentBuilder().parse(inputFile);
            ITraversal trav = Main.applyITSRules(doc, inputFile, rulesFile);
            String path = null;
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(1);
            trav.startTraversal();
            while ((node = trav.nextNode()) != null) {
                switch (node.getNodeType()) {
                    case 1: {
                        int n;
                        if (trav.backTracking()) {
                            int n2 = path.lastIndexOf(47);
                            if (n2 > -1) {
                                path = path.substring(0, n2);
                            }
                            stack.pop();
                            break;
                        }
                        Element element = (Element)node;
                        Node prev = element;
                        while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
                        }
                        if (prev != null && prev.getNodeName().equals(element.getNodeName())) {
                            stack.push((Integer)stack.peek() + 1);
                        } else {
                            stack.push(1);
                        }
                        if (prev != null && (n = path.lastIndexOf(47)) > -1) {
                            path = path.substring(0, n);
                        }
                        path = element == doc.getDocumentElement() ? "/" + element.getNodeName() : path + String.format("/%s[%d]", element.getNodeName(), stack.peek());
                        Main.output(writer, dc, path, trav, null);
                        if (!element.hasAttributes()) break;
                        NamedNodeMap map = element.getAttributes();
                        ArrayList<String> list = new ArrayList<String>();
                        for (int i = 0; i < map.getLength(); ++i) {
                            list.add(((Attr)map.item(i)).getNodeName());
                        }
                        Collections.sort(list);
                        for (String attrName : list) {
                            Attr attr = (Attr)map.getNamedItem(attrName);
                            if (attr.getNodeName().startsWith("xmlns:")) continue;
                            Main.output(writer, dc, path + "/@" + attr.getNodeName(), trav, attr);
                        }
                        break;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private static void showUsage() {
        System.out.println("Usage: <inputFile>[ <outputFile>][ <options>]");
        System.out.println("Where the options are:");
        System.out.println(" -? shows this help");
        System.out.println(" -r <ruleFile> : associates the input with an ITS rule file");
        System.out.println(" -l : lists all the avaibale data categories to use with -dc");
        System.out.println(" -dc <data-category> : sets the data category to process (default=translate)");
    }

    private static void output(PrintWriter writer, String dc, String path, ITraversal trav, Attr attr) {
        writer.print(path + "\t");
        String out1 = null;
        if (dc.equals(DC_TRANSLATE)) {
            String string = out1 = trav.getTranslate(attr) ? "yes" : "no";
            if (out1 != null) {
                writer.print(String.format("its:translate=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_LOCALIZATIONNOTE)) {
            out1 = attr != null ? trav.getLocNote(attr) : trav.getLocNote();
            if (out1 != null) {
                writer.print(String.format("its:locNote=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
            writer.print("\t");
            out1 = attr != null ? trav.getLocNoteType(attr) : trav.getLocNoteType();
            if (out1 != null) {
                writer.print(String.format("its:locNoteType=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_TERMINOLOGY)) {
            String string = out1 = trav.getTerm(attr) ? "yes" : "no";
            if (out1 != null) {
                writer.print(String.format("its:term=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
            writer.print("\t");
            out1 = trav.getTermInfo(attr);
            if (out1 != null) {
                writer.print(String.format("its:termInfo=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_DIRECTIONALITY)) {
            int dir = trav.getDirectionality();
            if (attr != null) {
                dir = trav.getDirectionality(attr);
            }
            switch (dir) {
                case 3: {
                    out1 = "lro";
                    break;
                }
                case 1: {
                    out1 = "ltr";
                    break;
                }
                case 2: {
                    out1 = "rlo";
                    break;
                }
                case 0: {
                    out1 = "rtl";
                }
            }
            writer.print(String.format("its:dir=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
        } else if (dc.equals(DC_LANGUAGEINFORMATION)) {
            out1 = trav.getLanguage();
            if (out1 != null) {
                writer.print(String.format("its:lang=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_WITHINTEXT)) {
            if (attr != null) {
                return;
            }
            int wt = trav.getWithinText();
            switch (wt) {
                case 2: {
                    out1 = "nested";
                    break;
                }
                case 0: {
                    out1 = "no";
                    break;
                }
                case 1: {
                    out1 = "yes";
                }
            }
            writer.print(String.format("its:withinText=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
        } else if (dc.equals(DC_DOMAIN)) {
            out1 = attr != null ? trav.getDomains(attr) : trav.getDomains();
            if (out1 != null) {
                writer.print(String.format("its:domains=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_LOCALEFILTER)) {
            out1 = trav.getLocaleFilter();
            if (out1 != null) {
                writer.print(String.format("its:localeFilterList=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_EXTERNALRESOURCE)) {
            out1 = attr != null ? trav.getExternalResourceRef(attr) : trav.getExternalResourceRef();
            if (out1 != null) {
                writer.print(String.format("its:externalResource=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_IDVALUE)) {
            out1 = trav.getIdValue(attr);
            if (out1 != null) {
                writer.print(String.format("its:idValue=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        } else if (dc.equals(DC_LOCQUALITYISSUE)) {
            out1 = trav.getLocQualityIssuesRef();
            if (out1 != null) {
                writer.print(String.format("its:locQualityIssuesRef=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
            writer.print("\t");
            out1 = trav.getLocQualityIssueType();
            if (out1 != null) {
                writer.print(String.format("its:locQualityIssueType=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
            writer.print("\t");
            out1 = trav.getLocQualityIssueComment();
            if (out1 != null) {
                writer.print(String.format("its:locQualityIssueComment=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
            writer.print("\t");
            out1 = trav.getLocQualityIssueScore();
            if (out1 != null) {
                writer.print(String.format("its:locQualityIssueScore=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
            writer.print("\t");
            out1 = trav.getLocQualityIssueProfileRef();
            if (out1 != null) {
                writer.print(String.format("its:locQualityIssueProfileRef=\"%s\"", Util.escapeToXML(out1, 3, false, null)));
            }
        }
        writer.print("\n");
    }

    private static ITraversal applyITSRules(Document doc, File inputFile, File rulesFile) {
        ITSEngine itsEng = new ITSEngine(doc, inputFile.toURI());
        if (rulesFile != null) {
            itsEng.addExternalRules(rulesFile.toURI());
        }
        itsEng.applyRules(65535);
        return itsEng;
    }
}

