/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.annotation.GenericAnnotation;
import org.junit.Assert;
import org.junit.Test;

public class GenericAnnotationTest {
    @Test
    public void testString() {
        GenericAnnotation ann = new GenericAnnotation("type1");
        Assert.assertEquals((Object)"type1", (Object)ann.getType());
        ann.setString("f1", "v1");
        Assert.assertEquals((Object)"v1", (Object)ann.getString("f1"));
        ann.setString("f1", "v2");
        Assert.assertEquals((Object)"v2", (Object)ann.getString("f1"));
    }

    @Test
    public void testBoolean() {
        GenericAnnotation ann = new GenericAnnotation("type1");
        Assert.assertEquals((Object)"type1", (Object)ann.getType());
        ann.setBoolean("f1", true);
        Assert.assertEquals((Object)true, (Object)ann.getBoolean("f1"));
        ann.setBoolean("f1", false);
        Assert.assertEquals((Object)false, (Object)ann.getBoolean("f1"));
    }

    @Test
    public void testStorage() {
        GenericAnnotation ann1 = new GenericAnnotation("type1");
        ann1.setBoolean("fb1", true);
        ann1.setString("fs1", "string1");
        ann1.setBoolean("fb2", false);
        ann1.setString("fs2", "");
        ann1.setString("fs3", " \t ");
        String buf = ann1.toString();
        GenericAnnotation ann2 = new GenericAnnotation("tmp");
        ann2.fromString(buf);
        Assert.assertEquals((Object)"type1", (Object)ann2.getType());
        Assert.assertEquals((Object)true, (Object)ann2.getBoolean("fb1"));
        Assert.assertEquals((Object)false, (Object)ann2.getBoolean("fb2"));
        Assert.assertEquals((Object)"string1", (Object)ann2.getString("fs1"));
        Assert.assertEquals((Object)"", (Object)ann2.getString("fs2"));
        Assert.assertEquals((Object)" \t ", (Object)ann2.getString("fs3"));
    }

    @Test
    public void testClone() {
        GenericAnnotation ann1 = new GenericAnnotation("type1");
        ann1.setString("f1", "v1");
        ann1.setBoolean("f2", true);
        GenericAnnotation ann2 = ann1.clone();
        Assert.assertEquals((Object)ann2.getType(), (Object)ann1.getType());
        Assert.assertFalse((ann2.getType() == ann1.getType() ? 1 : 0) != 0);
        Assert.assertEquals((Object)ann2.getString("f1"), (Object)ann1.getString("f1"));
        Assert.assertFalse((ann2.getString("f1") == ann1.getString("f1") ? 1 : 0) != 0);
        Assert.assertEquals((Object)ann2.getBoolean("f2"), (Object)ann1.getBoolean("f2"));
    }
}

