/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.List;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.AnnotatedSpan;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Test;

public class GenericAnnotationsTest {
    @Test
    public void testAddAndRemove() {
        GenericAnnotations anns = new GenericAnnotations();
        Assert.assertFalse((boolean)anns.hasAnnotation("type1"));
        GenericAnnotation ann = anns.add("type1");
        Assert.assertTrue((boolean)anns.hasAnnotation("type1"));
        anns.remove(ann);
        Assert.assertFalse((boolean)anns.hasAnnotation("type1"));
    }

    @Test
    public void testSeveral() {
        GenericAnnotations anns = new GenericAnnotations();
        GenericAnnotation ann1 = anns.add("type1");
        ann1.setString("name", "v1");
        GenericAnnotation ann2 = anns.add("type1");
        ann2.setString("name", "v2");
        List<GenericAnnotation> list = anns.getAnnotations("type1");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"v2", (Object)list.get(1).getString("name"));
    }

    @Test
    public void testInContent() {
        GenericAnnotations anns = new GenericAnnotations();
        TextFragment tf = new TextFragment("This is a test.");
        tf.annotate(10, 14, "lqi", anns);
        List<AnnotatedSpan> list = tf.getAnnotatedSpans("lqi");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"test", (Object)list.get((int)0).span.toString());
    }

    @Test
    public void testStorage() {
        GenericAnnotations anns1 = new GenericAnnotations();
        GenericAnnotation ann = anns1.add("type1");
        ann.setString("fs1", "value1");
        ann.setBoolean("fb1", true);
        ann = anns1.add("type1");
        ann.setString("fs1bis", "value1bis");
        ann.setBoolean("fb1bis", false);
        ann = anns1.add("type2");
        ann.setString("fs2", "value2");
        ann.setBoolean("fb2", false);
        anns1.add("typeNoData");
        String buf = anns1.toString();
        GenericAnnotations anns2 = new GenericAnnotations(buf);
        List<GenericAnnotation> list = anns2.getAnnotations("type1");
        Assert.assertEquals((Object)"value1", (Object)list.get(0).getString("fs1"));
        Assert.assertEquals((Object)true, (Object)list.get(0).getBoolean("fb1"));
        Assert.assertEquals((Object)"value1bis", (Object)list.get(1).getString("fs1bis"));
        Assert.assertEquals((Object)false, (Object)list.get(1).getBoolean("fb1bis"));
        Assert.assertEquals((Object)"value2", (Object)anns2.getAnnotations("type2").get(0).getString("fs2"));
        Assert.assertEquals((Object)false, (Object)anns2.getAnnotations("type2").get(0).getBoolean("fb2"));
        Assert.assertEquals((long)1L, (long)anns2.getAnnotations("typeNoData").size());
    }

    @Test
    public void testITS_LQI() {
        GenericAnnotations anns = new GenericAnnotations();
        GenericAnnotation ann = anns.add("its-lqi");
        ann.setString("lqiType", "typographical");
        ann.setString("lqiComment", "Sentence without capitalization");
        ann.setString("lqiProfileRef", "http://example.org/qaModel/v13");
        ann.setFloat("lqiSeverity", Float.valueOf(50.0f));
        ann.setBoolean("lqiEnabled", true);
        ann = anns.getAnnotations("its-lqi").get(0);
        Assert.assertEquals((double)50.0, (double)ann.getFloat("lqiSeverity").floatValue(), (double)0.0);
        Assert.assertEquals((Object)"typographical", (Object)ann.getString("lqiType"));
        Assert.assertEquals((Object)"Sentence without capitalization", (Object)ann.getString("lqiComment"));
        Assert.assertEquals((Object)"http://example.org/qaModel/v13", (Object)ann.getString("lqiProfileRef"));
        Assert.assertEquals((Object)true, (Object)ann.getBoolean("lqiEnabled"));
    }
}

