/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.HashSet;
import java.util.Set;
import net.sf.okapi.common.LocaleFilter;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class LocaleFilterTest {
    private LocaleId locENUS = LocaleId.fromString("en-us");
    private LocaleId locENGB = LocaleId.fromString("en-gb");
    private LocaleId locENNZ = LocaleId.fromString("en-nz");
    private LocaleId locESEQ = LocaleId.fromString("es-eq");
    private LocaleId locESUS = LocaleId.fromString("es-us");
    private LocaleId locFRFR = LocaleId.fromString("fr-fr");
    private LocaleId locFRCA = LocaleId.fromString("fr-ca");
    private LocaleId locFRCH = LocaleId.fromString("fr-ch");
    private LocaleId locFRBE = LocaleId.fromString("fr-be");
    private LocaleId locDEDE = LocaleId.fromString("de-de");
    private LocaleId locDECH = LocaleId.fromString("de-ch");
    private LocaleId locENUS_WIN = new LocaleId("en", "us", "win");
    private LocaleId locDECH_WIN = new LocaleId("de", "ch", "win");
    private LocaleId locDECH_MAC = new LocaleId("de", "ch", "mac");

    @Test
    public void testMatches() {
        LocaleFilter filter = LocaleFilter.any();
        Assert.assertTrue((boolean)filter.matches(LocaleId.EMPTY));
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)LocaleFilter.anyExcept(this.locFRCA, this.locENUS).matches(this.locFRCA));
        Assert.assertFalse((boolean)LocaleFilter.anyExcept(this.locFRCA, this.locENUS).matches(this.locENUS));
        Assert.assertTrue((boolean)LocaleFilter.anyExcept(this.locFRCA, this.locENUS).matches(this.locESUS));
        Assert.assertTrue((boolean)LocaleFilter.anyOf(this.locFRCA, this.locENUS).matches(this.locFRCA));
        Assert.assertFalse((boolean)LocaleFilter.anyOf(this.locFRCA, this.locENUS).matches(this.locESUS));
        Assert.assertFalse((boolean)LocaleFilter.none().matches(this.locESUS));
        Assert.assertFalse((boolean)LocaleFilter.none().matches(this.locENUS));
        filter = LocaleFilter.none().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr");
        Assert.assertFalse((boolean)filter.matches(this.locDEDE));
        filter = LocaleFilter.any().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr");
        Assert.assertTrue((boolean)filter.matches(this.locDEDE));
    }

    @Test
    public void testFilter() {
        Set<LocaleId> filtered = LocaleFilter.anyOf(this.locFRFR, this.locFRCA, this.locFRCH).filter(this.locFRCA, this.locFRBE, this.locENUS);
        Assert.assertEquals((long)1L, (long)filtered.size());
        Assert.assertTrue((boolean)filtered.contains(this.locFRCA));
        Assert.assertFalse((boolean)filtered.contains(this.locFRBE));
    }

    @Test
    public void testConstructor() {
        LocaleFilter filter = new LocaleFilter();
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locFRCA));
    }

    @Test
    public void testInclude() {
        LocaleFilter filter = LocaleFilter.none();
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.include(this.locENUS);
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locFRCA));
        filter.include(this.locFRFR, this.locFRCA, this.locESUS);
        Assert.assertTrue((boolean)filter.matches(this.locFRFR));
        Assert.assertFalse((boolean)filter.matches(this.locFRCH));
        Assert.assertFalse((boolean)filter.matches(this.locFRBE));
        HashSet<LocaleId> set = new HashSet<LocaleId>();
        set.add(this.locFRBE);
        filter.include(set);
        Assert.assertTrue((boolean)filter.matches(this.locFRBE));
        filter.reset();
        filter.includePattern("en-.*");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locFRCA));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locESEQ));
        Assert.assertEquals((long)1L, (long)filter.getPatternIncludes().size());
        filter.includePattern(".*-us");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESEQ));
        Assert.assertEquals((long)2L, (long)filter.getPatternIncludes().size());
        filter.reset();
        Assert.assertEquals((long)0L, (long)filter.getPatternIncludes().size());
        filter.includePattern("e.*-us");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESEQ));
        Assert.assertFalse((boolean)filter.matches(this.locFRCA));
        Assert.assertEquals((long)1L, (long)filter.getPatternIncludes().size());
        filter.reset();
        filter.includeLanguage("en");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESEQ));
        Assert.assertFalse((boolean)filter.matches(this.locFRCA));
        Assert.assertEquals((long)1L, (long)filter.getLanguageIncludes().size());
        filter.includeLanguage("es", "fr");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locESEQ));
        Assert.assertTrue((boolean)filter.matches(this.locFRCA));
        Assert.assertFalse((boolean)filter.matches(this.locDEDE));
        Assert.assertFalse((boolean)filter.matches(this.locDECH));
        Assert.assertEquals((long)3L, (long)filter.getLanguageIncludes().size());
        filter.reset();
        filter.includeRegion("us");
        Assert.assertEquals((long)1L, (long)filter.getRegionIncludes().size());
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESEQ));
        Assert.assertFalse((boolean)filter.matches(this.locFRCA));
        filter.includeRegion("ch", "gb");
        Assert.assertEquals((long)3L, (long)filter.getRegionIncludes().size());
        Assert.assertTrue((boolean)filter.matches(this.locFRCH));
        Assert.assertTrue((boolean)filter.matches(this.locDECH));
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESEQ));
        filter.reset();
        filter.includeUserPart("ats");
        Assert.assertEquals((long)1L, (long)filter.getUserPartIncludes().size());
        Assert.assertTrue((boolean)filter.matches(LocaleId.fromPOSIXLocale("de_AT.UTF-8@ATS")));
        Assert.assertFalse((boolean)filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        filter.includeUserPart("mac", "latin");
        Assert.assertEquals((long)3L, (long)filter.getUserPartIncludes().size());
        Assert.assertTrue((boolean)filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        Assert.assertTrue((boolean)filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        Assert.assertFalse((boolean)filter.matches(LocaleId.fromPOSIXLocale("en_us@win")));
        filter.reset();
        LocaleFilter filter2 = LocaleFilter.none();
        filter2.include(this.locENUS);
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.include(filter2);
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
    }

    @Test
    public void testExclude() {
        LocaleFilter filter = LocaleFilter.any();
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.exclude(this.locENUS);
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locFRCA));
        filter.exclude(this.locFRFR, this.locFRCA, this.locESUS);
        Assert.assertFalse((boolean)filter.matches(this.locFRFR));
        Assert.assertTrue((boolean)filter.matches(this.locFRCH));
        Assert.assertTrue((boolean)filter.matches(this.locFRBE));
        HashSet<LocaleId> set = new HashSet<LocaleId>();
        set.add(this.locFRBE);
        filter.exclude(set);
        Assert.assertFalse((boolean)filter.matches(this.locFRBE));
        filter.reset();
        filter.excludePattern("en-.*");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locFRCA));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locESEQ));
        Assert.assertEquals((long)1L, (long)filter.getPatternExcludes().size());
        filter.excludePattern(".*-us");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locESEQ));
        Assert.assertEquals((long)2L, (long)filter.getPatternExcludes().size());
        filter.reset();
        Assert.assertEquals((long)0L, (long)filter.getPatternExcludes().size());
        filter.excludePattern("e.*-us");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locESEQ));
        Assert.assertTrue((boolean)filter.matches(this.locFRCA));
        Assert.assertEquals((long)1L, (long)filter.getPatternExcludes().size());
        filter.reset();
        filter.excludeLanguage("en");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locESEQ));
        Assert.assertTrue((boolean)filter.matches(this.locFRCA));
        Assert.assertEquals((long)1L, (long)filter.getLanguageExcludes().size());
        filter.excludeLanguage("es", "fr");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESEQ));
        Assert.assertFalse((boolean)filter.matches(this.locFRCA));
        Assert.assertTrue((boolean)filter.matches(this.locDEDE));
        Assert.assertTrue((boolean)filter.matches(this.locDECH));
        Assert.assertEquals((long)3L, (long)filter.getLanguageExcludes().size());
        filter.reset();
        filter.excludeRegion("us");
        Assert.assertEquals((long)1L, (long)filter.getRegionExcludes().size());
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locESEQ));
        Assert.assertTrue((boolean)filter.matches(this.locFRCA));
        filter.excludeRegion("ch", "gb");
        Assert.assertEquals((long)3L, (long)filter.getRegionExcludes().size());
        Assert.assertFalse((boolean)filter.matches(this.locFRCH));
        Assert.assertFalse((boolean)filter.matches(this.locDECH));
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locESEQ));
        filter.reset();
        filter.excludeUserPart("ats");
        Assert.assertEquals((long)1L, (long)filter.getUserPartExcludes().size());
        Assert.assertFalse((boolean)filter.matches(LocaleId.fromPOSIXLocale("de_AT.UTF-8@ATS")));
        Assert.assertTrue((boolean)filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        filter.excludeUserPart("mac", "latin");
        Assert.assertEquals((long)3L, (long)filter.getUserPartExcludes().size());
        Assert.assertFalse((boolean)filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        Assert.assertFalse((boolean)filter.matches(LocaleId.fromPOSIXLocale("sr@latin")));
        Assert.assertTrue((boolean)filter.matches(LocaleId.fromPOSIXLocale("en_us@win")));
        filter.reset();
        LocaleFilter filter2 = LocaleFilter.none();
        filter2.include(this.locENUS);
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.exclude(filter2);
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
    }

    @Test
    public void testFromString() {
        LocaleFilter filter = new LocaleFilter();
        filter.fromString("*");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.fromString("!*");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.fromString("en");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        filter.fromString("*-*");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.fromString("!*-*");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.fromString("*-us");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        filter.fromString("en-*");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        filter.fromString("en-us");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        filter.fromString("*-*-*");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_MAC));
        filter.fromString("!*-*-*");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.fromString("*-*-win");
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locDECH_MAC));
        filter.fromString("*-ch-*");
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_MAC));
        Assert.assertFalse((boolean)filter.matches(this.locENUS_WIN));
        filter.fromString("*-ch-win");
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locDECH_MAC));
        filter.fromString("de-*-*");
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_MAC));
        Assert.assertFalse((boolean)filter.matches(this.locENUS_WIN));
        filter.fromString("de-*-win");
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locDECH_MAC));
        Assert.assertFalse((boolean)filter.matches(this.locENUS_WIN));
        filter.fromString("de-ch-*");
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_MAC));
        Assert.assertFalse((boolean)filter.matches(this.locENUS_WIN));
        filter.fromString("de-ch-win");
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locDECH_MAC));
        Assert.assertFalse((boolean)filter.matches(this.locENUS_WIN));
        filter.fromString("en !en-nz");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locENNZ));
        Assert.assertFalse((boolean)filter.matches(this.locDECH));
        filter.fromString("!en-nz");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locENNZ));
        Assert.assertTrue((boolean)filter.matches(this.locDECH));
        Assert.assertTrue((boolean)filter.matches(this.locDEDE));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        filter.fromString("en !en-nz en-nz");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locENNZ));
        Assert.assertFalse((boolean)filter.matches(this.locDECH));
        Assert.assertFalse((boolean)filter.matches(this.locDEDE));
        Assert.assertFalse((boolean)filter.matches(this.locDECH_WIN));
        filter.fromString("!en-nz en-nz");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locENNZ));
        Assert.assertTrue((boolean)filter.matches(this.locDECH));
        Assert.assertTrue((boolean)filter.matches(this.locDEDE));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        filter.fromString("@e[ns]-.+");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENNZ));
        Assert.assertFalse((boolean)filter.matches(this.locDECH));
        Assert.assertFalse((boolean)filter.matches(this.locDEDE));
        Assert.assertFalse((boolean)filter.matches(this.locDECH_WIN));
        filter.fromString("!@e[ns]-.+");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENNZ));
        Assert.assertTrue((boolean)filter.matches(this.locDECH));
        Assert.assertTrue((boolean)filter.matches(this.locDEDE));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
        filter.fromString("@en-.+ @es-.+");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        Assert.assertTrue((boolean)filter.matches(this.locENGB));
        Assert.assertTrue((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertTrue((boolean)filter.matches(this.locESUS));
        Assert.assertTrue((boolean)filter.matches(this.locENNZ));
        Assert.assertFalse((boolean)filter.matches(this.locDECH));
        Assert.assertFalse((boolean)filter.matches(this.locDEDE));
        Assert.assertFalse((boolean)filter.matches(this.locDECH_WIN));
        filter.fromString("!@en-.+ !@es-.+");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        Assert.assertFalse((boolean)filter.matches(this.locENGB));
        Assert.assertFalse((boolean)filter.matches(this.locENUS_WIN));
        Assert.assertFalse((boolean)filter.matches(this.locESUS));
        Assert.assertFalse((boolean)filter.matches(this.locENNZ));
        Assert.assertTrue((boolean)filter.matches(this.locDECH));
        Assert.assertTrue((boolean)filter.matches(this.locDEDE));
        Assert.assertTrue((boolean)filter.matches(this.locDECH_WIN));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"", (Object)LocaleFilter.any().toString());
        Assert.assertEquals((Object)"!*", (Object)LocaleFilter.none().toString());
        Assert.assertEquals((Object)"* en-us", (Object)LocaleFilter.any().include(this.locENUS).toString());
        Assert.assertEquals((Object)"!en-us !de-ch-win", (Object)LocaleFilter.anyExcept(this.locENUS, this.locDECH_WIN).toString());
        Assert.assertEquals((Object)"en-us de-ch-win", (Object)LocaleFilter.anyOf(this.locENUS, this.locDECH_WIN).toString());
        Assert.assertEquals((Object)"en-us de-ch-win", (Object)LocaleFilter.build("en-us !de-ch-win de-ch-win").toString());
        Assert.assertEquals((Object)"en-us de-ch-win !de-ch", (Object)LocaleFilter.build("en-us !de-ch de-ch-win").toString());
        Assert.assertEquals((Object)"en-us de-ch-win fr", (Object)LocaleFilter.none().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals((Object)"* en-us de-ch-win fr", (Object)LocaleFilter.any().include(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals((Object)"!en-us !de-ch-win fr", (Object)LocaleFilter.any().exclude(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals((Object)"fr !en-us !de-ch-win", (Object)LocaleFilter.none().exclude(this.locENUS, this.locDECH_WIN).includeLanguage("fr").toString());
        Assert.assertEquals((Object)"!* !en-us !de-ch-win", (Object)LocaleFilter.none().exclude(this.locENUS, this.locDECH_WIN).toString());
        Assert.assertEquals((Object)"@pattern", (Object)LocaleFilter.none().includePattern("pattern").toString());
        Assert.assertEquals((Object)"@pattern ^8", (Object)LocaleFilter.none().includePattern("pattern", 8).toString());
        Assert.assertEquals((Object)"!@pattern", (Object)LocaleFilter.any().excludePattern("pattern").toString());
        Assert.assertEquals((Object)"!@pattern ^8", (Object)LocaleFilter.any().excludePattern("pattern", 8).toString());
        Assert.assertEquals((Object)"!@pattern1 ^8 !@pattern2 !@pattern3 ^2", (Object)LocaleFilter.any().excludePattern("pattern1", 8).excludePattern("pattern2").excludePattern("pattern3", 2).toString());
    }

    @Test
    public void testIncludeAfterExclude() {
        LocaleFilter filter = new LocaleFilter();
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.exclude(this.locENUS);
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.include(this.locENUS);
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.excludeLanguage("en");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.includeLanguage("en");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.excludeRegion("us");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.includeRegion("us");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
        filter.excludeUserPart("mac");
        Assert.assertFalse((boolean)filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        filter.includeUserPart("mac");
        Assert.assertTrue((boolean)filter.matches(LocaleId.fromPOSIXLocale("es_us@mac")));
        filter.excludePattern("en-.*");
        Assert.assertFalse((boolean)filter.matches(this.locENUS));
        filter.includePattern("en-.*");
        Assert.assertTrue((boolean)filter.matches(this.locENUS));
    }
}

