/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.IOException;
import java.net.URL;
import net.sf.okapi.common.MemMappedCharSequence;
import net.sf.okapi.common.ParametersTest;
import org.junit.Assert;
import org.junit.Test;

public class MemMappedCharSequenceTest {
    private MemMappedCharSequence charSequence;

    @Test
    public void testString() {
        String testString = "This is a test of the in memory string handling";
        this.charSequence = new MemMappedCharSequence(testString);
        Assert.assertEquals((long)47L, (long)this.charSequence.length());
        Assert.assertEquals((Object)"test", (Object)this.charSequence.subSequence(10, 14));
        Assert.assertEquals((Object)"test", (Object)this.charSequence.subSequence(10, 14));
        Assert.assertEquals((long)84L, (long)this.charSequence.charAt(0));
        Assert.assertTrue((boolean)this.charSequence.containsAt(testString, 0));
        Assert.assertEquals((Object)testString, (Object)this.charSequence.toString());
        Assert.assertEquals((long)25L, (long)this.charSequence.lastIndexOf("memory", testString.length()));
    }

    @Test
    public void testLarge() throws IOException {
        URL url = ParametersTest.class.getResource("/test.txt");
        this.charSequence = new MemMappedCharSequence(url, "UTF-16LE");
        Assert.assertEquals((long)7257720L, (long)this.charSequence.length());
        Assert.assertEquals((long)60L, (long)this.charSequence.charAt(1));
        Assert.assertEquals((long)85L, (long)this.charSequence.charAt(31));
        Assert.assertEquals((long)7257718L, (long)this.charSequence.lastIndexOf(">", this.charSequence.length() - 1));
        this.charSequence.close();
    }

    @Test
    public void testLowercase() throws IOException {
        URL url = ParametersTest.class.getResource("/test.txt");
        this.charSequence = new MemMappedCharSequence(url, "UTF-16LE", true);
        Assert.assertEquals((long)117L, (long)this.charSequence.charAt(31));
        this.charSequence.close();
    }
}

